/*
 * Decompiled with CFR 0.152.
 */
package monster.nor.prunes.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import monster.nor.prunes.logger.LoggerKt;
import monster.nor.prunes.utils.Quartet;
import monster.nor.prunes.utils.TupleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0006\u0010\b\u001a\u00020\u0001\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u0012\u0010\f\u001a\u00020\n*\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005\u001a\n\u0010\u000e\u001a\u00020\n*\u00020\u0005\u001a<\u0010\u000f\u001a,\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00110\u0010*\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005\u001a\u0014\u0010\u0013\u001a\u00020\u0001*\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u001a\u0012\u0010\u0016\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005\u001a\u0016\u0010\u0016\u001a\u00020\u0005*\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0018\u001a\u00020\u0005*\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\u0019\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0001\u001a)\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011*\u00020\u00052\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001c\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001e\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005\u001a\n\u0010 \u001a\u00020!*\u00020\u0005\u001a\n\u0010\"\u001a\u00020#*\u00020\u0005\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010%\u001a\u00020\u0005*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006&"}, d2={"LINE", "", "getLINE", "()Ljava/lang/String;", "baseName", "Ljava/nio/file/Path;", "getBaseName", "(Ljava/nio/file/Path;)Ljava/lang/String;", "uuid", "contentEquals", "", "file", "copyRecursively", "dst", "deleteRecursively", "directoryCompare", "Lmonster/nor/prunes/utils/Quartet;", "", "other", "firstLine", "cs", "Ljava/nio/charset/Charset;", "inCreateDirectory", "name", "inCreateFile", "inCreateFileIfNotExists", "inCreateFiles", "names", "", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/util/List;", "moveDirectoryToDirectory", "distDir", "newInputStream", "Ljava/io/InputStream;", "show", "", "showString", "toPath", "prunes"})
public final class PathUtilsKt {
    @NotNull
    private static final String LINE;

    @NotNull
    public static final String getLINE() {
        return LINE;
    }

    @NotNull
    public static final String uuid() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        return string;
    }

    @NotNull
    public static final Path toPath(@NotNull String $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Path path = Paths.get($this$toPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(this)");
        return path;
    }

    public static final boolean deleteRecursively(@NotNull Path $this$deleteRecursively) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursively, (String)"<this>");
        File file = $this$deleteRecursively.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
        return FilesKt.deleteRecursively((File)file);
    }

    @NotNull
    public static final Path moveDirectoryToDirectory(@NotNull Path $this$moveDirectoryToDirectory, @NotNull Path distDir) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$moveDirectoryToDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)distDir, (String)"distDir");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createDirectories(distDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createDirectories(this, *attributes)");
        Path path3 = distDir.resolve($this$moveDirectoryToDirectory.getFileName());
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"distDir.resolve(fileName)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            path3 = $this$moveDirectoryToDirectory;
            path2 = distDir.resolve($this$moveDirectoryToDirectory.getFileName());
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"distDir.resolve(fileName)");
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Path path4 = Files.move(path3, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"move(this, target, *options)");
            path = path4;
        } else {
            Quartet<Boolean, List<Path>, List<Path>, List<Path>> it = PathUtilsKt.directoryCompare($this$moveDirectoryToDirectory, distDir);
            boolean bl = false;
            if (it.getFirst().booleanValue()) {
                PathUtilsKt.deleteRecursively($this$moveDirectoryToDirectory);
            } else if (it.getSecond().isEmpty()) {
                PathUtilsKt.deleteRecursively($this$moveDirectoryToDirectory);
            } else {
                LoggerKt.getLog($this$moveDirectoryToDirectory).warn(Intrinsics.stringPlus((String)"\u79fb\u52d5\u5148\u306b\u5185\u5bb9\u306e\u7570\u306a\u308b\u30d5\u30a9\u30eb\u30c0\u304c\u5b58\u5728\u3059\u308b ", (Object)$this$moveDirectoryToDirectory.getFileName()));
            }
            path3 = distDir.resolve($this$moveDirectoryToDirectory.getFileName());
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"{\n            directoryC\u2026solve(fileName)\n        }");
            path = path3;
        }
        return path;
    }

    public static final boolean contentEquals(@NotNull Path $this$contentEquals, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)$this$contentEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        byte[] byArray = Files.readAllBytes($this$contentEquals);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(this)");
        byte[] byArray2 = Files.readAllBytes(file);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(this)");
        return Arrays.equals(byArray, byArray2);
    }

    @NotNull
    public static final Quartet<Boolean, List<Path>, List<Path>, List<Path>> directoryCompare(@NotNull Path $this$directoryCompare, @NotNull Path other) {
        Path path;
        Path it;
        Intrinsics.checkNotNullParameter((Object)$this$directoryCompare, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        List leftOnly = new ArrayList();
        List rightOnly = new ArrayList();
        List contentDifferent = new ArrayList();
        Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)$this$directoryCompare, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Path)element$iv;
            boolean bl = false;
            Path right = other.resolve(it.getFileName());
            Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists(right, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                path = it.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.fileName");
                leftOnly.add(path);
                continue;
            }
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isDirectory(right, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) & Files.isDirectory(it, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                if (PathUtilsKt.directoryCompare(it, right).getFirst().booleanValue()) continue;
                path = it.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.fileName");
                contentDifferent.add(path);
                continue;
            }
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            LinkOption[] linkOptionArray5 = new LinkOption[]{};
            LinkOption[] linkOptionArray6 = new LinkOption[]{};
            LinkOption[] linkOptionArray7 = new LinkOption[]{};
            if (Files.isDirectory(it, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) & Files.isRegularFile(right, Arrays.copyOf(linkOptionArray5, linkOptionArray5.length)) | Files.isRegularFile(it, Arrays.copyOf(linkOptionArray6, linkOptionArray6.length)) & Files.isDirectory(right, Arrays.copyOf(linkOptionArray7, linkOptionArray7.length))) {
                path = it.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.fileName");
                contentDifferent.add(path);
                continue;
            }
            if (PathUtilsKt.contentEquals(it, right)) continue;
            path = it.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.fileName");
            contentDifferent.add(path);
        }
        $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)other, null, (int)1, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Path)element$iv;
            boolean bl = false;
            Path left = $this$directoryCompare.resolve(it.getFileName());
            Intrinsics.checkNotNullExpressionValue((Object)left, (String)"left");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.notExists(left, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            path = it.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it.fileName");
            rightOnly.add(path);
        }
        return TupleKt.to(TupleKt.to(TuplesKt.to((Object)(rightOnly.isEmpty() && leftOnly.isEmpty() && contentDifferent.isEmpty() ? 1 : 0), (Object)leftOnly), rightOnly), contentDifferent);
    }

    public static final boolean copyRecursively(@NotNull Path $this$copyRecursively, @NotNull Path dst) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursively, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        File file = $this$copyRecursively.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
        File file2 = file;
        file = dst.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dst.toFile()");
        return FilesKt.copyRecursively$default((File)file2, (File)file, (boolean)false, null, (int)6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String firstLine(@NotNull Path $this$firstLine, @NotNull Charset cs) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$firstLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        BufferedReader bufferedReader = Files.newBufferedReader($this$firstLine, cs);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"newBufferedReader(this, cs)");
        Reader $this$useLines$iv = bufferedReader;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        closeable = (BufferedReader)closeable;
        Throwable throwable = null;
        try {
            String string2;
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Iterator itr = it.iterator();
            boolean bl3 = itr.hasNext();
            if (bl3) {
                string2 = (String)itr.next();
            } else if (!bl3) {
                string2 = "";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string = string2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    public static /* synthetic */ String firstLine$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return PathUtilsKt.firstLine(path, charset);
    }

    @NotNull
    public static final String getBaseName(@NotNull Path $this$baseName) {
        Intrinsics.checkNotNullParameter((Object)$this$baseName, (String)"<this>");
        Path path = $this$baseName.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fileName");
        return PathsKt.getNameWithoutExtension((Path)path);
    }

    @NotNull
    public static final Path inCreateFile(@NotNull Path $this$inCreateFile, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$inCreateFile, (String)"<this>");
        String string = name;
        if (string == null) {
            string = PathUtilsKt.uuid();
        }
        Path path = $this$inCreateFile.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(name ?: uuid())");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path2 = Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(this, *attributes)");
        return path2;
    }

    public static /* synthetic */ Path inCreateFile$default(Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return PathUtilsKt.inCreateFile(path, string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> inCreateFiles(@NotNull Path $this$inCreateFiles, String ... names) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$inCreateFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        String[] $this$map$iv = names;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var11_11 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Path path = $this$inCreateFiles.resolve((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(it)");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path2 = Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createFile(this, *attributes)");
            collection.add(path2);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final Path inCreateFileIfNotExists(@NotNull Path $this$inCreateFileIfNotExists, @NotNull String name) {
        Object object;
        Object object2;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$inCreateFileIfNotExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object3 = $this$inCreateFileIfNotExists;
        try {
            Path $this$inCreateFileIfNotExists_u24lambda_u2d5 = object3;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.notExists($this$inCreateFileIfNotExists_u24lambda_u2d5, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                path = Files.createDirectories($this$inCreateFileIfNotExists_u24lambda_u2d5, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(this, *attributes)");
            }
            object2 = Result.constructor-impl((Object)PathUtilsKt.inCreateFile($this$inCreateFileIfNotExists_u24lambda_u2d5, name));
        }
        catch (Throwable $this$inCreateFileIfNotExists_u24lambda_u2d5) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$inCreateFileIfNotExists_u24lambda_u2d5));
        }
        object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable == null) {
            object = object3;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            path = $this$inCreateFileIfNotExists.resolve(name);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(name)");
            object = path;
        }
        return (Path)object;
    }

    @NotNull
    public static final Path inCreateDirectory(@NotNull Path $this$inCreateDirectory, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$inCreateDirectory, (String)"<this>");
        String string = name;
        if (string == null) {
            string = PathUtilsKt.uuid();
        }
        Path target = $this$inCreateDirectory.resolve(string);
        Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(target, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(target, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                return target;
            }
            throw new IOException(Intrinsics.stringPlus((String)"\u4f5c\u308d\u3046\u3068\u3057\u305f\u30d5\u30a9\u30eb\u30c0\u306f\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u5b58\u5728\u3059\u308b\u3002", (Object)target));
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createDirectories(target, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(this, *attributes)");
        return path;
    }

    public static /* synthetic */ Path inCreateDirectory$default(Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return PathUtilsKt.inCreateDirectory(path, string);
    }

    @NotNull
    public static final Path inCreateDirectory(@NotNull Path $this$inCreateDirectory, @NotNull Path name) {
        Intrinsics.checkNotNullParameter((Object)$this$inCreateDirectory, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return PathUtilsKt.inCreateDirectory($this$inCreateDirectory, ((Object)name).toString());
    }

    @NotNull
    public static final InputStream newInputStream(@NotNull Path $this$newInputStream) {
        Intrinsics.checkNotNullParameter((Object)$this$newInputStream, (String)"<this>");
        InputStream inputStream = Files.newInputStream($this$newInputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this)");
        return inputStream;
    }

    public static final void show(@NotNull Path $this$show) {
        Intrinsics.checkNotNullParameter((Object)$this$show, (String)"<this>");
        System.out.print((Object)PathUtilsKt.showString($this$show));
    }

    @NotNull
    public static final String showString(@NotNull Path $this$showString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$showString, (String)"<this>");
        StringBuilder $this$showString_u24lambda_u2d8 = stringBuilder = new StringBuilder();
        boolean bl = false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory($this$showString, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            $this$showString_u24lambda_u2d8.append(Intrinsics.stringPlus((String)"+ ", (Object)$this$showString)).append(PathUtilsKt.getLINE());
            Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)$this$showString, null, (int)1, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                $this$showString_u24lambda_u2d8.append(PathUtilsKt.showString(it));
            }
        } else {
            $this$showString_u24lambda_u2d8.append(Intrinsics.stringPlus((String)"- ", (Object)$this$showString)).append(PathUtilsKt.getLINE());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026       }\n    }.toString()");
        return string;
    }

    static {
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        LINE = string;
    }
}

