/*
 * Decompiled with CFR 0.152.
 */
package ms.dew.auth.sdk;

import com.ecfront.dew.common.$;
import com.ecfront.dew.common.Resp;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.message.AuthException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ms.dew.Dew;
import ms.dew.auth.sdk.AuthSDKConfig;
import ms.dew.auth.sdk.TokenInfo;
import ms.dew.core.auth.dto.OptInfo;
import ms.dew.core.web.error.ErrorController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class AuthSDKHandlerInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private AuthSDKConfig authSdkConfig;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        final String uri = request.getMethod() + "@" + "/" + Dew.Info.name + request.getRequestURI();
        if (this.authSdkConfig.getWhiteList().stream().anyMatch(uri::startsWith)) {
            return super.preHandle(request, response, handler);
        }
        final String accessToken = request.getHeader("X-Access-Token");
        if (accessToken == null || accessToken.isEmpty()) {
            ErrorController.error((HttpServletRequest)request, (HttpServletResponse)response, (int)401, (String)"\u7f3a\u5c11AccessToken", (String)AuthException.class.getName());
            return false;
        }
        final String token = request.getHeader("X-User-Token");
        String authResult = $.http.get(this.authSdkConfig.getServerUrl() + "/basic/auth/validate", (Map)new HashMap<String, String>(){
            {
                this.put("X-Uri", uri);
                this.put("X-Access-Token", accessToken);
                this.put("X-User-Token", token == null ? "" : token);
            }
        });
        Resp tokenInfoR = Resp.generic((String)authResult, TokenInfo.class);
        if (tokenInfoR.ok()) {
            Dew.auth.setOptInfo((OptInfo)tokenInfoR.getBody());
            return super.preHandle(request, response, handler);
        }
        ErrorController.error((HttpServletRequest)request, (HttpServletResponse)response, (int)401, (String)tokenInfoR.getMessage(), (String)AuthException.class.getName());
        return false;
    }
}

