/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model;

import com.mule.connectors.interop.model.AttributesContainer;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ConnectorConfig
implements AttributesContainer {
    private static final String OPTIONAL = "optional";
    private static final String REQUIRED = "required";
    private String name = "";
    private Map<String, Map<String, ElementAttribute>> fields = new HashMap<String, Map<String, ElementAttribute>>();

    public ConnectorConfig() {
        this.fields.put(REQUIRED, new HashMap());
        this.fields.put(OPTIONAL, new HashMap());
    }

    @Override
    public void addRequiredAttribute(ElementAttribute attribute) {
        this.fields.get(REQUIRED).put(attribute.getXmlName(), attribute);
        this.fields.get(OPTIONAL).remove(attribute.getXmlName());
    }

    @Override
    public void addOptionalAttribute(ElementAttribute attribute) {
        this.fields.get(OPTIONAL).put(attribute.getXmlName(), attribute);
    }

    @Override
    public Map<String, ElementAttribute> getRequiredAttributes() {
        return Collections.unmodifiableMap(new HashMap<String, ElementAttribute>(this.fields.get(REQUIRED)));
    }

    @Override
    public Map<String, ElementAttribute> getOptionalAttributes() {
        return Collections.unmodifiableMap(new HashMap<String, ElementAttribute>(this.fields.get(OPTIONAL)));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

