/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model;

import java.util.HashMap;
import java.util.Map;

public class ConnectorProperties {
    private String name = "";
    private MetadataType metadataType;
    private Map<String, Boolean> fields = new HashMap<String, Boolean>();

    public void addProperty(String name, Boolean value) {
        this.fields.put(name, value);
    }

    public boolean hasTransformerDefinition() {
        return this.fields.get("transformer");
    }

    public boolean hasOAuthAuthentication() {
        return this.fields.get("OAuth-authentication");
    }

    public boolean hasConnectivitySupport() {
        return this.fields.get("connectivity-support");
    }

    public boolean hasDatasenseEnabled() {
        return this.fields.get("datasense-enabled");
    }

    public boolean hasDynamicMetadata() {
        return this.metadataType == MetadataType.DYNAMIC;
    }

    public void setMetadataType(String type) {
        String TYPE = type.toUpperCase();
        if (TYPE.equals(MetadataType.DYNAMIC.name())) {
            this.metadataType = MetadataType.DYNAMIC;
        } else if (TYPE.equals(MetadataType.STATIC.name())) {
            this.metadataType = MetadataType.STATIC;
        } else if (TYPE.equals(MetadataType.NONE.name())) {
            this.metadataType = MetadataType.NONE;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public MetadataType getMetadataType() {
        return this.metadataType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static enum MetadataType {
        DYNAMIC,
        STATIC,
        NONE;

    }
}

