/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model.processor;

import com.mule.connectors.interop.model.AttributesContainer;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.model.processor.ElementChild;
import java.util.HashMap;
import java.util.Map;

public class ConnectorProcessor
implements AttributesContainer {
    private String name = "";
    private String xmlName = "";
    private boolean hasQuerySupport = false;
    private boolean hasDatasenseEnabled = false;
    private boolean hasAutoPaging = false;
    private String inputDataMapperType = "";
    private String outputDataMapperType = "";
    private Map<String, Map<String, ElementAttribute>> fields = new HashMap<String, Map<String, ElementAttribute>>();
    private Map<String, Map<String, ElementChild>> childElements;

    public ConnectorProcessor() {
        this.fields.put("required", new HashMap());
        this.fields.put("optional", new HashMap());
        this.childElements = new HashMap<String, Map<String, ElementChild>>();
        this.childElements.put("required", new HashMap());
        this.childElements.put("optional", new HashMap());
    }

    @Override
    public void addRequiredAttribute(ElementAttribute attribute) {
        this.fields.get("required").put(attribute.getXmlName(), attribute);
        this.fields.get("optional").remove(attribute.getXmlName());
    }

    @Override
    public void addOptionalAttribute(ElementAttribute attribute) {
        this.fields.get("optional").put(attribute.getXmlName(), attribute);
    }

    @Override
    public Map<String, ElementAttribute> getRequiredAttributes() {
        return this.fields.get("required");
    }

    @Override
    public Map<String, ElementAttribute> getOptionalAttributes() {
        return this.fields.get("optional");
    }

    public void addRequiredChild(ElementChild child) {
        this.childElements.get("required").put(child.getName(), child);
        this.childElements.get("optional").remove(child.getName());
    }

    public void addOptionalChild(ElementChild child) {
        this.childElements.get("optional").put(child.getName(), child);
    }

    public Map<String, ElementChild> getRequiredChilds() {
        return this.childElements.get("required");
    }

    public Map<String, ElementChild> getOptionalChilds() {
        return this.childElements.get("optional");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String processorName) {
        this.name = processorName;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String processorXmlName) {
        this.xmlName = processorXmlName;
    }

    public boolean hasQuerySupport() {
        return this.hasQuerySupport;
    }

    public void setQuerySupport(boolean hasQuerySupport) {
        this.hasQuerySupport = hasQuerySupport;
    }

    public boolean hasDatasenseEnabled() {
        return this.hasDatasenseEnabled;
    }

    public void setDatasenseEnabled(boolean hasDatasenseEnabled) {
        this.hasDatasenseEnabled = hasDatasenseEnabled;
    }

    public boolean hasAutoPaging() {
        return this.hasAutoPaging;
    }

    public void setAutoPaging(boolean hasAutoPaging) {
        this.hasAutoPaging = hasAutoPaging;
    }

    public String getInputDataMapperType() {
        return this.inputDataMapperType;
    }

    public void setInputDataMapperType(String inputDataMapperType) {
        this.inputDataMapperType = inputDataMapperType;
    }

    public String getOutputDataMapperType() {
        return this.outputDataMapperType;
    }

    public void setOutputDataMapperType(String ouputDataMapperType) {
        this.outputDataMapperType = ouputDataMapperType;
    }
}

