/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model.processor;

import com.mule.connectors.interop.model.processor.ElementAttribute;
import java.util.HashMap;
import java.util.Map;

public class ElementChild {
    private String name;
    private String group;
    private Map<String, Map<String, ElementAttribute>> complexDescription = new HashMap<String, Map<String, ElementAttribute>>();
    private Map<String, Map<String, ElementAttribute>> referenceDescription;
    private Map<ChildDescriptionType, String> descriptionControllers;

    public ElementChild() {
        this.complexDescription.put("required", new HashMap());
        this.complexDescription.put("optional", new HashMap());
        this.referenceDescription = new HashMap<String, Map<String, ElementAttribute>>();
        this.referenceDescription.put("required", new HashMap());
        this.referenceDescription.put("optional", new HashMap());
        this.descriptionControllers = new HashMap<ChildDescriptionType, String>();
    }

    public void addRequireComplexDescriptiondAttribute(ElementAttribute attribute) {
        attribute.setGroup(this.group);
        this.complexDescription.get("required").put(attribute.getXmlName(), attribute);
        this.complexDescription.get("optional").remove(attribute.getXmlName());
    }

    public void addOptionalComplexDescriptionAttribute(ElementAttribute attribute) {
        attribute.setGroup(this.group);
        this.complexDescription.get("optional").put(attribute.getXmlName(), attribute);
    }

    public Map<String, Map<String, ElementAttribute>> getComplexDescriptionAttributes() {
        return this.complexDescription;
    }

    public void addRequiredRefDescriptionAttribute(ElementAttribute attribute) {
        attribute.setGroup(this.group);
        this.referenceDescription.get("required").put(attribute.getXmlName(), attribute);
        this.referenceDescription.get("optional").remove(attribute.getXmlName());
    }

    public void addOptionalRefDescriptionAttribute(ElementAttribute attribute) {
        attribute.setGroup(this.group);
        this.referenceDescription.get("optional").put(attribute.getXmlName(), attribute);
    }

    public Map<String, Map<String, ElementAttribute>> getRefDescriptionAttributes() {
        return this.referenceDescription;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Map<ChildDescriptionType, String> getDescriptionControllers() {
        return this.descriptionControllers;
    }

    public void addDescriptionController(ChildDescriptionType reference, String attribute) {
        if (!this.descriptionControllers.containsKey((Object)reference)) {
            this.descriptionControllers.put(reference, attribute);
        }
    }

    public static enum ChildDescriptionType {
        COMPLEX,
        REFERENCE;

    }
}

