/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.parser;

import com.mule.connectors.interop.model.AttributesContainer;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributesParser {
    public AttributesContainer addAllAttributesToContainer(AttributesContainer container, Element attributesRoot) throws XPathExpressionException {
        NodeList optional = attributesRoot.getElementsByTagName("optional");
        this.addAttributesFromListToContainer(container, optional, ElementAttribute.AttributeType.OPTIONAL);
        NodeList required = attributesRoot.getElementsByTagName("required");
        this.addAttributesFromListToContainer(container, required, ElementAttribute.AttributeType.REQUIRED);
        return container;
    }

    public void addAttributesFromListToContainer(AttributesContainer container, NodeList attrList, ElementAttribute.AttributeType type) {
        if (type == ElementAttribute.AttributeType.REQUIRED) {
            int i = 0;
            while (i < attrList.getLength()) {
                Element source = (Element)attrList.item(i);
                container.addRequiredAttribute(this.parseAttribute(source));
                ++i;
            }
        } else {
            int i = 0;
            while (i < attrList.getLength()) {
                Element source = (Element)attrList.item(i);
                container.addOptionalAttribute(this.parseAttribute(source));
                ++i;
            }
        }
    }

    public ElementAttribute parseAttribute(Element e) {
        ElementAttribute attr = new ElementAttribute();
        attr.setAttributeXmlName(e.getAttribute("name"));
        attr.setCaption(e.getAttribute("caption"));
        attr.setGroup(e.getAttribute("group"));
        attr.setJavaType(e.getAttribute("javaType"));
        attr.setType(e.getAttribute("type"));
        attr.setDefaultValue(e.getAttribute("default"));
        attr.setValue(e.getTextContent().trim());
        return attr;
    }
}

