/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.parser;

import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.model.processor.ElementChild;
import com.mule.connectors.interop.parser.AttributesParser;
import com.mule.connectors.interop.swtbot.util.BotActionsHelper;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChildElementsParser {
    private Logger logger = Logger.getLogger(BotActionsHelper.class);
    private AttributesParser attributesParser = new AttributesParser();
    private XPath xPathParser = XPathFactory.newInstance().newXPath();

    public void addAllChildsToProcessor(ConnectorProcessor processor, Element childsRoot) throws XPathExpressionException {
        NodeList optional = (NodeList)this.xPathParser.compile("./optional").evaluate(childsRoot, XPathConstants.NODESET);
        this.addAllChildsToProcessor(processor, optional, ElementAttribute.AttributeType.OPTIONAL);
        NodeList required = (NodeList)this.xPathParser.compile("./required").evaluate(childsRoot, XPathConstants.NODESET);
        this.addAllChildsToProcessor(processor, required, ElementAttribute.AttributeType.REQUIRED);
    }

    private void addAllChildsToProcessor(ConnectorProcessor processor, NodeList childsList, ElementAttribute.AttributeType type) {
        Element source;
        int i;
        if (type == ElementAttribute.AttributeType.REQUIRED || type == ElementAttribute.AttributeType.BOTH) {
            i = 0;
            while (i < childsList.getLength()) {
                source = (Element)childsList.item(i);
                processor.addRequiredChild(this.parseChildElement(source));
                ++i;
            }
        }
        if (type == ElementAttribute.AttributeType.OPTIONAL || type == ElementAttribute.AttributeType.BOTH) {
            i = 0;
            while (i < childsList.getLength()) {
                source = (Element)childsList.item(i);
                processor.addOptionalChild(this.parseChildElement(source));
                ++i;
            }
        }
    }

    private ElementChild parseChildElement(Element source) {
        ElementChild child = new ElementChild();
        String name = source.getAttribute("name");
        String group = source.getAttribute("group");
        child.setName(name);
        child.setGroup(group);
        NodeList nl = source.getElementsByTagName("attributes");
        int i = 0;
        while (i < nl.getLength()) {
            Element attr;
            int j;
            NodeList req;
            NodeList opt;
            Element e = (Element)nl.item(i);
            if (e.getAttribute("controlled").equals("complex")) {
                child.addDescriptionController(ElementChild.ChildDescriptionType.COMPLEX, e.getAttribute("caption"));
                opt = e.getElementsByTagName("optional");
                int j2 = 0;
                while (j2 < opt.getLength()) {
                    Element attr2 = (Element)opt.item(j2);
                    child.addOptionalComplexDescriptionAttribute(this.attributesParser.parseAttribute(attr2));
                    ++j2;
                }
                req = e.getElementsByTagName("required");
                j = 0;
                while (j < req.getLength()) {
                    attr = (Element)req.item(j);
                    child.addRequireComplexDescriptiondAttribute(this.attributesParser.parseAttribute(attr));
                    ++j;
                }
            } else {
                child.addDescriptionController(ElementChild.ChildDescriptionType.REFERENCE, e.getAttribute("caption"));
                opt = e.getElementsByTagName("optional");
                int j3 = 0;
                while (j3 < opt.getLength()) {
                    Element attr3 = (Element)opt.item(j3);
                    child.addOptionalRefDescriptionAttribute(this.attributesParser.parseAttribute(attr3));
                    ++j3;
                }
                req = e.getElementsByTagName("required");
                j = 0;
                while (j < req.getLength()) {
                    attr = (Element)req.item(j);
                    child.addRequiredRefDescriptionAttribute(this.attributesParser.parseAttribute(attr));
                    ++j;
                }
            }
            ++i;
        }
        NodeList clist = source.getElementsByTagName("childElements");
        int i2 = 0;
        while (i2 < clist.getLength()) {
            Element cfr_ignored_0 = (Element)clist.item(i2);
            ++i2;
        }
        return child;
    }
}

