/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.parser;

import com.mule.connectors.interop.model.ConnectorConfig;
import com.mule.connectors.interop.model.ConnectorGlobalConfig;
import com.mule.connectors.interop.parser.AttributesParser;
import com.mule.connectors.interop.swtbot.util.BotActionsHelper;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigsParser {
    private Logger logger = Logger.getLogger(BotActionsHelper.class);
    private XPath xPathParser = XPathFactory.newInstance().newXPath();
    private AttributesParser attributesParser = new AttributesParser();

    public ConnectorGlobalConfig parseConfig(Document basicData, Document overrides) throws XPathExpressionException {
        ConnectorGlobalConfig global = new ConnectorGlobalConfig();
        global.setNonOAuthConfig(this.parseNonOAuthConfig(basicData, overrides));
        global.setOAuthConfig(this.parseOAuthConfig(basicData, overrides));
        return global;
    }

    private ConnectorConfig parseNonOAuthConfig(Document basicData, Document overrides) throws XPathExpressionException {
        String simpleConfExp;
        Element simpleConfAttrs;
        String configAttExp;
        Element configAttrs;
        ConnectorConfig config = new ConnectorConfig();
        String nameExp = "/connector/simpleConfig/*[@name='name']";
        Element nameAttr = (Element)this.xPathParser.compile(nameExp).evaluate(overrides, XPathConstants.NODE);
        if (nameAttr != null) {
            config.setName(nameAttr.getTextContent());
        }
        if ((configAttrs = (Element)this.xPathParser.compile(configAttExp = "/connector/global-config/config/attributes").evaluate(basicData, XPathConstants.NODE)) != null) {
            this.attributesParser.addAllAttributesToContainer(config, configAttrs);
        }
        if ((simpleConfAttrs = (Element)this.xPathParser.compile(simpleConfExp = "/connector/simpleConfig").evaluate(overrides, XPathConstants.NODE)) != null) {
            this.attributesParser.addAllAttributesToContainer(config, simpleConfAttrs);
        }
        return config;
    }

    private ConnectorConfig parseOAuthConfig(Document basicData, Document overrides) throws XPathExpressionException {
        String oauthExp;
        Element oauthAttrs;
        String configAttExp;
        Element configAttrs;
        ConnectorConfig config = new ConnectorConfig();
        String nameExp = "/connector/oauthConfig/*[@name='name']";
        Element nameAttr = (Element)this.xPathParser.compile(nameExp).evaluate(overrides, XPathConstants.NODE);
        if (nameAttr != null) {
            config.setName(nameAttr.getTextContent());
        }
        if ((configAttrs = (Element)this.xPathParser.compile(configAttExp = "/connector/global-config/config-with-oauth/attributes").evaluate(basicData, XPathConstants.NODE)) != null) {
            this.attributesParser.addAllAttributesToContainer(config, configAttrs);
        }
        if ((oauthAttrs = (Element)this.xPathParser.compile(oauthExp = "/connector/oauthConfig").evaluate(overrides, XPathConstants.NODE)) != null) {
            this.attributesParser.addAllAttributesToContainer(config, oauthAttrs);
        }
        return config;
    }
}

