/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.parser;

import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import com.mule.connectors.interop.parser.AttributesParser;
import com.mule.connectors.interop.parser.ChildElementsParser;
import com.mule.connectors.interop.swtbot.util.BotActionsHelper;
import java.util.LinkedList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessorsParser {
    private Logger logger = Logger.getLogger(BotActionsHelper.class);
    private XPath xPathParser = XPathFactory.newInstance().newXPath();
    private AttributesParser attributesParser = new AttributesParser();
    private ChildElementsParser childElementsParser = new ChildElementsParser();

    public List<ConnectorProcessor> parseProcessors(Document basicData, Document overrides) throws XPathExpressionException {
        LinkedList<ConnectorProcessor> processorsList = new LinkedList<ConnectorProcessor>();
        String processorsExpression = "/connector/message-processors/*";
        NodeList processorOverrideNodes = (NodeList)this.xPathParser.compile(processorsExpression).evaluate(overrides, XPathConstants.NODESET);
        int i = 0;
        while (i < processorOverrideNodes.getLength()) {
            Element processorElem = (Element)processorOverrideNodes.item(i);
            ConnectorProcessor processor = this.parseProcessorFromElement(processorElem, basicData, overrides);
            processorsList.add(processor);
            ++i;
        }
        return processorsList;
    }

    private ConnectorProcessor parseProcessorFromElement(Element processorElem, Document basic, Document overrides) throws XPathExpressionException {
        String processorName = processorElem.getAttribute("name");
        String processorXmlName = processorElem.getTagName();
        ConnectorProcessor processor = new ConnectorProcessor();
        processor.setName(processorName);
        processor.setXmlName(processorXmlName);
        this.parseDatasenseInfo(processorElem, processor);
        this.parseProcessorAttributes(basic, overrides, processorXmlName, processor);
        this.parseProcessorChildElements(basic, overrides, processorXmlName, processor);
        return processor;
    }

    private void parseProcessorChildElements(Document basic, Document overrides, String processorXmlName, ConnectorProcessor processor) throws XPathExpressionException {
        Element processorOverrideChilds;
        String childElemExpression = "/connector/message-processors/" + processorXmlName + "/childElements";
        Element processorChilds = (Element)this.xPathParser.compile(childElemExpression).evaluate(basic, XPathConstants.NODE);
        if (processorChilds != null) {
            this.childElementsParser.addAllChildsToProcessor(processor, processorChilds);
        }
        if ((processorOverrideChilds = (Element)this.xPathParser.compile(childElemExpression).evaluate(overrides, XPathConstants.NODE)) != null) {
            this.childElementsParser.addAllChildsToProcessor(processor, processorOverrideChilds);
        }
    }

    private void parseProcessorAttributes(Document basic, Document overrides, String processorXmlName, ConnectorProcessor processor) throws XPathExpressionException {
        Element processorOverrideAttrs;
        String attributesExpression = "/connector/message-processors/" + processorXmlName + "/attributes";
        Element processorAttrs = (Element)this.xPathParser.compile(attributesExpression).evaluate(basic, XPathConstants.NODE);
        if (processorAttrs != null) {
            this.attributesParser.addAllAttributesToContainer(processor, processorAttrs);
        }
        if ((processorOverrideAttrs = (Element)this.xPathParser.compile(attributesExpression).evaluate(overrides, XPathConstants.NODE)) != null) {
            this.attributesParser.addAllAttributesToContainer(processor, processorOverrideAttrs);
        }
    }

    private void parseDatasenseInfo(Element processorElem, ConnectorProcessor processor) {
        Element dmapper = (Element)processorElem.getElementsByTagName("datamapper").item(0);
        String dmInput = dmapper.getAttribute("input");
        processor.setInputDataMapperType(dmInput);
        String dmOutput = dmapper.getAttribute("output");
        processor.setOutputDataMapperType(dmOutput);
        if (!(dmInput == null || dmOutput == null || dmInput.isEmpty() && dmOutput.isEmpty())) {
            processor.setDatasenseEnabled(true);
        }
    }
}

