/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.parser;

import com.mule.connectors.interop.model.ConnectorGlobalConfig;
import com.mule.connectors.interop.model.ConnectorProperties;
import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import com.mule.connectors.interop.parser.ConfigsParser;
import com.mule.connectors.interop.parser.ProcessorsParser;
import com.mule.connectors.interop.swtbot.util.BotActionsHelper;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestDataParser {
    private Logger logger = Logger.getLogger(BotActionsHelper.class);
    private XPath xPathParser = XPathFactory.newInstance().newXPath();
    private ProcessorsParser processorsParser = new ProcessorsParser();
    private ConfigsParser configsParser = new ConfigsParser();

    public ConnectorProperties parseProperties(Document overrides) throws XPathExpressionException {
        ConnectorProperties connectorProperties = new ConnectorProperties();
        String rootConnectorExp = "/connector";
        String name = ((Element)this.xPathParser.compile(rootConnectorExp).evaluate(overrides, XPathConstants.NODE)).getAttribute("name");
        connectorProperties.setName(name);
        String propertiesExpression = "/connector/properties/*";
        NodeList attributes = (NodeList)this.xPathParser.compile(propertiesExpression).evaluate(overrides, XPathConstants.NODESET);
        int i = 0;
        while (i < attributes.getLength()) {
            Element prop = (Element)attributes.item(i);
            if (prop.getTagName().equals("metadata")) {
                connectorProperties.setMetadataType(prop.getTextContent());
            } else {
                connectorProperties.addProperty(prop.getTagName(), new Boolean(prop.getTextContent()));
            }
            ++i;
        }
        return connectorProperties;
    }

    public ConnectorGlobalConfig parseConfig(Document basicDataDoc, Document overridesDoc) throws XPathExpressionException {
        return this.configsParser.parseConfig(basicDataDoc, overridesDoc);
    }

    public List<ConnectorProcessor> parseProcessors(Document basicDataDoc, Document overridesDoc) throws XPathExpressionException {
        return this.processorsParser.parseProcessors(basicDataDoc, overridesDoc);
    }
}

