/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.swtbot.util;

import com.mule.connectors.interop.model.ConnectorProperties;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.model.processor.ElementChild;
import com.mule.connectors.interop.swtbot.util.matcher.ComboHasItemWithText;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.eclipse.gef.finder.SWTGefBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;
import org.hamcrest.Matcher;

public class BotActionsHelper {
    private static final String OAUTH = "OAuth";
    private SWTGefBot bot = new SWTGefBot();
    private Logger logger = Logger.getLogger(BotActionsHelper.class);

    public void clickButton(String buttonLabel) {
        this.bot.button(buttonLabel).click();
    }

    public void selectRadio(String radioButtonLabel) {
        this.bot.radio(radioButtonLabel).click();
    }

    public void openGlobalConfigWindow(ConnectorProperties connectorProperties, String viewName) {
        this.bot.viewByTitle(viewName).setFocus();
        this.bot.toolbarButtonWithTooltip("Add").click();
        if (this.bot.activeShell().getText().equalsIgnoreCase("Choose Global Type")) {
            this.selectConfigType(connectorProperties);
            this.clickButton("OK");
        }
        SWTBotShell configRef = this.bot.shell("Global Element Properties");
        configRef.activate().setFocus();
    }

    private void selectConfigType(ConnectorProperties connectorProperties) {
        SWTBotTreeItem[] items = this.bot.tree().getTreeItem("Connector Configuration").getItems();
        if (connectorProperties.hasOAuthAuthentication()) {
            SWTBotTreeItem[] sWTBotTreeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                SWTBotTreeItem item = sWTBotTreeItemArray[n2];
                if (item.getText().contains(OAUTH) && item.getText().contains(connectorProperties.getName())) {
                    item.select();
                    break;
                }
                ++n2;
            }
        } else {
            SWTBotTreeItem[] sWTBotTreeItemArray = items;
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                SWTBotTreeItem item = sWTBotTreeItemArray[n3];
                if (!item.getText().contains(OAUTH) && item.getText().contains(connectorProperties.getName())) {
                    item.select();
                    break;
                }
                ++n3;
            }
        }
    }

    public void closeGlobalConfigWindow() {
        try {
            this.clickButton("OK");
            SWTBotShell configRef = this.bot.shell("Global Element Properties");
            SWTBotPreferences.TIMEOUT = 30000L;
            this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)configRef));
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
        }
        catch (TimeoutException timeoutException) {}
    }

    public void waitUntilProgressBarIsClosed() {
        this.waitUntilShellCloses("Progress Information");
    }

    public void waitUntilShellCloses(String shellId) {
        try {
            SWTBotPreferences.TIMEOUT = 200L;
            SWTBotShell shell = this.bot.shell(shellId);
            SWTBotPreferences.TIMEOUT = 30000L;
            this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        }
        catch (WidgetNotFoundException widgetNotFoundException) {}
    }

    public void waitUntilShellIsActive(String shellId) {
        this.bot.waitUntil(Conditions.shellIsActive((String)shellId));
    }

    public void setChildFields(Map<String, ElementChild> childs, ElementChild.ChildDescriptionType description, ElementAttribute.AttributeType type) {
        String attrType = type == ElementAttribute.AttributeType.REQUIRED ? "required" : "optional";
        for (String childName : childs.keySet()) {
            ElementChild eChild = childs.get(childName);
            String controllerName = "";
            Map<String, ElementAttribute> attrList = null;
            if (description == ElementChild.ChildDescriptionType.COMPLEX) {
                attrList = eChild.getComplexDescriptionAttributes().get(attrType);
                controllerName = eChild.getDescriptionControllers().get((Object)ElementChild.ChildDescriptionType.COMPLEX);
            } else {
                attrList = eChild.getRefDescriptionAttributes().get(attrType);
                controllerName = eChild.getDescriptionControllers().get((Object)ElementChild.ChildDescriptionType.REFERENCE);
            }
            this.logger.debug((Object)("ChildElement controller name :: " + controllerName));
            this.selectRadio(controllerName);
            this.setAttributeFields(attrList, false);
        }
    }

    public void setAttributeFields(Map<String, ElementAttribute> attributes, boolean withDynamicMetadata) {
        for (String attrName : attributes.keySet()) {
            ElementAttribute attr = attributes.get(attrName);
            if (attr.getXmlName().equals("config-ref") || attr.getValue().equals(" ")) continue;
            this.setAttributeField(attr, withDynamicMetadata);
        }
    }

    public void setAttributeField(ElementAttribute attr, boolean withDynamicMetadata) {
        String type = attr.getType();
        if (type.equals("password") || attr.getCaption().equalsIgnoreCase("password")) {
            this.setPasswordField(attr);
        } else if (type.equals("enum")) {
            this.selectInCombo(attr, true);
        } else if (type.equals("type-chooser")) {
            this.selectInCombo(attr, withDynamicMetadata);
        } else if (type.equals("boolean")) {
            this.setCheckBoxState(attr);
        } else {
            this.setStyledText(attr);
        }
    }

    private void selectInCombo(ElementAttribute attr, boolean selectFromDropdown) {
        SWTBotCombo chooser = null;
        if (selectFromDropdown) {
            Matcher comboMatcher = WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(Combo.class), WidgetMatcherFactory.withLabel((String)attr.getLabel()), WidgetMatcherFactory.inGroup((String)attr.getGroup()), ComboHasItemWithText.comboHasItemWithText(attr.getValue())});
            chooser = new SWTBotCombo((Combo)this.bot.widget(comboMatcher));
            chooser.setSelection(attr.getValue());
        } else {
            chooser = this.bot.comboBoxWithLabelInGroup(attr.getLabel(), attr.getGroup());
            chooser.setText(attr.getValue());
        }
    }

    private void setCheckBoxState(ElementAttribute attr) {
        SWTBotCheckBox cBox = this.bot.checkBox(attr.getCaption());
        if (attr.getValue().toLowerCase().equals(Boolean.toString(true).toLowerCase())) {
            cBox.select();
        } else {
            cBox.deselect();
        }
    }

    private void setPasswordField(ElementAttribute attr) {
        this.bot.textWithLabelInGroup(attr.getLabel(), attr.getGroup()).setText(attr.getValue());
    }

    private void setStyledText(ElementAttribute attr) {
        try {
            this.bot.styledTextWithLabelInGroup(attr.getLabel(), attr.getGroup()).setText(attr.getValue());
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            this.logger.error((Object)("Style Text not found with label " + attr.getLabel() + " in group " + attr.getGroup()));
            this.bot.styledTextInGroup(attr.getGroup());
        }
    }

    public void createNewProject(String name, Integer runtimeIndex) {
        SWTBotPreferences.TIMEOUT = 30000L;
        this.bot.menu("File").menu("New").menu("Mule Project").click();
        SWTBotPreferences.TIMEOUT = 15000L;
        SWTBotShell projectShell = this.bot.activeShell();
        projectShell.activate();
        this.bot.waitUntil(Conditions.shellIsActive((String)"New Mule Project"));
        this.bot.tableInGroup("Runtime").select(new int[]{runtimeIndex});
        this.bot.textWithLabelInGroup("Project Name:", "").setText(name);
        this.clickButton("Finish");
        this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)projectShell));
    }

    public void deleteProject(String projectName) {
        SWTBotPreferences.TIMEOUT = 15000L;
        SWTBotView projectExplorerView = this.bot.viewByTitle("Package Explorer");
        Tree projectTree = (Tree)this.bot.widget(org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.widgetOfType(Tree.class), projectExplorerView.getWidget());
        SWTBotTree projects = new SWTBotTree(projectTree);
        projects.select(new String[]{"newproject"});
        this.bot.menu("Edit").menu("Delete").click();
        SWTBotShell deleteShell = this.bot.activeShell();
        this.bot.checkBox().click();
        this.clickButton("OK");
        try {
            SWTBotPreferences.TIMEOUT = 200L;
            this.bot.waitUntil(Conditions.shellCloses((SWTBotShell)deleteShell));
        }
        catch (TimeoutException timeoutException) {}
        projectExplorerView.setFocus();
    }

    public void saveAllEditors() {
        this.bot.saveAllEditors();
    }

    public void selectConfig(String configName) {
        this.waitForWidgetToAppear(Combo.class, "Connector Configuration:", "Basic Settings");
        this.bot.comboBoxWithLabelInGroup("Connector Configuration:", "Basic Settings").setSelection(configName);
    }

    public void waitForWidgetToAppear(Class<? extends Widget> type, String label, String group) {
        Matcher matcher = null;
        matcher = label != null && group != null ? WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(type), WidgetMatcherFactory.withLabel((String)label), WidgetMatcherFactory.inGroup((String)"Basic Settings")}) : (label != null ? WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(type), WidgetMatcherFactory.inGroup((String)"Basic Settings")}) : (group != null ? WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(type), WidgetMatcherFactory.withLabel((String)label)}) : WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(type)})));
        this.bot.waitUntilWidgetAppears((ICondition)Conditions.waitForWidget((Matcher)matcher));
    }

    public void selectOperation(String optName) {
        this.waitForWidgetToAppear(Combo.class, "Operation:", "Basic Settings");
        this.bot.comboBoxWithLabelInGroup("Operation:", "Basic Settings").setSelection(optName);
    }

    public void selectView(String title) {
        Iterator viewIt = this.bot.views().iterator();
        boolean found = false;
        while (viewIt.hasNext() && !found) {
            SWTBotView view = (SWTBotView)viewIt.next();
            if (!view.getTitle().equalsIgnoreCase(title)) continue;
            view.setFocus();
            found = true;
        }
        if (!found) {
            throw new WidgetNotFoundException("No view found with title " + title);
        }
    }

    public void clearFields(Map<String, ElementAttribute> fields) {
        for (String key : fields.keySet()) {
            ElementAttribute e = fields.get(key);
            e.setValue("");
            this.setAttributeField(e, false);
        }
    }

    public void clearErrorsView() {
        this.selectView("Problems");
        this.waitUntilProgressBarIsClosed();
        this.saveAllEditors();
        this.bot.sleep(2000L);
        if (this.bot.tree().isVisible()) {
            this.bot.tree().select(new int[]{0});
            this.bot.menu("Edit").menu("Delete").click();
            this.bot.button("Yes").click();
            this.bot.sleep(500L);
        }
    }

    public void closeAllShells() {
        this.bot.closeAllShells();
    }

    public void closeAllEditors() {
        this.bot.closeAllEditors();
    }

    public void selectProject(String projectName) {
        SWTBotView projectExplorerView = this.bot.viewByTitle("Package Explorer");
        Tree projectTree = (Tree)this.bot.widget(org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory.widgetOfType(Tree.class), projectExplorerView.getWidget());
        new SWTBotTree(projectTree).select(new String[]{projectName});
        this.bot.sleep(500L);
    }
}

