/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.swtbot.util;

import com.mule.connectors.interop.swtbot.util.BotActionsHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.swtbot.eclipse.gef.finder.SWTGefBot;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditor;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;

public class FlowHandler {
    private Logger logger = Logger.getLogger(BotActionsHelper.class);
    private BotActionsHelper actionsHelper = new BotActionsHelper();
    private HashMap<String, Integer> componentIndexCache = new HashMap();
    private SWTGefBot gefbot;
    private SWTBotGefEditor editor;

    public FlowHandler(SWTGefBot bot) {
        this.gefbot = bot;
    }

    public SWTBotGefEditor createFlow(String projectName, String toolVersion, String ... steps) {
        LinkedList<String> flowSteps = new LinkedList<String>(Arrays.asList(steps));
        return this.createFlow(projectName, toolVersion, flowSteps);
    }

    private LinkedList<String> convertToIndexedSteps(LinkedList<String> steps) {
        LinkedList<String> namedSteps = new LinkedList<String>();
        for (String component : steps) {
            String name = String.valueOf(component) + "_" + this.getComponentIndex(component);
            namedSteps.add(name);
        }
        return namedSteps;
    }

    public SWTBotGefEditor createFlow(String projectName, String toolVersion, LinkedList<String> steps) {
        this.actionsHelper.selectProject(projectName);
        this.logger.debug((Object)"- Create Flow");
        LinkedList<String> indexedSteps = this.convertToIndexedSteps(steps);
        String endpoint = steps.removeFirst();
        this.initializeFlowWithEndpoint(projectName, endpoint);
        String currentTool = steps.removeLast();
        String current_nameInFlow = indexedSteps.removeLast();
        this.activateCloudConnector(this.editor, currentTool);
        this.logger.debug((Object)("-- Expected tool :: " + currentTool));
        this.logger.debug((Object)("-- Current tool selected :: " + this.editor.getActiveTool().getLabel()));
        this.editor.getEditPart(endpoint).click(new Point(90, 90));
        this.logger.debug((Object)("-- Clicked edit part :: " + endpoint));
        this.selectToolVersion(toolVersion);
        this.logger.debug((Object)("-- ToolVersion :: " + toolVersion));
        this.changeToolNameInFlow(currentTool, current_nameInFlow);
        this.logger.debug((Object)("-- Change Tool  " + currentTool + "  Name :: " + current_nameInFlow));
        String prevTool = current_nameInFlow;
        while (!steps.isEmpty()) {
            currentTool = steps.removeLast();
            current_nameInFlow = indexedSteps.removeLast();
            this.editor.activateTool(currentTool);
            try {
                this.editor.getEditPart(prevTool).click();
            }
            catch (NullPointerException nullPointerException) {
                this.editor.getEditPart(prevTool.split("_")[0]).click();
            }
            this.selectToolVersion(toolVersion);
            this.changeToolNameInFlow(currentTool, current_nameInFlow);
            prevTool = current_nameInFlow;
        }
        return this.editor;
    }

    private SWTBotGefEditor initializeFlowWithEndpoint(String projectName, String tool) {
        this.editor = this.gefbot.gefEditor(projectName);
        this.editor.activateDefaultTool();
        this.editor.click(10, 10);
        this.editor.activateTool(tool);
        this.editor.click(10, 10);
        return this.editor;
    }

    private Integer getComponentIndex(String component) {
        Integer index = this.componentIndexCache.get(component);
        Integer newIndex = index != null ? index + 1 : 1;
        this.componentIndexCache.put(component, newIndex);
        return newIndex;
    }

    private void selectToolVersion(String message) {
        if (this.gefbot.activeShell().getText().contains("Select a version")) {
            SWTBotShell versionShell = this.gefbot.activeShell();
            versionShell.activate();
            this.gefbot.button(message).click();
        }
    }

    private void changeToolNameInFlow(String tool, String newNameInFlow) {
        long old = SWTBotPreferences.TIMEOUT;
        SWTBotPreferences.TIMEOUT = 10000L;
        this.editor.getEditPart(tool).click();
        this.gefbot.viewByTitle(tool).setFocus();
        this.gefbot.textWithLabel("Display Name:").setText(newNameInFlow);
        this.gefbot.toolbarButtonWithTooltip("Apply Properties (null)").click();
        this.editor.click(10, 10);
        SWTBotPreferences.TIMEOUT = old;
    }

    public void selectElement(String elementName, Integer index) {
        this.getElement(elementName, index).doubleClick();
    }

    public String getElementId(String elementName, Integer index) {
        Integer maxIndex = this.componentIndexCache.get(elementName);
        if (maxIndex != null && index <= maxIndex) {
            return elementName.concat("_").concat(index.toString());
        }
        throw new WidgetNotFoundException("Element not found in flow");
    }

    public SWTBotGefEditPart getElement(String elementName, Integer index) {
        String name = this.getElementId(elementName, index);
        return this.editor.getEditPart(name);
    }

    public void selectPropertiesViewTab(String componentName, Integer index) {
        this.selectElement(componentName, index);
        String title = this.getElementId(componentName, index);
        try {
            this.gefbot.viewByTitle(title).setFocus();
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            this.gefbot.viewByTitle(title).setFocus();
        }
    }

    private void activateCloudConnector(SWTBotGefEditor editor, String name) {
        this.logger.debug((Object)("- Activate Connector " + name));
        try {
            int index = 0;
            while (!this.foundExpectedConnector(name, editor.getActiveTool())) {
                this.logger.debug((Object)("-- Index " + index));
                editor.activateTool(name, index);
                ++index;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.logger.debug((Object)("-- Connector " + name + " Not Found"));
            this.logger.error((Object)("-- Connector " + name + " Not Found"));
            throw new WidgetNotFoundException("Connector not found");
        }
    }

    private boolean foundExpectedConnector(String expected, ToolEntry activeTool) {
        return this.nameEqualsToolName(expected, this.editor.getActiveTool()) && this.isCloudConnector(this.editor.getActiveTool());
    }

    private boolean nameEqualsToolName(String name, ToolEntry activeTool) {
        String label = activeTool.getLabel();
        this.logger.debug((Object)("- Active tool :: " + activeTool.getLabel() + ", expected " + name + " => " + label.equals(name)));
        return label.equals(name);
    }

    private boolean isCloudConnector(ToolEntry activeTool) {
        String label = activeTool.getParent().getLabel();
        this.logger.debug((Object)("- Tool Label :: " + label));
        return label.equals("Connectors");
    }
}

