/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.test.base;

import com.mule.connectors.interop.model.ConnectorGlobalConfig;
import com.mule.connectors.interop.model.ConnectorProperties;
import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.parser.TestDataParser;
import com.mule.connectors.interop.swtbot.util.BotActionsHelper;
import com.mule.connectors.interop.swtbot.util.FlowHandler;
import com.mule.connectors.interop.test.rule.ConditionalExecutionRule;
import com.mule.connectors.interop.test.suite.ConnectorTestSuite;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swtbot.eclipse.gef.finder.SWTBotGefTestCase;
import org.eclipse.swtbot.eclipse.gef.finder.SWTGefBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class ConnectorTestCases
extends SWTBotGefTestCase {
    private static Document basicDataDoc = null;
    private static Document overridesDoc = null;
    protected static TestDataParser dataParser = null;
    protected static ConnectorProperties connectorProperties = null;
    protected static ConnectorGlobalConfig connectorGlobalConfig = null;
    protected static List<ConnectorProcessor> connectorProcessors = null;
    protected static SWTGefBot gefbot = new SWTGefBot();
    protected static BotActionsHelper actionsHelper = new BotActionsHelper();
    protected static FlowHandler flowHandler = new FlowHandler(gefbot);
    protected Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getCanonicalName());
    @ClassRule
    public static ConditionalExecutionRule conditionalClassExecutionRule;

    @BeforeClass
    public static void enableErrorMessages() {
        ErrorDialog.AUTOMATED_MODE = false;
    }

    @BeforeClass
    public static void cleanInitialView() {
        ConnectorTestCases.closeWelcomePage();
    }

    public static Boolean initializeConnectorData(String dataFile, String overridesFile) {
        if (basicDataDoc != null || overridesDoc != null) {
            return false;
        }
        try {
            SWTBotPreferences.PLAYBACK_DELAY = ConnectorTestSuite.defaultPlayBackDelay.intValue();
            ConnectorTestCases.initializeInputDocs(dataFile, overridesFile);
            ConnectorTestCases.initializeParser();
            ConnectorTestCases.initializeClassRulesListener();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return true;
    }

    private static void initializeInputDocs(String dataFile, String overridesFile) throws ParserConfigurationException, SAXException, IOException {
        InputStream overrideStream;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(dataFile);
        if (dataStream == null) {
            dataStream = new FileInputStream(dataFile);
        }
        if ((overrideStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(overridesFile)) == null) {
            overrideStream = new FileInputStream(overridesFile);
        }
        basicDataDoc = documentBuilder.parse(new BufferedInputStream(dataStream));
        overridesDoc = documentBuilder.parse(overrideStream);
    }

    private static void initializeParser() throws XPathExpressionException {
        dataParser = new TestDataParser();
        connectorProperties = dataParser.parseProperties(overridesDoc);
        connectorGlobalConfig = dataParser.parseConfig(basicDataDoc, overridesDoc);
        connectorProcessors = dataParser.parseProcessors(basicDataDoc, overridesDoc);
    }

    protected static void initializeClassRulesListener() {
        if (basicDataDoc != null && overridesDoc != null) {
            conditionalClassExecutionRule = new ConditionalExecutionRule(connectorProperties, null);
        }
    }

    protected static void initializeProject(String projectName, String[] flowParts, Integer runtime) {
        flowHandler = new FlowHandler(gefbot);
        actionsHelper.createNewProject(projectName, runtime);
        flowHandler.createFlow(projectName, "Use newest", flowParts);
    }

    protected static String createConfig(ElementAttribute.AttributeType attrTypes) {
        String id = flowHandler.getElementId(connectorProperties.getName(), 1);
        flowHandler.selectElement(connectorProperties.getName(), 1);
        actionsHelper.openGlobalConfigWindow(connectorProperties, id);
        String name = ConnectorTestCases.setupConfig(attrTypes);
        actionsHelper.closeGlobalConfigWindow();
        return name;
    }

    protected static String setupConfig(ElementAttribute.AttributeType type) {
        ConnectorTestCases.setAttributes(type);
        return ConnectorTestCases.getCurrentConfigName();
    }

    protected static void closeWelcomePage() {
        try {
            SWTBotPreferences.TIMEOUT = 1000L;
            gefbot.viewByTitle("Anypoint Studio Welcome Page").close();
        }
        catch (WidgetNotFoundException widgetNotFoundException) {}
    }

    protected static void safeSleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static String getCurrentConfigName() {
        String name = !connectorProperties.hasOAuthAuthentication() ? connectorGlobalConfig.getNonOAuthConfig().getName() : connectorGlobalConfig.getOAuthConfig().getName();
        return name;
    }

    private static void setAttributes(ElementAttribute.AttributeType type) {
        if (type == ElementAttribute.AttributeType.REQUIRED || type == ElementAttribute.AttributeType.BOTH) {
            Map<String, ElementAttribute> required = null;
            required = !connectorProperties.hasOAuthAuthentication() ? connectorGlobalConfig.getNonOAuthConfig().getRequiredAttributes() : connectorGlobalConfig.getOAuthConfig().getRequiredAttributes();
            actionsHelper.setAttributeFields(required, connectorProperties.hasDynamicMetadata());
        }
        if (type == ElementAttribute.AttributeType.OPTIONAL || type == ElementAttribute.AttributeType.BOTH) {
            Map<String, ElementAttribute> optional = null;
            optional = !connectorProperties.hasOAuthAuthentication() ? connectorGlobalConfig.getNonOAuthConfig().getOptionalAttributes() : connectorGlobalConfig.getOAuthConfig().getOptionalAttributes();
            actionsHelper.setAttributeFields(optional, connectorProperties.hasDynamicMetadata());
        }
    }
}

