/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.test.rule;

import com.mule.connectors.interop.model.ConnectorProperties;
import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConditionalExecutionRule
implements TestRule {
    private ConnectorProperties globalProperties = null;
    private ConnectorProcessor processorProperties = null;

    public ConditionalExecutionRule(ConnectorProperties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public ConditionalExecutionRule(ConnectorProperties globalProperties, ConnectorProcessor processorProperties) {
        this.globalProperties = globalProperties;
        this.processorProperties = processorProperties;
    }

    public Statement apply(Statement base, Description description) {
        try {
            ConditionalExecution annotation = (ConditionalExecution)description.getAnnotation(ConditionalExecution.class);
            if (annotation != null) {
                Class<? extends RuleCondition>[] rulesToSatisfy = annotation.verify();
                Statement failureStatement = this.verifyRulesAreSatisfied(rulesToSatisfy);
                if (failureStatement != null) {
                    return failureStatement;
                }
                Class<? extends RuleCondition>[] rulesToDeny = annotation.deny();
                failureStatement = this.verifyRulesAreDenied(rulesToDeny);
                if (failureStatement != null) {
                    return failureStatement;
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return base;
    }

    private Statement verifyRulesAreSatisfied(Class<? extends RuleCondition>[] rules) throws InstantiationException, IllegalAccessException {
        Class<? extends RuleCondition>[] classArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends RuleCondition> ruleClass = classArray[n2];
            final RuleCondition rule = ruleClass.newInstance();
            if (!rule.iSatisfied(this.globalProperties, this.processorProperties)) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeTrue((boolean)rule.iSatisfied(ConditionalExecutionRule.this.globalProperties, ConditionalExecutionRule.this.processorProperties));
                    }
                };
            }
            ++n2;
        }
        return null;
    }

    private Statement verifyRulesAreDenied(Class<? extends RuleCondition>[] rules) throws InstantiationException, IllegalAccessException {
        Class<? extends RuleCondition>[] classArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends RuleCondition> ruleClass = classArray[n2];
            final RuleCondition rule = ruleClass.newInstance();
            if (rule.iSatisfied(this.globalProperties, this.processorProperties)) {
                return new Statement(){

                    public void evaluate() throws Throwable {
                        Assume.assumeFalse((boolean)rule.iSatisfied(ConditionalExecutionRule.this.globalProperties, ConditionalExecutionRule.this.processorProperties));
                    }
                };
            }
            ++n2;
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConditionalExecution {
        public Class<? extends RuleCondition>[] verify() default {};

        public Class<? extends RuleCondition>[] deny() default {};
    }

    public static interface RuleCondition {
        public boolean iSatisfied(ConnectorProperties var1, ConnectorProcessor var2);
    }
}

