/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.test.suite;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

class SuiteUtils {
    private static final String OVERRIDE_FILE_FORMAT = ".*-override?.xml";
    private static final String RELATIVE_INPUT_DIRECTORY = "src/main/resources/input/";
    static final String RUN_CONNECTIVITY_TESTS = "runConnectivityTests";
    static final String RUN_DMAPPER_TESTS = "runDatamapperTests";
    static final String RUN_XML_TESTS = "runXmlTests";
    static final String GLOBAL_LOG_LEVEL = "globalLogLevel";
    static final String PLAYBACK_DELAY = "playbackDelay";
    static final String CONNECTOR_TESTDATA_FILE = "connectorTestDataFile";
    static final String CONNECTOR_OVERRIDES_FILE = "connectorOverridesFile";

    SuiteUtils() {
    }

    static final Integer getDefaultPlaybackDelay() {
        return Integer.parseInt(SuiteUtils.getSystemProperty(PLAYBACK_DELAY, "0"));
    }

    static final Level setEnviromentLogLevel() {
        String[] categories;
        Level global = Level.INFO;
        String logProperty = System.getProperty(GLOBAL_LOG_LEVEL);
        if (logProperty != null && !logProperty.equals("null")) {
            global = Level.toLevel((String)System.getProperty(GLOBAL_LOG_LEVEL));
        }
        Logger.getRootLogger().setLevel(global);
        String[] stringArray = categories = new String[]{"org.eclipse.swtbot.swt.finder.widgets", "org.eclipse.swtbot.swt.finder.finders", "org.eclipse.swtbot.swt.finder.keyboard"};
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            Logger.getLogger((String)category).setLevel(global);
            ++n2;
        }
        return global;
    }

    static final Map<String, String> getInputFiles() {
        HashMap<String, String> files = new HashMap<String, String>();
        if (!SuiteUtils.propertyIsNull(CONNECTOR_TESTDATA_FILE) && !SuiteUtils.propertyIsNull(CONNECTOR_OVERRIDES_FILE)) {
            files.put(CONNECTOR_TESTDATA_FILE, SuiteUtils.getSystemProperty(CONNECTOR_TESTDATA_FILE));
            files.put(CONNECTOR_OVERRIDES_FILE, SuiteUtils.getSystemProperty(CONNECTOR_OVERRIDES_FILE));
            return Collections.unmodifiableMap(files);
        }
        String projectRootPath = SuiteUtils.getSystemProperty("projectRootPath");
        String dataFile = "";
        String overridesFile = "";
        File input = new File(RELATIVE_INPUT_DIRECTORY);
        File[] fileArray = input.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File temp = fileArray[n2];
            if (temp.getName().matches(OVERRIDE_FILE_FORMAT)) {
                overridesFile = temp.getName();
                dataFile = temp.getName().substring(0, temp.getName().lastIndexOf("-")).concat(".xml");
            }
            ++n2;
        }
        try {
            files.put(CONNECTOR_TESTDATA_FILE, new File(projectRootPath, RELATIVE_INPUT_DIRECTORY + dataFile).getCanonicalPath());
            files.put(CONNECTOR_OVERRIDES_FILE, new File(projectRootPath, RELATIVE_INPUT_DIRECTORY + overridesFile).getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return Collections.unmodifiableMap(files);
    }

    private static final boolean propertyIsNull(String name) {
        return System.getProperty(name) == null || System.getProperty(name).equals("null");
    }

    static final String getSystemProperty(String name, String defaultVal) {
        return SuiteUtils.propertyIsNull(name) ? defaultVal : System.getProperty(name);
    }

    static final String getSystemProperty(String name) {
        return SuiteUtils.getSystemProperty(name, "");
    }
}

