/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.test.testcase;

import com.mule.connectors.interop.model.ConnectorConfig;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.test.base.ConnectorTestCases;
import com.mule.connectors.interop.test.rule.ConditionalExecutionRule;
import com.mule.connectors.interop.test.rule.condition.ConnectivityTestEnabledInSuite;
import com.mule.connectors.interop.test.rule.condition.HasConnectivitySupport;
import com.mule.connectors.interop.test.rule.condition.UsesOAuthConfiguration;
import com.mule.connectors.interop.test.suite.ConnectorTestSuite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
@ConditionalExecutionRule.ConditionalExecution(verify={ConnectivityTestEnabledInSuite.class, HasConnectivitySupport.class}, deny={UsesOAuthConfiguration.class})
public class ConnectivityTestCases
extends ConnectorTestCases {
    private static final String CONNECTION_GROUP = "Connection";
    private static final String OK = "OK";
    private static final String FAILED = "failed";
    private static final String INVALID = "invalid";
    private static final String SUCCESSFUL = "successful";
    private static final String DUMMY_STRING = "null";
    private static final String NEWPROJECT_NAME = "newproject";
    protected ConnectorConfig currentConfig = null;

    public ConnectivityTestCases(ConnectorConfig config) {
        this.currentConfig = config;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> dataProvider() throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        ConnectivityTestCases.initializeConnectorData(ConnectorTestSuite.connectorTestDataFile, ConnectorTestSuite.connectorOverridesFile);
        ArrayList<Object[]> testData = new ArrayList<Object[]>();
        testData.add(new Object[]{connectorGlobalConfig.getNonOAuthConfig()});
        return testData;
    }

    @Before
    public void createNewProjectAndOpenPropertiesView() throws Exception {
        super.setUp();
        SWTBotPreferences.TIMEOUT = 5000L;
        String projectName = NEWPROJECT_NAME;
        Integer runtimeIndex = 0;
        String[] flow = new String[]{"HTTP", connectorProperties.getName()};
        ConnectivityTestCases.initializeProject(projectName, flow, runtimeIndex);
        String connectorId = flowHandler.getElementId(connectorProperties.getName(), 1);
        flowHandler.selectElement(connectorProperties.getName(), 1);
        actionsHelper.openGlobalConfigWindow(connectorProperties, connectorId);
    }

    @After
    public void deletePreviousProject() {
        SWTBotPreferences.TIMEOUT = 5000L;
        actionsHelper.closeAllShells();
        actionsHelper.closeAllEditors();
        actionsHelper.deleteProject(NEWPROJECT_NAME);
    }

    @Test
    public void testConnectivity_ValidCredentials() {
        ConnectivityTestCases.setupConfig(ElementAttribute.AttributeType.REQUIRED);
        actionsHelper.clickButton("Test Connection...");
        SWTBotPreferences.TIMEOUT = 20000L;
        actionsHelper.waitUntilShellCloses("Progress Information");
        this.bot.sleep(1000L);
        String resultMessage = this.getConnectionResultMessage();
        MatcherAssert.assertThat((Object)resultMessage, (Matcher)Matchers.containsString((String)SUCCESSFUL));
        actionsHelper.clickButton(OK);
        actionsHelper.waitUntilShellIsActive("Global Element Properties");
    }

    @Test
    public void testConnectivity_InvalidCredentials() {
        String dummyString = DUMMY_STRING;
        SWTBotPreferences.TIMEOUT = 20000L;
        Map<String, ElementAttribute> requiredAttrs = this.currentConfig.getRequiredAttributes();
        for (String currentAttr : requiredAttrs.keySet()) {
            if (!this.isAttributeOfConnection(requiredAttrs, currentAttr)) continue;
            String oldValue = requiredAttrs.get(currentAttr).getValue();
            try {
                requiredAttrs.get(currentAttr).setValue(dummyString);
                actionsHelper.setAttributeFields(requiredAttrs, false);
                requiredAttrs.get(currentAttr).setValue(oldValue);
            }
            catch (Exception e) {
                requiredAttrs.get(currentAttr).setValue(oldValue);
                throw new RuntimeException(e);
            }
            actionsHelper.clickButton("Test Connection...");
            actionsHelper.waitUntilShellCloses("Progress Information");
            this.bot.sleep(1000L);
            String resultMessage = this.getConnectionResultMessage();
            MatcherAssert.assertThat((String)("For attribute " + currentAttr), (Object)resultMessage, (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)FAILED), (Matcher)Matchers.containsString((String)INVALID)));
            actionsHelper.clickButton(OK);
            actionsHelper.waitUntilShellIsActive("Global Element Properties");
        }
    }

    public boolean isAttributeOfConnection(Map<String, ElementAttribute> requiredAttrs, String currentAttr) {
        return requiredAttrs.get(currentAttr).getGroup().equals(CONNECTION_GROUP);
    }

    @Test
    public void testConnectivity_NoneRequiredSet() {
        SWTBotPreferences.TIMEOUT = 20000L;
        actionsHelper.clickButton("Test Connection...");
        actionsHelper.waitUntilShellCloses("Progress Information");
        this.bot.sleep(1000L);
        String resultMessage = this.getConnectionResultMessage();
        MatcherAssert.assertThat((Object)resultMessage, (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)FAILED), (Matcher)Matchers.containsString((String)INVALID)));
        actionsHelper.clickButton(OK);
        actionsHelper.waitUntilShellIsActive("Global Element Properties");
    }

    @Test
    public void testConnectivityButtonIsAvailable() {
        MatcherAssert.assertThat((Object)this.bot.button("Test Connection...").isVisible(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testPasswordFieldHasHiddenText() {
        ElementAttribute passwordAttr = this.currentConfig.getRequiredAttributes().get("password");
        Assume.assumeThat((Object)passwordAttr, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        SWTBotPreferences.TIMEOUT = 500L;
        try {
            MatcherAssert.assertThat((Object)this.bot.textWithLabelInGroup(passwordAttr.getLabel(), passwordAttr.getGroup()).isVisible(), (Matcher)Matchers.is((Object)true));
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            ConnectivityTestCases.fail((String)"password text field not found");
        }
        try {
            MatcherAssert.assertThat((Object)this.bot.checkBox("Show password").isVisible(), (Matcher)Matchers.is((Object)true));
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            ConnectivityTestCases.fail((String)"password check button not found");
        }
    }

    private String getConnectionResultMessage() {
        return this.bot.label(1).getText().toLowerCase();
    }
}

