/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.test.testcase;

import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.model.processor.ElementChild;
import com.mule.connectors.interop.test.base.ConnectorTestCases;
import com.mule.connectors.interop.test.rule.ConditionalExecutionRule;
import com.mule.connectors.interop.test.rule.condition.DMapperTestEnabledInSuite;
import com.mule.connectors.interop.test.rule.condition.HasDatasenseSupport;
import com.mule.connectors.interop.test.rule.condition.HasNoMetadata;
import com.mule.connectors.interop.test.suite.ConnectorTestSuite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditor;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
@ConditionalExecutionRule.ConditionalExecution(verify={DMapperTestEnabledInSuite.class})
public class DatamapperTestCases
extends ConnectorTestCases {
    private static final String NEWPROJECT_NAME = "newproject";
    private static final String DATA_MAPPER = "DataMapper";
    private static String projectName = "";
    private static String configName = "";
    @Rule
    public ConditionalExecutionRule conditionalTestRule;
    private ConnectorProcessor currentProcessor = null;

    public DatamapperTestCases(String name, ConnectorProcessor processor) {
        this.currentProcessor = processor;
        this.conditionalTestRule = new ConditionalExecutionRule(connectorProperties, this.currentProcessor);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> dataProvider() throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        DatamapperTestCases.initializeConnectorData(ConnectorTestSuite.connectorTestDataFile, ConnectorTestSuite.connectorOverridesFile);
        ArrayList<Object[]> testData = new ArrayList<Object[]>();
        for (ConnectorProcessor current : connectorProcessors) {
            Object[] tuple = new Object[]{current.getXmlName(), current};
            testData.add(tuple);
        }
        return testData;
    }

    @BeforeClass
    public static void projectSetup() {
        Logger.getLogger((String)"DataMapperTestCases").debug((Object)"Setup project");
        projectName = NEWPROJECT_NAME;
        String[] flow = new String[]{"HTTP", connectorProperties.getName(), DATA_MAPPER, connectorProperties.getName()};
        Integer runtimeIndex = 0;
        DatamapperTestCases.initializeProject(projectName, flow, runtimeIndex);
        configName = DatamapperTestCases.createConfig(ElementAttribute.AttributeType.REQUIRED);
    }

    @AfterClass
    public static void projectCleanUp() {
        Logger.getLogger((String)"DataMapperTestCases").debug((Object)"Cleanup project");
        actionsHelper.closeAllShells();
        actionsHelper.closeAllEditors();
        actionsHelper.deleteProject(projectName);
    }

    @Before
    public void setUp() throws Exception {
        this.logger.debug((Object)"Test setup init");
        this.initializeDMapperBuildingBlocksWithCurrentProcessorData();
        SWTBotPreferences.TIMEOUT = 5000L;
    }

    @After
    public void tearDown() {
        this.logger.debug((Object)"Test teardown init");
        this.bot.closeAllShells();
    }

    @Test
    @ConditionalExecutionRule.ConditionalExecution(verify={HasDatasenseSupport.class})
    public void testPerceptiveFlowDesign_CheckInput() {
        this.logger.debug((Object)"- testPerceptiveFlowDesign_CheckInput");
        Assume.assumeThat((Object)this.currentProcessor.getInputDataMapperType(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        SWTBotGefEditor editor = this.bot.gefEditor(NEWPROJECT_NAME);
        editor.getEditPart(DATA_MAPPER).click();
        this.bot.viewByTitle(DATA_MAPPER).setFocus();
        actionsHelper.waitUntilProgressBarIsClosed();
        SWTBotPreferences.TIMEOUT = 300L;
        try {
            MatcherAssert.assertThat((Object)this.bot.comboBoxWithLabelInGroup("Source:", "Input").getText(), (Matcher)Matchers.equalTo((Object)("Payload - " + this.currentProcessor.getInputDataMapperType())));
            MatcherAssert.assertThat((Object)this.bot.textWithLabelInGroup("Type:", "Input").getText(), (Matcher)Matchers.equalTo((Object)this.currentProcessor.getInputDataMapperType()));
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            DatamapperTestCases.fail((String)"Input fields are missing");
        }
    }

    @Test
    @ConditionalExecutionRule.ConditionalExecution(verify={HasDatasenseSupport.class})
    public void testPerceptiveFlowDesign_CheckOutput() {
        this.logger.debug((Object)"- testPerceptiveFlowDesign_CheckOutput");
        Assume.assumeThat((Object)this.currentProcessor.getOutputDataMapperType(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        SWTBotGefEditor editor = this.bot.gefEditor(NEWPROJECT_NAME);
        editor.getEditPart(DATA_MAPPER).click();
        this.bot.viewByTitle(DATA_MAPPER).setFocus();
        actionsHelper.waitUntilProgressBarIsClosed();
        SWTBotPreferences.TIMEOUT = 300L;
        try {
            MatcherAssert.assertThat((Object)this.bot.comboBoxWithLabelInGroup("Target:", "Output").getText(), (Matcher)Matchers.equalTo((Object)("Payload - " + this.currentProcessor.getOutputDataMapperType())));
            MatcherAssert.assertThat((Object)this.bot.textWithLabelInGroup("Type:", "Output").getText(), (Matcher)Matchers.equalTo((Object)this.currentProcessor.getOutputDataMapperType()));
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            DatamapperTestCases.fail((String)"Output fields are missing");
        }
    }

    @Test
    @ConditionalExecutionRule.ConditionalExecution(verify={HasDatasenseSupport.class})
    public void testOverrideMetadata_Input() {
        this.logger.debug((Object)"- testOverrideMetadata_Input");
        Assume.assumeThat((Object)this.currentProcessor.getInputDataMapperType(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        SWTBotGefEditor editor = this.bot.gefEditor(projectName);
        editor.getEditPart(DATA_MAPPER).click();
        this.bot.viewByTitle(DATA_MAPPER).setFocus();
        actionsHelper.waitUntilProgressBarIsClosed();
        try {
            this.bot.toolbarButtonWithTooltipInGroup("Edit", "Input").click();
            this.bot.comboBoxWithLabelInGroup("Connector", "Input").setSelection(configName);
            actionsHelper.selectRadio("By Operation");
            this.bot.comboBoxWithLabelInGroup("Operation", "Input").setSelection(this.currentProcessor.getXmlName());
            MatcherAssert.assertThat((Object)this.bot.comboBoxWithLabelInGroup("Object", "Input").items(), (Matcher)Matchers.hasItemInArray((Object)this.currentProcessor.getInputDataMapperType()));
            this.bot.comboBoxWithLabelInGroup("Object", "Input").setSelection(this.currentProcessor.getInputDataMapperType());
        }
        catch (WidgetNotFoundException e) {
            DatamapperTestCases.fail((String)("No widget found for Input mapping: " + e.getCause()));
        }
    }

    @Test
    @ConditionalExecutionRule.ConditionalExecution(verify={HasDatasenseSupport.class})
    public void testOverrideMetadata_Output() {
        this.logger.debug((Object)"- testOverrideMetadata_Output");
        Assume.assumeThat((Object)this.currentProcessor.getOutputDataMapperType(), (Matcher)Matchers.not((Matcher)Matchers.isEmptyOrNullString()));
        SWTBotGefEditor editor = this.bot.gefEditor(projectName);
        editor.getEditPart(DATA_MAPPER).click();
        this.bot.viewByTitle(DATA_MAPPER).setFocus();
        actionsHelper.waitUntilProgressBarIsClosed();
        try {
            this.bot.toolbarButtonWithTooltipInGroup("Edit", "Output").click();
            this.bot.comboBoxWithLabelInGroup("Connector", "Output").setSelection(configName);
            this.bot.radioInGroup("By Operation", "Output").click();
            this.bot.comboBoxWithLabelInGroup("Operation", "Output").setSelection(this.currentProcessor.getXmlName());
            MatcherAssert.assertThat((Object)this.bot.comboBoxWithLabelInGroup("Object", "Output").items(), (Matcher)Matchers.hasItemInArray((Object)this.currentProcessor.getOutputDataMapperType()));
            this.bot.comboBoxWithLabelInGroup("Object", "Output").setSelection(this.currentProcessor.getOutputDataMapperType());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DatamapperTestCases.fail((String)"No output mapped");
        }
        catch (WidgetNotFoundException e) {
            DatamapperTestCases.fail((String)("No widget found for output mapping: " + e.getCause()));
        }
    }

    @Test
    @ConditionalExecutionRule.ConditionalExecution(verify={HasNoMetadata.class})
    public void testEmptyMetadataRetrieved() {
        this.logger.debug((Object)"- testEmptyMetadataRetrieved");
        SWTBotGefEditor editor = this.bot.gefEditor(projectName);
        editor.getEditPart(DATA_MAPPER).click();
        this.bot.viewByTitle(DATA_MAPPER).setFocus();
        actionsHelper.waitUntilProgressBarIsClosed();
        SWTBotPreferences.TIMEOUT = 300L;
        try {
            this.bot.comboBoxWithLabelInGroup("Connector", "Input");
            DatamapperTestCases.fail((String)"Dropdown Widget 'Connector' in 'Input' group should not be found");
        }
        catch (WidgetNotFoundException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Connector"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Input"));
        }
        try {
            this.bot.comboBoxWithLabelInGroup("Connector", "Output");
            DatamapperTestCases.fail((String)"Dropdown Widget 'Connector' in 'Output' group should not be found");
        }
        catch (WidgetNotFoundException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Connector"));
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Output"));
        }
    }

    private void initializeDMapperBuildingBlocksWithCurrentProcessorData() {
        this.logger.debug((Object)"- initializeDMapperBuildingBlocksWithCurrentProcessorData");
        SWTBotPreferences.TIMEOUT = 10000L;
        String connectorName = connectorProperties.getName();
        int connectorInstancesInFlow = 2;
        int index = 1;
        while (index <= connectorInstancesInFlow) {
            flowHandler.selectPropertiesViewTab(connectorName, index);
            actionsHelper.selectConfig(configName);
            actionsHelper.selectOperation(this.currentProcessor.getName());
            actionsHelper.setAttributeFields(this.currentProcessor.getRequiredAttributes(), connectorProperties.hasDynamicMetadata());
            actionsHelper.setChildFields(this.currentProcessor.getRequiredChilds(), ElementChild.ChildDescriptionType.REFERENCE, ElementAttribute.AttributeType.REQUIRED);
            actionsHelper.saveAllEditors();
            ++index;
        }
    }
}

