/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.test.testcase;

import com.mule.connectors.interop.model.processor.ConnectorProcessor;
import com.mule.connectors.interop.model.processor.ElementAttribute;
import com.mule.connectors.interop.model.processor.ElementChild;
import com.mule.connectors.interop.test.base.ConnectorTestCases;
import com.mule.connectors.interop.test.rule.ConditionalExecutionRule;
import com.mule.connectors.interop.test.rule.condition.ProcessorHasRequiredFields;
import com.mule.connectors.interop.test.rule.condition.XmlTestEnabledInSuite;
import com.mule.connectors.interop.test.suite.ConnectorTestSuite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
@ConditionalExecutionRule.ConditionalExecution(verify={XmlTestEnabledInSuite.class})
public class XmlGenerationTestCases
extends ConnectorTestCases {
    private static final String ERROR_TEXT = "error";
    private static final String NEWPROJECT_NAME = "newproject";
    private static String projectName = "";
    private static String configName = "";
    @Rule
    public ConditionalExecutionRule conditionalTestRule;
    private ConnectorProcessor currentProcessor = null;

    public XmlGenerationTestCases(String name, ConnectorProcessor processor) {
        this.currentProcessor = processor;
        this.conditionalTestRule = new ConditionalExecutionRule(connectorProperties, this.currentProcessor);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> dataProvider() throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        XmlGenerationTestCases.initializeConnectorData(ConnectorTestSuite.connectorTestDataFile, ConnectorTestSuite.connectorOverridesFile);
        ArrayList<Object[]> testData = new ArrayList<Object[]>();
        for (ConnectorProcessor current : connectorProcessors) {
            Object[] tuple = new Object[]{current.getXmlName(), current};
            testData.add(tuple);
        }
        return testData;
    }

    @BeforeClass
    public static void projectSetup() {
        projectName = NEWPROJECT_NAME;
        Integer runtimeIndex = 0;
        String[] flow = new String[]{"HTTP", connectorProperties.getName()};
        XmlGenerationTestCases.initializeProject(projectName, flow, runtimeIndex);
        configName = XmlGenerationTestCases.createConfig(ElementAttribute.AttributeType.REQUIRED);
        actionsHelper.clearErrorsView();
    }

    @AfterClass
    public static void projectCleanUp() {
        actionsHelper.closeAllShells();
        actionsHelper.closeAllEditors();
        actionsHelper.deleteProject(projectName);
    }

    @Before
    public void setUp() throws Exception {
        SWTBotPreferences.TIMEOUT = 5000L;
    }

    @After
    public void tearDown() {
        actionsHelper.closeAllShells();
    }

    @Test
    @ConditionalExecutionRule.ConditionalExecution(verify={ProcessorHasRequiredFields.class})
    public void testXmlNoneRequiredSet_ErrorsFound() {
        String connectorName = connectorProperties.getName();
        Map<String, ElementAttribute> requiredAttributes = this.currentProcessor.getRequiredAttributes();
        flowHandler.selectPropertiesViewTab(connectorName, 1);
        actionsHelper.selectOperation(this.currentProcessor.getName());
        actionsHelper.clearFields(requiredAttributes);
        actionsHelper.saveAllEditors();
        actionsHelper.selectView("Problems");
        actionsHelper.waitUntilProgressBarIsClosed();
        actionsHelper.saveAllEditors();
        XmlGenerationTestCases.safeSleep(3000L);
        SWTBotTree tree = gefbot.tree();
        XmlGenerationTestCases.assertTrue((boolean)tree.select(new int[]{0}).cell(0, 0).matches(".*Errors .*\\(.* item(s)?\\).*"));
    }

    @Test
    public void testXmlAllRequiredSet_ReferencedAttributes_NoErrorFound() {
        String connectorName = connectorProperties.getName();
        flowHandler.selectPropertiesViewTab(connectorName, 1);
        actionsHelper.selectOperation(this.currentProcessor.getName());
        actionsHelper.setAttributeFields(this.currentProcessor.getRequiredAttributes(), connectorProperties.hasDynamicMetadata());
        actionsHelper.setChildFields(this.currentProcessor.getRequiredChilds(), ElementChild.ChildDescriptionType.REFERENCE, ElementAttribute.AttributeType.REQUIRED);
        actionsHelper.saveAllEditors();
        actionsHelper.selectView("Problems");
        actionsHelper.waitUntilProgressBarIsClosed();
        actionsHelper.saveAllEditors();
        XmlGenerationTestCases.safeSleep(3000L);
        SWTBotTree tree = gefbot.tree();
        if (tree.hasItems() && tree.select(new int[]{0}).hasItems()) {
            XmlGenerationTestCases.assertFalse((boolean)tree.select(new int[]{0}).cell(0, 0).matches(".*Errors .*\\(.* items\\).*"));
        }
    }

    @Test
    public void testXmlAllRequiredSet_DefinedAttributes_NoErrorFound() {
        this.logger.debug((Object)"testXmlAllRequiredSet_DefinedAttributes_NoErrorFound");
        String connectorName = connectorProperties.getName();
        flowHandler.selectPropertiesViewTab(connectorName, 1);
        actionsHelper.selectOperation(this.currentProcessor.getName());
        actionsHelper.setAttributeFields(this.currentProcessor.getRequiredAttributes(), connectorProperties.hasDynamicMetadata());
        actionsHelper.setChildFields(this.currentProcessor.getRequiredChilds(), ElementChild.ChildDescriptionType.COMPLEX, ElementAttribute.AttributeType.REQUIRED);
        actionsHelper.saveAllEditors();
        actionsHelper.selectView("Problems");
        actionsHelper.waitUntilProgressBarIsClosed();
        actionsHelper.saveAllEditors();
        XmlGenerationTestCases.safeSleep(3000L);
        SWTBotTree tree = gefbot.tree();
        if (tree.hasItems() && tree.select(new int[]{0}).hasItems()) {
            XmlGenerationTestCases.assertFalse((boolean)tree.select(new int[]{0}).cell(0, 0).matches(".*Errors .*\\(.* items\\).*"));
        }
    }
}

