/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ExceptionHelper;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOException;
import org.mule.util.ClassHelper;
import org.mule.util.StringMessageHelper;

public class MuleServer
implements Runnable {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$MuleServer == null ? (class$org$mule$MuleServer = MuleServer.class$("org.mule.MuleServer")) : class$org$mule$MuleServer));
    public static final String DEFAULT_CONFIGURATION = "mule-config.xml";
    private static String shutdownMessage = null;
    private String configurationResources;
    private static ConfigurationBuilder configBuilder = null;
    static /* synthetic */ Class class$org$mule$MuleServer;

    public MuleServer() {
    }

    public MuleServer(String configResources) {
        this.setConfigurationResources(configResources);
    }

    public static void main(String[] args) {
        String builder;
        MuleServer server = new MuleServer();
        List<String> opts = Arrays.asList(args);
        String config = null;
        if (opts.size() > 0) {
            config = MuleServer.getOption("-config", opts);
            if (config != null) {
                server.setConfigurationResources(config);
            }
        } else {
            URL configUrl = ClassHelper.getResource(DEFAULT_CONFIGURATION, class$org$mule$MuleServer == null ? (class$org$mule$MuleServer = MuleServer.class$("org.mule.MuleServer")) : class$org$mule$MuleServer);
            if (configUrl != null) {
                config = configUrl.toExternalForm();
                server.setConfigurationResources(config);
            }
        }
        if (config == null) {
            Message message = new Message(9);
            logger.fatal((Object)message.toString());
            System.exit(0);
        }
        if ((builder = MuleServer.getOption("-builder", opts)) != null) {
            try {
                configBuilder = (ConfigurationBuilder)ClassHelper.loadClass(builder, class$org$mule$MuleServer == null ? (class$org$mule$MuleServer = MuleServer.class$("org.mule.MuleServer")) : class$org$mule$MuleServer).newInstance();
            }
            catch (Exception e) {
                logger.fatal((Object)new Message(58, "Builder: " + builder), (Throwable)e);
            }
        } else {
            try {
                configBuilder = new MuleXmlConfigurationBuilder();
            }
            catch (ConfigurationException e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                System.exit(0);
            }
        }
        server.start(false);
    }

    private static String getOption(String option, List options) {
        int i;
        if (options.contains(option) && (i = options.indexOf(option)) < options.size() - 1) {
            return options.get(i + 1).toString();
        }
        return null;
    }

    public void start(boolean ownThread) {
        if (ownThread) {
            Thread serverThread = new Thread((Runnable)this, "MuleServer");
            serverThread.setDaemon(true);
            serverThread.start();
        } else {
            this.run();
        }
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    public String getConfigurationResources() {
        return this.configurationResources;
    }

    public void setConfigurationResources(String configurationResources) {
        this.configurationResources = configurationResources;
    }

    public static ConfigurationBuilder getConfigBuilder() {
        return configBuilder;
    }

    public static void setConfigBuilder(ConfigurationBuilder configBuilder) {
        MuleServer.configBuilder = configBuilder;
    }

    protected void initialize() throws Exception {
        logger.info((Object)"Mule Server starting...");
        if (System.getSecurityManager() == null) {
            // empty if block
        }
        if (configBuilder == null) {
            configBuilder = new MuleXmlConfigurationBuilder();
        }
        if (!configBuilder.isConfigured()) {
            if (this.configurationResources != null) {
                configBuilder.configure(this.configurationResources);
            } else {
                logger.warn((Object)"A configuration file was not set, using default: mule-config.xml");
                configBuilder.configure(DEFAULT_CONFIGURATION);
            }
        }
        logger.info((Object)"Mule Server initialized.");
    }

    void shutdown(Throwable e) {
        Message msg = new Message(10);
        UMOException muleException = ExceptionHelper.getRootMuleException(e);
        if (muleException != null) {
            logger.fatal((Object)muleException.getDetailedMessage());
        } else {
            logger.fatal((Object)(msg.toString() + " " + e.getMessage()), e);
        }
        ArrayList<Object> msgs = new ArrayList<Object>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException(e);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(new Message(20));
        msgs.add(new Message(2, new Date(MuleManager.getInstance().getStartDate())));
        msgs.add(new Message(3, new Date().toString()));
        shutdownMessage = StringMessageHelper.getBoilerPlate(msgs, '*', 80);
        logger.fatal((Object)shutdownMessage);
        System.exit(0);
    }

    void shutdown() {
        logger.info((Object)"Mule server shutting dow due to normal shutdown request");
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(new Message(21).getMessage());
        msgs.add(new Message(2, new Date(MuleManager.getInstance().getStartDate())).getMessage());
        msgs.add(new Message(3, new Date().toString()).getMessage());
        shutdownMessage = StringMessageHelper.getBoilerPlate(msgs, '*', 80);
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

