/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.script;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.UMODescriptorAware;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.Lifecycle;
import org.mule.util.monitor.FileListener;
import org.mule.util.monitor.FileMonitor;

public abstract class AbstractScriptComponent
implements Initialisable,
Lifecycle,
UMODescriptorAware,
FileListener,
Callable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String script = null;
    private boolean autoReload = true;
    protected UMODescriptor descriptor;
    private FileMonitor monitor;
    private long reloadInterval = 60000L;

    public void setDescriptor(UMODescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void initialise() throws InitialisationException {
        if (this.getScript() == null) {
            String extension = this.getDefaultFileExtension();
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this.setScript(this.descriptor.getName() + extension);
            this.logger.info((Object)("script name is not set, using default: " + this.descriptor.getName() + extension));
        }
        this.loadInterpreter(this.getScript());
        if (this.autoReload) {
            File f = new File(this.getScript());
            if (f.exists()) {
                this.monitor = new FileMonitor(this.reloadInterval);
                this.monitor.addFile(f);
                this.monitor.addListener(this);
                this.logger.debug((Object)"Component script is reloadable");
            } else {
                this.logger.warn((Object)"Cannot setup autoreload as the script fie is not on the local file system");
            }
        }
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isAutoReload() {
        return this.autoReload;
    }

    public void setAutoReload(boolean autoReload) {
        this.autoReload = autoReload;
    }

    public void start() throws UMOException {
        if (this.monitor != null) {
            this.monitor.start();
        }
    }

    public void stop() throws UMOException {
        if (this.monitor != null) {
            this.monitor.stop();
        }
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (UMOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected abstract void loadInterpreter(String var1) throws InitialisationException;

    protected abstract String getDefaultFileExtension();
}

