/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.util.ClassHelper;
import org.mule.util.queue.SerialisationPersistence;

public class MuleConfiguration {
    public static final String DEFAULT_SERVER_URL = "tcp://localhost:60504";
    public static final String USE_MANAGER_PROPERTIES = "org.mule.useManagerProperties";
    public static final String SYNCHRONOUS_PROPERTY = "synchronous";
    public static final boolean DEFAULT_SYNCHRONOUS = false;
    public static final int DEFAULT_MAX_OUTSTANDING_MESSAGES = 1000;
    public static final int DEFAULT_SYNCHRONOUS_EVENT_TIMEOUT = 5000;
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 30000;
    public static final String DEFAULT_WORKING_DIRECTORY = "./.mule";
    private boolean synchronous = false;
    private String model = null;
    private PoolingProfile poolingProfile = new PoolingProfile();
    private ThreadingProfile messageDispatcherThreadingProfile = null;
    private ThreadingProfile messageReceiverThreadingProfile = null;
    private ThreadingProfile componentPoolThreadingProfile = null;
    private QueueProfile queueProfile = new QueueProfile(1000, null);
    private int synchronousEventTimeout = 5000;
    private int transactionTimeout = 30000;
    private boolean synchronousReceive = false;
    private boolean recoverableMode = false;
    private ThreadingProfile defaultThreadingProfile = new ThreadingProfile();
    private String workingDirectoy = "./.mule";
    private String[] configResources = new String[0];
    private String serverUrl = "tcp://localhost:60504";
    private Manifest manifest = null;
    private boolean clientMode = false;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public ThreadingProfile getMessageDispatcherThreadingProfile() {
        return this.getThreadingProfile(this.messageDispatcherThreadingProfile);
    }

    public void setMessageDispatcherThreadingProfile(ThreadingProfile messageDispatcherThreadingProfile) {
        this.messageDispatcherThreadingProfile = messageDispatcherThreadingProfile;
    }

    public ThreadingProfile getMessageReceiverThreadingProfile() {
        return this.getThreadingProfile(this.messageReceiverThreadingProfile);
    }

    public void setMessageReceiverThreadingProfile(ThreadingProfile messageReceiverThreadingProfile) {
        this.messageReceiverThreadingProfile = messageReceiverThreadingProfile;
    }

    public ThreadingProfile getComponentThreadingProfile() {
        return this.getThreadingProfile(this.componentPoolThreadingProfile);
    }

    public void setComponentThreadingProfile(ThreadingProfile componentPoolThreadingProfile) {
        this.componentPoolThreadingProfile = componentPoolThreadingProfile;
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return this.getThreadingProfile(this.defaultThreadingProfile);
    }

    public void setDefaultThreadingProfile(ThreadingProfile defaultThreadingProfile) {
        if (defaultThreadingProfile == null) {
            return;
        }
        this.defaultThreadingProfile = defaultThreadingProfile;
    }

    private ThreadingProfile getThreadingProfile(ThreadingProfile profile) {
        if (profile != null) {
            return new ThreadingProfile(profile);
        }
        return new ThreadingProfile(this.defaultThreadingProfile);
    }

    public PoolingProfile getPoolingProfile() {
        return new PoolingProfile(this.poolingProfile);
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public int getSynchronousEventTimeout() {
        return this.synchronousEventTimeout;
    }

    public void setSynchronousEventTimeout(int synchronousEventTimeout) {
        this.synchronousEventTimeout = synchronousEventTimeout;
    }

    public boolean isSynchronousReceive() {
        return this.synchronousReceive;
    }

    public void setSynchronousReceive(boolean synchronousReceive) {
        this.synchronousReceive = synchronousReceive;
    }

    public QueueProfile getQueueProfile() {
        return new QueueProfile(this.queueProfile);
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public boolean isRecoverableMode() {
        return this.recoverableMode;
    }

    public void setRecoverableMode(boolean recoverableMode) {
        this.recoverableMode = recoverableMode;
        if (recoverableMode && this.queueProfile.getPersistenceStrategy() == null) {
            this.queueProfile = new QueueProfile(this.queueProfile.getMaxOutstandingMessages(), new SerialisationPersistence());
        }
    }

    public String getWorkingDirectoy() {
        return this.workingDirectoy;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectoy = workingDirectory;
    }

    public String[] getConfigResources() {
        return this.configResources;
    }

    public void setConfigResources(String[] configResources) {
        if (configResources != null) {
            int current = this.configResources.length;
            String[] newResources = new String[configResources.length + current];
            System.arraycopy(this.configResources, 0, newResources, 0, current);
            System.arraycopy(configResources, 0, newResources, current, configResources.length);
            this.configResources = newResources;
        } else {
            this.configResources = configResources;
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getProductVersion() {
        return this.getManifestProperty("Implementation-Version");
    }

    public String getVendorName() {
        return this.getManifestProperty("Specification-Vendor");
    }

    public String getProductName() {
        return this.getManifestProperty("Implementation-Title");
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            this.manifest = new Manifest();
            InputStream is = ClassHelper.getResourceAsStream("META-INF/Mule.mf", this.getClass());
            if (is == null) {
                is = ClassHelper.getResourceAsStream("meta-inf/Mule.mf", this.getClass());
            }
            if (is != null) {
                try {
                    this.manifest.read(is);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.manifest;
    }

    protected String getManifestProperty(String name) {
        return this.getManifest().getMainAttributes().getValue(new Attributes.Name(name));
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        this.setServerUrl("");
    }
}

