/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.CallParamRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.NodeCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.MuleDtdResolver;
import org.mule.config.PropertyFactory;
import org.mule.config.ReaderResource;
import org.mule.config.ThreadingProfile;
import org.mule.config.builders.ContainerReference;
import org.mule.config.builders.EndpointReference;
import org.mule.config.builders.TransformerReference;
import org.mule.config.converters.ConnectorConverter;
import org.mule.config.converters.EndpointConverter;
import org.mule.config.converters.EndpointURIConverter;
import org.mule.config.converters.TransactionFactoryConverter;
import org.mule.config.converters.TransformerConverter;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleDescriptor;
import org.mule.providers.AbstractConnector;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.UMOInterceptor;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.umo.model.UMOModel;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.util.ClassHelper;
import org.mule.util.PropertiesHelper;
import org.mule.util.Utility;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class MuleXmlConfigurationBuilder
implements ConfigurationBuilder {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$config$builders$MuleXmlConfigurationBuilder == null ? (class$org$mule$config$builders$MuleXmlConfigurationBuilder = MuleXmlConfigurationBuilder.class$("org.mule.config.builders.MuleXmlConfigurationBuilder")) : class$org$mule$config$builders$MuleXmlConfigurationBuilder));
    public static final String DEFAULT_ENTRY_POINT_RESOLVER = (class$org$mule$model$DynamicEntryPointResolver == null ? (class$org$mule$model$DynamicEntryPointResolver = MuleXmlConfigurationBuilder.class$("org.mule.model.DynamicEntryPointResolver")) : class$org$mule$model$DynamicEntryPointResolver).getName();
    public static final String DEFAULT_LIFECYCLE_ADAPTER = (class$org$mule$impl$DefaultLifecycleAdapter == null ? (class$org$mule$impl$DefaultLifecycleAdapter = MuleXmlConfigurationBuilder.class$("org.mule.impl.DefaultLifecycleAdapter")) : class$org$mule$impl$DefaultLifecycleAdapter).getName();
    public static final String DEFAULT_COMPONENT_FACTORY = (class$org$mule$impl$MuleComponentFactory == null ? (class$org$mule$impl$MuleComponentFactory = MuleXmlConfigurationBuilder.class$("org.mule.impl.MuleComponentFactory")) : class$org$mule$impl$MuleComponentFactory).getName();
    public static final String DEFAULT_CONTAINER_CONTEXT = (class$org$mule$impl$container$MuleContainerContext == null ? (class$org$mule$impl$container$MuleContainerContext = MuleXmlConfigurationBuilder.class$("org.mule.impl.container.MuleContainerContext")) : class$org$mule$impl$container$MuleContainerContext).getName();
    public static final String DEFAULT_ENDPOINT = (class$org$mule$impl$endpoint$MuleEndpoint == null ? (class$org$mule$impl$endpoint$MuleEndpoint = MuleXmlConfigurationBuilder.class$("org.mule.impl.endpoint.MuleEndpoint")) : class$org$mule$impl$endpoint$MuleEndpoint).getName();
    public static final String DEFAULT_TRANSACTION_CONFIG = (class$org$mule$impl$MuleTransactionConfig == null ? (class$org$mule$impl$MuleTransactionConfig = MuleXmlConfigurationBuilder.class$("org.mule.impl.MuleTransactionConfig")) : class$org$mule$impl$MuleTransactionConfig).getName();
    public static final String DEFAULT_DESCRIPTOR = (class$org$mule$impl$MuleDescriptor == null ? (class$org$mule$impl$MuleDescriptor = MuleXmlConfigurationBuilder.class$("org.mule.impl.MuleDescriptor")) : class$org$mule$impl$MuleDescriptor).getName();
    public static final String DEFAULT_SECURITY_MANAGER = (class$org$mule$impl$security$MuleSecurityManager == null ? (class$org$mule$impl$security$MuleSecurityManager = MuleXmlConfigurationBuilder.class$("org.mule.impl.security.MuleSecurityManager")) : class$org$mule$impl$security$MuleSecurityManager).getName();
    public static final String DEFAULT_OUTBOUND_MESSAGE_ROUTER = (class$org$mule$routing$outbound$OutboundMessageRouter == null ? (class$org$mule$routing$outbound$OutboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.routing.outbound.OutboundMessageRouter")) : class$org$mule$routing$outbound$OutboundMessageRouter).getName();
    public static final String DEFAULT_INBOUND_MESSAGE_ROUTER = (class$org$mule$routing$inbound$InboundMessageRouter == null ? (class$org$mule$routing$inbound$InboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.routing.inbound.InboundMessageRouter")) : class$org$mule$routing$inbound$InboundMessageRouter).getName();
    public static final String DEFAULT_RESPONSE_MESSAGE_ROUTER = (class$org$mule$routing$response$ResponseMessageRouter == null ? (class$org$mule$routing$response$ResponseMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.routing.response.ResponseMessageRouter")) : class$org$mule$routing$response$ResponseMessageRouter).getName();
    public static final String DEFAULT_CATCH_ALL_STRATEGY = (class$org$mule$routing$LoggingCatchAllStrategy == null ? (class$org$mule$routing$LoggingCatchAllStrategy = MuleXmlConfigurationBuilder.class$("org.mule.routing.LoggingCatchAllStrategy")) : class$org$mule$routing$LoggingCatchAllStrategy).getName();
    public static final String DEFAULT_POOL_FACTORY = (class$org$mule$config$pool$CommonsPoolFactory == null ? (class$org$mule$config$pool$CommonsPoolFactory = MuleXmlConfigurationBuilder.class$("org.mule.config.pool.CommonsPoolFactory")) : class$org$mule$config$pool$CommonsPoolFactory).getName();
    public static final String DEFAULT_MODEL = (class$org$mule$impl$MuleModel == null ? (class$org$mule$impl$MuleModel = MuleXmlConfigurationBuilder.class$("org.mule.impl.MuleModel")) : class$org$mule$impl$MuleModel).getName();
    public static final String THREADING_PROFILE = (class$org$mule$config$ThreadingProfile == null ? (class$org$mule$config$ThreadingProfile = MuleXmlConfigurationBuilder.class$("org.mule.config.ThreadingProfile")) : class$org$mule$config$ThreadingProfile).getName();
    public static final String POOLING_PROFILE = (class$org$mule$config$PoolingProfile == null ? (class$org$mule$config$PoolingProfile = MuleXmlConfigurationBuilder.class$("org.mule.config.PoolingProfile")) : class$org$mule$config$PoolingProfile).getName();
    public static final String QUEUE_PROFILE = (class$org$mule$config$QueueProfile == null ? (class$org$mule$config$QueueProfile = MuleXmlConfigurationBuilder.class$("org.mule.config.QueueProfile")) : class$org$mule$config$QueueProfile).getName();
    public static final String PERSISTENCE_STRATEGY_INTERFACE = (class$org$mule$util$queue$PersistenceStrategy == null ? (class$org$mule$util$queue$PersistenceStrategy = MuleXmlConfigurationBuilder.class$("org.mule.util.queue.PersistenceStrategy")) : class$org$mule$util$queue$PersistenceStrategy).getName();
    public static final String INBOUND_MESSAGE_ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOInboundMessageRouter == null ? (class$org$mule$umo$routing$UMOInboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOInboundMessageRouter")) : class$org$mule$umo$routing$UMOInboundMessageRouter).getName();
    public static final String RESPONSE_MESSAGE_ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOResponseMessageRouter == null ? (class$org$mule$umo$routing$UMOResponseMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOResponseMessageRouter")) : class$org$mule$umo$routing$UMOResponseMessageRouter).getName();
    public static final String OUTBOUND_MESSAGE_ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOOutboundMessageRouter == null ? (class$org$mule$umo$routing$UMOOutboundMessageRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOOutboundMessageRouter")) : class$org$mule$umo$routing$UMOOutboundMessageRouter).getName();
    public static final String TRANSFORMER_INTERFACE = (class$org$mule$umo$transformer$UMOTransformer == null ? (class$org$mule$umo$transformer$UMOTransformer = MuleXmlConfigurationBuilder.class$("org.mule.umo.transformer.UMOTransformer")) : class$org$mule$umo$transformer$UMOTransformer).getName();
    public static final String TRANSACTION_MANAGER_FACTORY_INTERFACE = (class$org$mule$umo$manager$UMOTransactionManagerFactory == null ? (class$org$mule$umo$manager$UMOTransactionManagerFactory = MuleXmlConfigurationBuilder.class$("org.mule.umo.manager.UMOTransactionManagerFactory")) : class$org$mule$umo$manager$UMOTransactionManagerFactory).getName();
    public static final String SECURITY_PROVIDER_INTERFACE = (class$org$mule$umo$security$UMOSecurityProvider == null ? (class$org$mule$umo$security$UMOSecurityProvider = MuleXmlConfigurationBuilder.class$("org.mule.umo.security.UMOSecurityProvider")) : class$org$mule$umo$security$UMOSecurityProvider).getName();
    public static final String ENCRYPTION_STRATEGY_INTERFACE = (class$org$mule$umo$UMOEncryptionStrategy == null ? (class$org$mule$umo$UMOEncryptionStrategy = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOEncryptionStrategy")) : class$org$mule$umo$UMOEncryptionStrategy).getName();
    public static final String ENDPOINT_SECURITY_FILTER_INTERFACE = (class$org$mule$umo$security$UMOEndpointSecurityFilter == null ? (class$org$mule$umo$security$UMOEndpointSecurityFilter = MuleXmlConfigurationBuilder.class$("org.mule.umo.security.UMOEndpointSecurityFilter")) : class$org$mule$umo$security$UMOEndpointSecurityFilter).getName();
    public static final String AGENT_INTERFACE = (class$org$mule$umo$manager$UMOAgent == null ? (class$org$mule$umo$manager$UMOAgent = MuleXmlConfigurationBuilder.class$("org.mule.umo.manager.UMOAgent")) : class$org$mule$umo$manager$UMOAgent).getName();
    public static final String TRANSACTION_FACTORY_INTERFACE = (class$org$mule$umo$UMOTransactionFactory == null ? (class$org$mule$umo$UMOTransactionFactory = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOTransactionFactory")) : class$org$mule$umo$UMOTransactionFactory).getName();
    public static final String TRANSACTION_CONSTRAINT_INTERFACE = (class$org$mule$transaction$constraints$BatchConstraint == null ? (class$org$mule$transaction$constraints$BatchConstraint = MuleXmlConfigurationBuilder.class$("org.mule.transaction.constraints.BatchConstraint")) : class$org$mule$transaction$constraints$BatchConstraint).getName();
    public static final String CONNECTOR_INTERFACE = (class$org$mule$umo$provider$UMOConnector == null ? (class$org$mule$umo$provider$UMOConnector = MuleXmlConfigurationBuilder.class$("org.mule.umo.provider.UMOConnector")) : class$org$mule$umo$provider$UMOConnector).getName();
    public static final String INTERCEPTOR_INTERFACE = (class$org$mule$umo$UMOInterceptor == null ? (class$org$mule$umo$UMOInterceptor = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOInterceptor")) : class$org$mule$umo$UMOInterceptor).getName();
    public static final String ROUTER_INTERFACE = (class$org$mule$umo$routing$UMOOutboundRouter == null ? (class$org$mule$umo$routing$UMOOutboundRouter = MuleXmlConfigurationBuilder.class$("org.mule.umo.routing.UMOOutboundRouter")) : class$org$mule$umo$routing$UMOOutboundRouter).getName();
    public static final String FILTER_INTERFACE = (class$org$mule$umo$UMOFilter == null ? (class$org$mule$umo$UMOFilter = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOFilter")) : class$org$mule$umo$UMOFilter).getName();
    public static final String EXCEPTION_STRATEGY_INTERFACE = (class$java$beans$ExceptionListener == null ? (class$java$beans$ExceptionListener = MuleXmlConfigurationBuilder.class$("java.beans.ExceptionListener")) : class$java$beans$ExceptionListener).getName();
    protected UMOManager manager;
    protected Digester digester;
    private List containerReferences = new ArrayList();
    private List transformerReferences = new ArrayList();
    private List endpointReferences = new ArrayList();
    static /* synthetic */ Class class$org$mule$config$builders$MuleXmlConfigurationBuilder;
    static /* synthetic */ Class class$org$mule$model$DynamicEntryPointResolver;
    static /* synthetic */ Class class$org$mule$impl$DefaultLifecycleAdapter;
    static /* synthetic */ Class class$org$mule$impl$MuleComponentFactory;
    static /* synthetic */ Class class$org$mule$impl$container$MuleContainerContext;
    static /* synthetic */ Class class$org$mule$impl$endpoint$MuleEndpoint;
    static /* synthetic */ Class class$org$mule$impl$MuleTransactionConfig;
    static /* synthetic */ Class class$org$mule$impl$MuleDescriptor;
    static /* synthetic */ Class class$org$mule$impl$security$MuleSecurityManager;
    static /* synthetic */ Class class$org$mule$routing$outbound$OutboundMessageRouter;
    static /* synthetic */ Class class$org$mule$routing$inbound$InboundMessageRouter;
    static /* synthetic */ Class class$org$mule$routing$response$ResponseMessageRouter;
    static /* synthetic */ Class class$org$mule$routing$LoggingCatchAllStrategy;
    static /* synthetic */ Class class$org$mule$config$pool$CommonsPoolFactory;
    static /* synthetic */ Class class$org$mule$impl$MuleModel;
    static /* synthetic */ Class class$org$mule$config$ThreadingProfile;
    static /* synthetic */ Class class$org$mule$config$PoolingProfile;
    static /* synthetic */ Class class$org$mule$config$QueueProfile;
    static /* synthetic */ Class class$org$mule$util$queue$PersistenceStrategy;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOInboundMessageRouter;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOResponseMessageRouter;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOOutboundMessageRouter;
    static /* synthetic */ Class class$org$mule$umo$transformer$UMOTransformer;
    static /* synthetic */ Class class$org$mule$umo$manager$UMOTransactionManagerFactory;
    static /* synthetic */ Class class$org$mule$umo$security$UMOSecurityProvider;
    static /* synthetic */ Class class$org$mule$umo$UMOEncryptionStrategy;
    static /* synthetic */ Class class$org$mule$umo$security$UMOEndpointSecurityFilter;
    static /* synthetic */ Class class$org$mule$umo$manager$UMOAgent;
    static /* synthetic */ Class class$org$mule$umo$UMOTransactionFactory;
    static /* synthetic */ Class class$org$mule$transaction$constraints$BatchConstraint;
    static /* synthetic */ Class class$org$mule$umo$provider$UMOConnector;
    static /* synthetic */ Class class$org$mule$umo$UMOInterceptor;
    static /* synthetic */ Class class$org$mule$umo$routing$UMOOutboundRouter;
    static /* synthetic */ Class class$org$mule$umo$UMOFilter;
    static /* synthetic */ Class class$java$beans$ExceptionListener;
    static /* synthetic */ Class class$org$mule$umo$endpoint$UMOEndpoint;
    static /* synthetic */ Class class$org$mule$umo$endpoint$UMOEndpointURI;
    static /* synthetic */ Class class$org$mule$config$MuleConfiguration;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$ArrayList;

    public MuleXmlConfigurationBuilder() throws ConfigurationException {
        ConvertUtils.register((Converter)new EndpointConverter(), (Class)(class$org$mule$umo$endpoint$UMOEndpoint == null ? (class$org$mule$umo$endpoint$UMOEndpoint = MuleXmlConfigurationBuilder.class$("org.mule.umo.endpoint.UMOEndpoint")) : class$org$mule$umo$endpoint$UMOEndpoint));
        ConvertUtils.register((Converter)new TransformerConverter(), (Class)(class$org$mule$umo$transformer$UMOTransformer == null ? (class$org$mule$umo$transformer$UMOTransformer = MuleXmlConfigurationBuilder.class$("org.mule.umo.transformer.UMOTransformer")) : class$org$mule$umo$transformer$UMOTransformer));
        ConvertUtils.register((Converter)new ConnectorConverter(), (Class)(class$org$mule$umo$provider$UMOConnector == null ? (class$org$mule$umo$provider$UMOConnector = MuleXmlConfigurationBuilder.class$("org.mule.umo.provider.UMOConnector")) : class$org$mule$umo$provider$UMOConnector));
        ConvertUtils.register((Converter)new TransactionFactoryConverter(), (Class)(class$org$mule$umo$UMOTransactionFactory == null ? (class$org$mule$umo$UMOTransactionFactory = MuleXmlConfigurationBuilder.class$("org.mule.umo.UMOTransactionFactory")) : class$org$mule$umo$UMOTransactionFactory));
        ConvertUtils.register((Converter)new EndpointURIConverter(), (Class)(class$org$mule$umo$endpoint$UMOEndpointURI == null ? (class$org$mule$umo$endpoint$UMOEndpointURI = MuleXmlConfigurationBuilder.class$("org.mule.umo.endpoint.UMOEndpointURI")) : class$org$mule$umo$endpoint$UMOEndpointURI));
        this.digester = new Digester(){

            public void warning(SAXParseException e) throws SAXException {
                if (this.errorHandler != null) {
                    this.errorHandler.warning(e);
                }
            }
        };
        this.digester.setEntityResolver((EntityResolver)new MuleDtdResolver());
        String temp = System.getProperty("org.mule.xml.validate", "true");
        this.digester.setValidating(temp.equalsIgnoreCase("true"));
        this.digester.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SAXException(exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                logger.fatal((Object)exception.getMessage(), (Throwable)exception);
                throw new SAXException(exception);
            }

            public void warning(SAXParseException exception) throws SAXException {
                logger.warn((Object)exception.getMessage());
            }
        });
        String path = "mule-configuration";
        this.addMuleConfigurationRules(this.digester, path);
        this.addContainerContextRules(this.digester, path);
        this.addTransformerRules(this.digester, path);
        this.addMuleEnvironmentPropertiesRules(this.digester, path);
        this.addSecurityManagerRules(this.digester, path);
        this.addTransactionManagerRules(this.digester, path);
        this.addGlobalEndpointRules(this.digester, path);
        this.addEndpointIdentfierRules(this.digester, path);
        this.addInterceptorStackRules(this.digester, path);
        this.addConnectorRules(this.digester, path);
        this.addAgentRules(this.digester, path);
        this.addModelRules(this.digester, path);
        this.addMuleDescriptorRules(this.digester, path);
    }

    protected InputStream loadConfig(String configResource) throws ConfigurationException {
        InputStream is = ClassHelper.getResourceAsStream(configResource, this.getClass());
        if (is == null) {
            File file = new File(configResource);
            if (file.exists()) {
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new ConfigurationException(new Message(122, configResource), (Throwable)e);
                }
            }
            try {
                URL url = new URL(configResource);
                is = url.openStream();
            }
            catch (Exception e) {
                throw new ConfigurationException(new Message(122, configResource));
            }
        }
        return is;
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        String[] resources = Utility.split(configResources, ",");
        MuleManager.getConfiguration().setConfigResources(resources);
        ReaderResource[] readers = new ReaderResource[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            try {
                readers[i] = new ReaderResource(resources[i].trim(), new InputStreamReader(this.loadConfig(resources[i].trim()), "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException(e);
            }
        }
        return this.configure(readers);
    }

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        this.manager = MuleManager.getInstance();
        Reader configResource = null;
        for (int i = 0; i < configResources.length; ++i) {
            try {
                configResource = configResources[i].getReader();
                this.digester.push((Object)this.manager);
                this.manager = (UMOManager)this.digester.parse(configResource);
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(new Message(139, configResources[i].getDescription()), (Throwable)e);
            }
        }
        try {
            this.setContainerProperties();
            this.setTransformers();
            this.setGlobalEndpoints();
            this.manager.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(new Message(40, "MuleManager"), (Throwable)e);
        }
        return this.manager;
    }

    public boolean isConfigured() {
        return this.manager != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainerProperties() throws ContainerException {
        UMOContainerContext ctx = this.manager.getContainerContext();
        try {
            Iterator iterator = this.containerReferences.iterator();
            while (iterator.hasNext()) {
                ContainerReference reference = (ContainerReference)iterator.next();
                reference.resolveReference(ctx);
            }
        }
        finally {
            this.containerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransformers() throws InitialisationException {
        try {
            Iterator iterator = this.transformerReferences.iterator();
            while (iterator.hasNext()) {
                TransformerReference reference = (TransformerReference)iterator.next();
                reference.resolveTransformer();
            }
        }
        finally {
            this.transformerReferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalEndpoints() throws InitialisationException {
        Map endpoints = MuleManager.getInstance().getEndpoints();
        Iterator<Object> iterator = endpoints.values().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            ep.initialise();
            MuleManager.getInstance().unregisterEndpoint(ep.getName());
            MuleManager.getInstance().registerEndpoint(ep);
        }
        try {
            iterator = this.endpointReferences.iterator();
            while (iterator.hasNext()) {
                EndpointReference reference = (EndpointReference)iterator.next();
                reference.resolveEndpoint();
            }
        }
        finally {
            this.endpointReferences.clear();
        }
    }

    protected void addMuleConfigurationRules(Digester digester, String path) {
        digester.addSetProperties(path);
        path = path + "/mule-environment-properties";
        digester.addObjectCreate(path, class$org$mule$config$MuleConfiguration == null ? (class$org$mule$config$MuleConfiguration = MuleXmlConfigurationBuilder.class$("org.mule.config.MuleConfiguration")) : class$org$mule$config$MuleConfiguration);
        this.addSetPropertiesRule(path, digester);
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addObjectCreate(path + "/threading-profile", THREADING_PROFILE);
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.id = attributes.getValue("id");
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.peek();
                MuleConfiguration cfg = (MuleConfiguration)this.digester.peek(1);
                if ("default".equals(this.id)) {
                    cfg.setDefaultThreadingProfile(tp);
                    cfg.setMessageDispatcherThreadingProfile(tp);
                    cfg.setMessageReceiverThreadingProfile(tp);
                    cfg.setComponentThreadingProfile(tp);
                } else if ("messageReceiver".equals(this.id)) {
                    cfg.setMessageReceiverThreadingProfile(tp);
                } else if ("messageDispatcher".equals(this.id)) {
                    cfg.setMessageDispatcherThreadingProfile(tp);
                } else if ("component".equals(this.id)) {
                    cfg.setComponentThreadingProfile(tp);
                }
            }
        });
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                MuleManager.setConfiguration((MuleConfiguration)this.digester.peek());
            }
        });
    }

    protected void addMuleEnvironmentPropertiesRules(Digester digester, String path) {
        path = path + "/environment-properties";
        this.addMulePropertiesRule(path, digester, false);
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                Map prop = (Map)this.digester.peek();
                Iterator iterator = prop.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    MuleManager.getInstance().setProperty(entry.getKey(), entry.getValue());
                }
                super.end(s, s1);
            }
        });
    }

    protected void addSecurityManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/security-manager";
        digester.addObjectCreate(path, DEFAULT_SECURITY_MANAGER, "className");
        digester.addObjectCreate(path + "/security-provider", SECURITY_PROVIDER_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/security-provider", digester);
        this.addMulePropertiesRule(path + "/security-provider", digester, true);
        digester.addSetNext(path + "/security-provider", "addProvider");
        digester.addObjectCreate(path + "/encryption-strategy", ENCRYPTION_STRATEGY_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/encryption-strategy", digester);
        this.addMulePropertiesRule(path + "/encryption-strategy", digester, true);
        digester.addRule(path + "/encryption-strategy", new Rule(){
            private String name;

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                this.name = attributes.getValue("name");
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                UMOEncryptionStrategy s = (UMOEncryptionStrategy)this.digester.peek();
                ((UMOSecurityManager)this.digester.peek(1)).addEncryptionStrategy(this.name, s);
            }
        });
        digester.addSetNext(path, "setSecurityManager");
    }

    protected void addContainerContextRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/container-context";
        digester.addObjectCreate(path, DEFAULT_CONTAINER_CONTEXT, "className");
        this.addMulePropertiesRule(path, digester, true);
        NodeCreateRule nodeCreateRule = null;
        try {
            nodeCreateRule = new NodeCreateRule(11){
                private String encoding;
                private String doctype;

                public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                    this.encoding = attributes.getValue("encoding");
                    this.doctype = attributes.getValue("doctype");
                    super.begin(endpointName, endpointName1, attributes);
                }

                public void end(String endpointName, String endpointName1) throws Exception {
                    super.end(endpointName, endpointName1);
                    DocumentFragment config = (DocumentFragment)this.digester.pop();
                    StringWriter s = new StringWriter();
                    StreamResult streamResult = new StreamResult(s);
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    try {
                        Transformer transformer = tFactory.newTransformer();
                        transformer.setOutputProperty("omit-xml-declaration", "yes");
                        transformer.transform(new DOMSource(config), streamResult);
                    }
                    catch (TransformerException e) {
                        throw new ContainerException(new Message(141), (Throwable)e);
                    }
                    StringReader reader = new StringReader(s.toString());
                    UMOContainerContext ctx = (UMOContainerContext)this.digester.peek();
                    ctx.configure(reader, this.doctype, this.encoding);
                }
            };
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException(e);
        }
        digester.addRule(path + "/configuration", (Rule)nodeCreateRule);
        digester.addSetRoot(path, "setContainerContext");
    }

    protected void addTransformerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transformers/transformer";
        digester.addObjectCreate(path, TRANSFORMER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester, true);
        digester.addSetRoot(path, "registerTransformer");
    }

    protected void addGlobalEndpointRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/global-endpoints";
        this.addEndpointRules(digester, path, "registerEndpoint");
    }

    protected void addEndpointIdentfierRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/endpoint-identifiers/endpoint-identifier";
        digester.addCallMethod(path, "registerEndpointIdentifier", 2);
        digester.addCallParam(path, 0, "name");
        digester.addCallParam(path, 1, "value");
    }

    protected void addTransactionManagerRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/transaction-manager";
        digester.addObjectCreate(path, TRANSACTION_MANAGER_FACTORY_INTERFACE, "factory");
        this.addMulePropertiesRule(path, digester, true);
        digester.addSetRoot(path, "setTransactionManager");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMOTransactionManagerFactory txFactory = (UMOTransactionManagerFactory)this.digester.pop();
                this.digester.push((Object)txFactory.create());
            }
        });
    }

    protected void addAgentRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/agents/agent";
        digester.addObjectCreate(path, AGENT_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester, true);
        digester.addSetRoot(path, "registerAgent");
    }

    protected void addConnectorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/connector";
        digester.addObjectCreate(path, CONNECTOR_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester, true);
        digester.addRule(path + "/threading-profile", new Rule(){
            private String id;

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleManager cfr_ignored_0 = (MuleManager)this.digester.getRoot();
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.id = attributes.getValue("id");
                if ("default".equals(this.id)) {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                } else if ("receiver".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageReceiverThreadingProfile());
                } else if ("dispatcher".equals(this.id)) {
                    this.digester.push((Object)cfg.getMessageDispatcherThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                ThreadingProfile tp = (ThreadingProfile)this.digester.pop();
                AbstractConnector cnn = (AbstractConnector)this.digester.peek();
                if ("default".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                    cnn.setDispatcherThreadingProfile(tp);
                } else if ("receiver".equals(this.id)) {
                    cnn.setReceiverThreadingProfile(tp);
                } else if ("dispatcher".equals(this.id)) {
                    cnn.setDispatcherThreadingProfile(tp);
                }
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        this.addExceptionStrategyRules(digester, path);
        digester.addSetRoot(path, "registerConnector");
    }

    protected void addInterceptorStackRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/interceptor-stack";
        digester.addRule(path + "/interceptor", (Rule)new ObjectCreateRule(INTERCEPTOR_INTERFACE, "className"){

            public void end(String s, String s1) throws Exception {
            }
        });
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                this.digester.push((Object)attributes.getValue("name"));
            }

            public void end(String s, String s1) throws Exception {
                ArrayList<Object> list = new ArrayList<Object>();
                Object obj = this.digester.peek();
                while (obj instanceof UMOInterceptor) {
                    list.add(0, this.digester.pop());
                    obj = this.digester.peek();
                }
                MuleXmlConfigurationBuilder.this.manager.registerInterceptorStack(this.digester.pop().toString(), list);
            }
        });
    }

    protected void addModelRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/model";
        digester.addObjectCreate(path, DEFAULT_MODEL, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetRoot(path, "setModel");
        digester.addObjectCreate(path + "/entry-point-resolver", DEFAULT_ENTRY_POINT_RESOLVER, "className");
        this.addSetPropertiesRule(path + "/entry-point-resolver", digester);
        digester.addSetNext(path + "/entry-point-resolver", "setEntryPointResolver");
        digester.addObjectCreate(path + "/component-lifecycle-adapter-factory", DEFAULT_LIFECYCLE_ADAPTER, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path + "/component-lifecycle-adapter-factory", "setLifecycleAdapterFactory");
        digester.addObjectCreate(path + "/component-factory", DEFAULT_COMPONENT_FACTORY, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path + "/component-factory", "setComponentFactory");
        this.addPoolingProfileRules(digester, path);
        this.addExceptionStrategyRules(digester, path);
        this.addMuleDescriptorRules(digester, path);
    }

    protected void addMuleDescriptorRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/mule-descriptor";
        digester.addObjectCreate(path, DEFAULT_DESCRIPTOR, "className");
        this.addSetPropertiesRule(path, digester);
        this.addMessageRouterRules(digester, path, "inbound");
        this.addMessageRouterRules(digester, path, "outbound");
        this.addMessageRouterRules(digester, path, "response");
        this.addThreadingProfileRules(digester, path, "component");
        this.addPoolingProfileRules(digester, path);
        this.addQueueProfileRules(digester, path);
        digester.addRule(path + "/interceptor", new Rule(){

            public void begin(String string, String string1, Attributes attributes) throws Exception {
                String value = attributes.getValue("className");
                UMOManager man = (UMOManager)this.digester.getRoot();
                List interceptorStack = man.lookupInterceptorStack(value);
                MuleDescriptor temp = (MuleDescriptor)this.digester.peek();
                if (interceptorStack != null) {
                    Iterator iter = interceptorStack.iterator();
                    while (iter.hasNext()) {
                        temp.addInterceptor((UMOInterceptor)iter.next());
                    }
                } else {
                    Class<?> clazz = this.digester.getClassLoader().loadClass(value);
                    Object instance = clazz.newInstance();
                    temp.addInterceptor((UMOInterceptor)instance);
                    this.digester.push(instance);
                }
            }

            public void end(String s, String s1) throws Exception {
                if (this.digester.peek() instanceof UMOInterceptor) {
                    this.digester.pop();
                }
            }
        });
        this.addMulePropertiesRule(path + "/interceptor", digester, true);
        this.addExceptionStrategyRules(digester, path);
        this.addSetPropertiesRule(path, digester);
        this.addMulePropertiesRule(path, digester, false);
        digester.addSetNext(path + "/properties", "setProperties");
        digester.addRule(path, new Rule(){

            public void end(String s, String s1) throws Exception {
                UMODescriptor descriptor = (UMODescriptor)this.digester.peek();
                Object obj = this.digester.peek(1);
                if (obj instanceof UMOManager) {
                    ((UMOManager)obj).getModel().registerComponent(descriptor);
                } else {
                    ((UMOModel)obj).registerComponent(descriptor);
                }
            }
        });
    }

    protected void addThreadingProfileRules(Digester digester, String path, final String type) {
        digester.addRule(path + "/threading-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleManager cfr_ignored_0 = (MuleManager)this.digester.getRoot();
                MuleConfiguration cfg = MuleManager.getConfiguration();
                if ("component".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageReceiver".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else if ("messageDispatcher".equals(type)) {
                    this.digester.push((Object)cfg.getComponentThreadingProfile());
                } else {
                    this.digester.push((Object)cfg.getDefaultThreadingProfile());
                }
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule threadingRule = new SetPropertiesRule();
        threadingRule.addAlias("setPoolExhaustedAction", "setPoolExhaustedActionString");
        digester.addRule(path + "/threading-profile", (Rule)threadingRule);
        digester.addSetNext(path + "/threading-profile", "setThreadingProfile");
    }

    protected void addPoolingProfileRules(Digester digester, String path) {
        digester.addRule(path + "/pooling-profile", new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                MuleManager cfr_ignored_0 = (MuleManager)this.digester.getRoot();
                MuleConfiguration cfg = MuleManager.getConfiguration();
                this.digester.push((Object)cfg.getPoolingProfile());
            }

            public void end(String s, String s1) throws Exception {
                this.digester.pop();
            }
        });
        SetPropertiesRule rule = new SetPropertiesRule();
        rule.addAlias("exhaustedAction", "exhaustedActionString");
        rule.addAlias("initialisationPolicy", "initialisationPolicyString");
        digester.addRule(path + "/pooling-profile", (Rule)rule);
        digester.addSetNext(path + "/pooling-profile", "setPoolingProfile");
    }

    protected void addQueueProfileRules(Digester digester, String path) {
        digester.addObjectCreate(path + "/queue-profile", QUEUE_PROFILE);
        this.addSetPropertiesRule(path + "/queue-profile", digester);
        digester.addObjectCreate(path + "/queue-profile/persistence-strategy", PERSISTENCE_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/queue-profile/persistence-strategy", digester, true);
        digester.addSetNext(path + "/queue-profile/persistence-strategy", "setPersistenceStrategy");
        digester.addSetNext(path + "/queue-profile", "setQueueProfile");
    }

    protected void addMessageRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        String defaultRouter = null;
        String setMethod = null;
        if ("inbound".equals(type)) {
            defaultRouter = DEFAULT_INBOUND_MESSAGE_ROUTER;
            setMethod = "setInboundRouter";
            path = path + "/inbound-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else if ("response".equals(type)) {
            defaultRouter = DEFAULT_RESPONSE_MESSAGE_ROUTER;
            setMethod = "setResponseRouter";
            path = path + "/response-router";
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        } else {
            defaultRouter = DEFAULT_OUTBOUND_MESSAGE_ROUTER;
            setMethod = "setOutboundRouter";
            path = path + "/outbound-router";
        }
        digester.addObjectCreate(path, defaultRouter, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addObjectCreate(path + "/catch-all-strategy", DEFAULT_CATCH_ALL_STRATEGY, "className");
        this.addSetPropertiesRule(path + "/catch-all-strategy", digester);
        this.addEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path + "/catch-all-strategy", "setEndpoint");
        this.addMulePropertiesRule(path + "/catch-all-strategy", digester, true);
        digester.addSetNext(path + "/catch-all-strategy", "setCatchAllStrategy");
        this.addRouterRules(digester, path, type);
        digester.addSetNext(path, setMethod);
    }

    protected void addRouterRules(Digester digester, String path, String type) throws ConfigurationException {
        path = path + "/router";
        if ("inbound".equals(type)) {
            digester.addObjectCreate(path, INBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        } else if ("response".equals(type)) {
            digester.addObjectCreate(path, RESPONSE_MESSAGE_ROUTER_INTERFACE, "className");
        } else {
            digester.addObjectCreate(path, OUTBOUND_MESSAGE_ROUTER_INTERFACE, "className");
        }
        this.addSetPropertiesRule(path, digester, new String[]{"enableCorrelation"}, new String[]{"enableCorrelationAsString"});
        this.addMulePropertiesRule(path, digester, true);
        if ("outbound".equals(type)) {
            this.addEndpointRules(digester, path, "addEndpoint");
            this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
            this.addTransactionConfigRules(path, digester);
        }
        this.addFilterRules(digester, path);
        digester.addSetNext(path, "addRouter");
    }

    protected void addFilterRules(Digester digester, String path) throws ConfigurationException {
        this.addSingleFilterRule(digester, path);
        path = path + "/filter";
        this.addFilterGroupRule(digester, path);
        this.addFilterGroupRule(digester, path + "/left-filter");
        this.addFilterGroupRule(digester, path + "/right-filter");
        this.addFilterGroupRule(digester, path + "/filter");
        this.addFilterGroupRule(digester, path + "/left-filter/left-filter");
        this.addFilterGroupRule(digester, path + "/left-filter/right-filter");
        this.addFilterGroupRule(digester, path + "/left-filter/filter");
        this.addFilterGroupRule(digester, path + "/right-filter/left-filter");
        this.addFilterGroupRule(digester, path + "/right-filter/right-filter");
        this.addFilterGroupRule(digester, path + "/right-filter/filter");
        this.addFilterGroupRule(digester, path + "/filter/left-filter");
        this.addFilterGroupRule(digester, path + "/filter/right-filter");
        this.addFilterGroupRule(digester, path + "/filter/filter");
    }

    protected void addFilterGroupRule(Digester digester, String path) throws ConfigurationException {
        this.addLeftFilterRule(digester, path);
        this.addRightFilterRule(digester, path);
        this.addSingleFilterRule(digester, path);
    }

    protected void addLeftFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/left-filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path, "setLeftFilter");
    }

    protected void addRightFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/right-filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path, "setRightFilter");
    }

    protected void addSingleFilterRule(Digester digester, String path) throws ConfigurationException {
        path = path + "/filter";
        digester.addObjectCreate(path, FILTER_INTERFACE, "className");
        this.addSetPropertiesRule(path, digester);
        digester.addSetNext(path, "setFilter");
    }

    protected void addEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        path = path + "/endpoint";
        digester.addObjectCreate(path, DEFAULT_ENDPOINT);
        this.addCommonEndpointRules(digester, path, method);
    }

    protected void addGlobalReferenceEndpointRules(Digester digester, String path, final String method) throws ConfigurationException {
        path = path + "/global-endpoint";
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String name = attributes.getValue("name");
                String address = attributes.getValue("address");
                String trans = attributes.getValue("transformers");
                String createConnector = attributes.getValue("createConnector");
                EndpointReference ref = new EndpointReference(method, name, address, trans, createConnector, this.digester.peek());
                this.digester.push((Object)ref);
            }

            public void end(String endpointName, String endpointName1) throws Exception {
                MuleXmlConfigurationBuilder.this.endpointReferences.add((EndpointReference)this.digester.pop());
            }
        });
        this.addCommonEndpointRules(digester, path, null);
    }

    protected void addCommonEndpointRules(Digester digester, String path, String method) throws ConfigurationException {
        this.addSetPropertiesRule(path, digester, new String[]{"address", "transformers", "createConnector"}, new String[]{"endpointURI", "transformer", "createConnectorAsString"});
        this.addMulePropertiesRule(path, digester, false);
        this.addTransactionConfigRules(path, digester);
        this.addFilterRules(digester, path);
        if (method != null) {
            digester.addSetNext(path, method);
        }
        digester.addObjectCreate(path + "/security-filter", ENDPOINT_SECURITY_FILTER_INTERFACE, "className");
        this.addMulePropertiesRule(path + "/security-filter", digester, true);
        digester.addSetNext(path + "/security-filter", "setSecurityFilter");
    }

    protected void addTransactionConfigRules(String path, Digester digester) {
        digester.addObjectCreate(path + "/transaction", DEFAULT_TRANSACTION_CONFIG);
        this.addSetPropertiesRule(path + "/transaction", digester, new String[]{"action"}, new String[]{"actionAsString"});
        digester.addObjectCreate(path + "/transaction/constraint", TRANSACTION_CONSTRAINT_INTERFACE, "className");
        this.addSetPropertiesRule(path + "/transaction/constraint", digester);
        digester.addSetNext(path + "/transaction/constraint", "setConstraint");
        digester.addSetNext(path + "/transaction", "setTransactionConfig");
    }

    protected void addExceptionStrategyRules(Digester digester, String path) throws ConfigurationException {
        path = path + "/exception-strategy";
        digester.addObjectCreate(path, EXCEPTION_STRATEGY_INTERFACE, "className");
        this.addMulePropertiesRule(path, digester, true);
        this.addEndpointRules(digester, path, "addEndpoint");
        this.addGlobalReferenceEndpointRules(digester, path, "addEndpoint");
        digester.addSetNext(path, "setExceptionListener");
    }

    protected void addSetPropertiesRule(String path, Digester digester) {
        digester.addRule(path, (Rule)new MuleSetPropertiesRule());
    }

    protected void addSetPropertiesRule(String path, Digester digester, String[] s1, String[] s2) {
        digester.addRule(path, (Rule)new MuleSetPropertiesRule(s1, s2));
    }

    protected void addMulePropertiesRule(String path, Digester digester, final boolean setAsBeanProperties) {
        if (!path.endsWith("environment-properties")) {
            path = path + "/properties";
        }
        digester.addRule(path, (Rule)new ObjectCreateRule(path, class$java$util$HashMap == null ? (class$java$util$HashMap = MuleXmlConfigurationBuilder.class$("java.util.HashMap")) : class$java$util$HashMap){

            public void end(String string, String string1) throws Exception {
                Map props = (Map)this.digester.peek();
                if (props.containsKey("org.mule.useManagerProperties")) {
                    props.putAll(MuleManager.getInstance().getProperties());
                    props.remove("org.mule.useManagerProperties");
                }
                super.end(string, string1);
                String trans = (String)props.remove("transformer");
                if (setAsBeanProperties) {
                    org.mule.util.BeanUtils.populateWithoutFail(this.digester.peek(), props, true);
                } else {
                    BeanUtils.setProperty((Object)this.digester.peek(), (String)string1, (Object)props);
                }
                if (trans != null) {
                    MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", trans, this.digester.peek());
                }
            }
        });
        digester.addCallMethod(path + "/property", "put", 2);
        digester.addRule(path + "/property", (Rule)new CallParamRule(0, "name"){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        digester.addRule(path + "/property", (Rule)new CallParamRule(1, "value"){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        this.addPropertyFactoryRule(digester, path + "/factory-property");
        this.addSystemPropertyRule(digester, path + "/system-property");
        this.addFilePropertiesRule(digester, path + "/file-properties");
        this.addContainerPropertyRule(digester, path + "/container-property", setAsBeanProperties);
        digester.addObjectCreate(path + "/map", class$java$util$HashMap == null ? (class$java$util$HashMap = MuleXmlConfigurationBuilder.class$("java.util.HashMap")) : class$java$util$HashMap);
        digester.addCallMethod(path + "/map/property", "put", 2);
        digester.addRule(path + "/map/property", (Rule)new CallParamRule(0, "name"){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        digester.addRule(path + "/map/property", (Rule)new CallParamRule(1, "value"){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        this.addPropertyFactoryRule(digester, path + "/map/factory-property");
        this.addSystemPropertyRule(digester, path + "/map/system-property");
        this.addFilePropertiesRule(digester, path + "/map/file-properties");
        this.addContainerPropertyRule(digester, path + "/map/container-property", false);
        digester.addRule(path + "/map", (Rule)new CallMethodRule("put", 2){

            public void end(String string, String string1) throws Exception {
                Map props = (Map)this.digester.peek();
                if (props.containsKey("org.mule.useManagerProperties")) {
                    props.putAll(MuleManager.getInstance().getProperties());
                    props.remove("org.mule.useManagerProperties");
                }
                Object o = this.digester.peek(1);
                this.digester.push(o);
                super.end(string, string1);
                o = this.digester.pop();
            }
        });
        digester.addCallParam(path + "/map", 0, "name");
        digester.addCallParam(path + "/map", 1, true);
        digester.addObjectCreate(path + "/list", class$java$util$ArrayList == null ? (class$java$util$ArrayList = MuleXmlConfigurationBuilder.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        digester.addRule(path + "/list/entry", (Rule)new CallMethodRule("add", 1){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        digester.addRule(path + "/list/entry", (Rule)new CallParamRule(0, "value"){

            public void begin(String endpointName, String endpointName1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, endpointName1);
                super.begin(endpointName, endpointName1, attributes);
            }
        });
        this.addPropertyFactoryRule(digester, path + "/list/factory-entry");
        this.addSystemPropertyRule(digester, path + "/list/system-entry");
        this.addContainerPropertyRule(digester, path + "/list/container-entry", false);
        digester.addRule(path + "/list", (Rule)new CallMethodRule("put", 2){

            public void end(String string, String string1) throws Exception {
                Object o = this.digester.peek(1);
                this.digester.push(o);
                super.end(string, string1);
                o = this.digester.pop();
            }
        });
        digester.addCallParam(path + "/list", 0, "name");
        digester.addCallParam(path + "/list", 1, true);
    }

    protected void addPropertyFactoryRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, s1);
                String clazz = attributes.getValue("factory");
                String name = attributes.getValue("name");
                Object props = this.digester.peek();
                Object obj = ClassHelper.instanciateClass(clazz, ClassHelper.NO_ARGS);
                if (obj instanceof PropertyFactory) {
                    obj = props instanceof Map ? ((PropertyFactory)obj).create((Map)props) : ((PropertyFactory)obj).create((Map)this.digester.peek(1));
                }
                if (obj != null) {
                    if (props instanceof Map) {
                        ((Map)props).put(name, obj);
                    } else {
                        ((List)props).add(obj);
                    }
                }
            }
        });
    }

    protected void addSystemPropertyRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                String defaultValue;
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, s1);
                String name = attributes.getValue("name");
                String key = attributes.getValue("key");
                String value = System.getProperty(key, defaultValue = attributes.getValue("defaultValue"));
                if (value != null) {
                    Object props = this.digester.peek();
                    if (props instanceof Map) {
                        ((Map)props).put(name, value);
                    } else {
                        ((List)props).add(value);
                    }
                }
            }
        });
    }

    protected void addFilePropertiesRule(Digester digester, String path) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, s1);
                String location = attributes.getValue("location");
                String temp = attributes.getValue("override");
                boolean override = "true".equalsIgnoreCase(temp);
                InputStream is = Utility.loadResource(location, ((Object)((Object)this)).getClass());
                if (is == null) {
                    throw new FileNotFoundException(location);
                }
                Properties p = new Properties();
                p.load(is);
                Map props = (Map)this.digester.peek();
                if (override) {
                    props.putAll(p);
                } else {
                    Iterator<Object> iterator = p.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        if (props.containsKey(key)) continue;
                        props.put(key, p.getProperty(key));
                    }
                }
            }
        });
    }

    protected void addContainerPropertyRule(Digester digester, String path, final boolean setAsBeanProperties) {
        digester.addRule(path, new Rule(){

            public void begin(String s, String s1, Attributes attributes) throws Exception {
                attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, s1);
                String name = attributes.getValue("name");
                String value = attributes.getValue("reference");
                String required = attributes.getValue("required");
                String container = attributes.getValue("container");
                if (required == null) {
                    required = "true";
                }
                boolean req = Boolean.valueOf(required);
                Object obj = null;
                obj = setAsBeanProperties ? this.digester.peek(1) : this.digester.peek();
                MuleXmlConfigurationBuilder.this.addContainerReference(name, value, obj, req, container);
            }
        });
    }

    private void addContainerReference(String propName, String containerRef, Object object, boolean required, String container) {
        this.containerReferences.add(new ContainerReference(propName, containerRef, object, required, container));
    }

    private void addTransformerReference(String propName, String transName, Object object) {
        this.transformerReferences.add(new TransformerReference(propName, transName, object));
    }

    private void addEndpointReference(String propName, String endpointName, Object object) {
        this.endpointReferences.add(new EndpointReference(propName, endpointName, null, null, null, object));
    }

    private static Attributes processAttributes(Attributes attributes, String elementName) throws ConfigurationException {
        AttributesImpl attribs = new AttributesImpl(attributes);
        String value = null;
        String realValue = null;
        String key = null;
        if (elementName.equals("property")) {
            System.out.println("");
        }
        UMOManager manager = MuleManager.getInstance();
        for (int i = 0; i < attribs.getLength(); ++i) {
            value = attribs.getValue(i);
            int x = value.indexOf("${");
            while (x > -1) {
                int y = value.indexOf("}", x + 1);
                if (y == -1) {
                    throw new ConfigurationException(new Message(158, "<" + elementName + attribs.getLocalName(i) + "='" + value + "' ...>"));
                }
                key = value.substring(x + 2, y);
                realValue = (String)manager.getProperty(key);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Param is '" + value + "', Property key is '" + key + "', Property value is '" + realValue + "'"));
                }
                if (realValue != null) {
                    value = value.substring(0, x) + realValue + value.substring(y + 1);
                } else {
                    logger.info((Object)("Property for placeholder: '" + key + "' was not found.  Leaving place holder as is"));
                }
                x = value.indexOf("${", y);
            }
            attribs.setValue(i, value);
        }
        return attribs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MuleSetPropertiesRule
    extends SetPropertiesRule {
        public MuleSetPropertiesRule() {
        }

        public MuleSetPropertiesRule(String s, String s1) {
            super(s, s1);
        }

        public MuleSetPropertiesRule(String[] strings, String[] strings1) {
            super(strings, strings1);
        }

        public void begin(String s1, String s2, Attributes attributes) throws Exception {
            Object o;
            String endpoint;
            String transformerNames = (attributes = MuleXmlConfigurationBuilder.processAttributes(attributes, s2)).getValue("transformer");
            if (transformerNames != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("transformers")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("transformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("inboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("inboundTransformer", transformerNames, this.digester.peek());
            }
            if ((transformerNames = attributes.getValue("outboundTransformer")) != null) {
                MuleXmlConfigurationBuilder.this.addTransformerReference("outboundTransformer", transformerNames, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("inboundEndpoint")) != null && (o = PropertiesHelper.getProperty(MuleXmlConfigurationBuilder.this.manager.getEndpoints(), endpoint, null)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setInboundEndpoint", endpoint, this.digester.peek());
            }
            if ((endpoint = attributes.getValue("outboundEndpoint")) != null && (o = PropertiesHelper.getProperty(MuleXmlConfigurationBuilder.this.manager.getEndpoints(), endpoint, null)) != null) {
                MuleXmlConfigurationBuilder.this.addEndpointReference("setOutboundEndpoint", endpoint, this.digester.peek());
            }
            super.begin(attributes);
        }
    }
}

