/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.client;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.extras.client.RemoteDispatcher;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.security.MuleCredentials;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.FutureMessageResult;
import org.mule.umo.MessagingException;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class MuleClient
implements Disposable {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$extras$client$MuleClient == null ? (class$org$mule$extras$client$MuleClient = MuleClient.class$("org.mule.extras.client.MuleClient")) : class$org$mule$extras$client$MuleClient));
    private UMOManager manager;
    private List dispatchers = new ArrayList();
    QuickConfigurationBuilder builder = null;
    private MuleCredentials user;
    static /* synthetic */ Class class$org$mule$extras$client$MuleClient;
    static /* synthetic */ Class class$org$mule$config$builders$MuleXmlConfigurationBuilder;

    public MuleClient() throws UMOException {
        this.init();
    }

    public MuleClient(String configResources) throws UMOException {
        this(configResources, new MuleXmlConfigurationBuilder());
    }

    public MuleClient(String user, String password) throws UMOException {
        this.init();
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    public MuleClient(String configResources, ConfigurationBuilder builder) throws ConfigurationException {
        if (MuleManager.isInstanciated()) {
            throw new ConfigurationException(new Message(159));
        }
        if (builder == null) {
            logger.info((Object)("Builder passed in was null, using default builder: " + (class$org$mule$config$builders$MuleXmlConfigurationBuilder == null ? (class$org$mule$config$builders$MuleXmlConfigurationBuilder = MuleClient.class$("org.mule.config.builders.MuleXmlConfigurationBuilder")) : class$org$mule$config$builders$MuleXmlConfigurationBuilder).getName()));
            builder = new MuleXmlConfigurationBuilder();
        }
        this.manager = builder.configure(configResources);
    }

    public MuleClient(String configResources, ConfigurationBuilder builder, String user, String password) throws ConfigurationException {
        this(configResources, builder);
        this.user = new MuleCredentials(user, password.toCharArray());
    }

    private void init() throws UMOException {
        MuleManager.getConfiguration().setClientMode(!MuleManager.isInstanciated());
        this.manager = MuleManager.getInstance();
        this.builder = new QuickConfigurationBuilder();
        if (!this.manager.isInitialised()) {
            logger.info((Object)"Initialising a new Mule Manager");
            ((MuleManager)this.manager).start();
        }
    }

    public void dispatch(String url, Object payload, Map messageProperties) throws UMOException {
        MuleEndpointURI muleEndpoint = new MuleEndpointURI(url);
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOEvent event = this.getEvent(message, muleEndpoint, false);
        try {
            event.getSession().dispatchEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(new Message("client", 1), event.getMessage(), event.getEndpoint(), e);
        }
    }

    public UMOMessage sendDirect(String component, String transformers, Object payload, Map messageProperties) throws UMOException {
        boolean compregistered = this.getManager().getModel().isComponentRegistered(component);
        if (!compregistered) {
            throw new MessagingException(new Message(82, "Component '" + component + "'"), payload, null);
        }
        UMOTransformer trans = null;
        if (transformers != null) {
            trans = MuleObjectHelper.getTransformer(transformers, ",");
        }
        if (!MuleManager.getConfiguration().isSynchronous()) {
            logger.warn((Object)"The mule manager is running synchronously, a null message payload will be returned");
        }
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOSession session = this.getManager().getModel().getComponentSession(component);
        UMOEndpoint endpoint = this.getDefaultClientEndpoint(session.getComponent().getDescriptor(), payload);
        MuleEvent event = new MuleEvent((UMOMessage)message, endpoint, session, true);
        logger.debug((Object)("MuleClient sending event direct to: " + component + ". Event is: " + event));
        UMOMessage result = event.getComponent().sendEvent(event);
        logger.debug((Object)("Result of MuleClient sendDirect is: " + (result == null ? "null" : result.getPayload())));
        if (result != null && trans != null) {
            return new MuleMessage(trans.transform(result.getPayload()), null);
        }
        return result;
    }

    public void dispatchDirect(String component, Object payload, Map messageProperties) throws UMOException {
        boolean compregistered = this.getManager().getModel().isComponentRegistered(component);
        if (!compregistered) {
            throw new MessagingException(new Message(82, "Component '" + component + "'"), payload, null);
        }
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOSession session = this.getManager().getModel().getComponentSession(component);
        UMOEndpoint endpoint = this.getDefaultClientEndpoint(session.getComponent().getDescriptor(), payload);
        MuleEvent event = new MuleEvent((UMOMessage)message, endpoint, session, true);
        logger.debug((Object)("MuleClient dispatching event direct to: " + component + ". Event is: " + event));
        event.getComponent().dispatchEvent(event);
    }

    public FutureMessageResult sendAsync(String url, Object payload, Map messageProperties) throws UMOException {
        return this.sendAsync(url, payload, messageProperties, 0);
    }

    public FutureMessageResult sendAsync(final String url, final Object payload, final Map messageProperties, final int timeout) throws UMOException {
        FutureMessageResult result = new FutureMessageResult();
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.send(url, payload, messageProperties, timeout);
            }
        };
        result.execute(callable);
        return result;
    }

    public FutureMessageResult sendDirectAsync(final String component, String transformers, final Object payload, final Map messageProperties) throws UMOException {
        UMOTransformer trans = null;
        FutureMessageResult result = null;
        if (transformers != null) {
            trans = MuleObjectHelper.getTransformer(transformers, ",");
            result = new FutureMessageResult(trans);
        } else {
            result = new FutureMessageResult();
        }
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return MuleClient.this.sendDirect(component, null, payload, messageProperties);
            }
        };
        result.execute(callable);
        return result;
    }

    public UMOMessage send(String url, Object payload, Map messageProperties) throws UMOException {
        return this.send(url, payload, messageProperties, 0);
    }

    public UMOMessage send(String url, Object payload, Map messageProperties, int timeout) throws UMOException {
        MuleEndpointURI muleEndpoint = new MuleEndpointURI(url);
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        if (messageProperties.get("MULE_SYNC_RECEIVE") == null) {
            messageProperties.put("MULE_SYNC_RECEIVE", "true");
        }
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOEvent event = this.getEvent(message, muleEndpoint, true);
        event.setTimeout(timeout);
        UMOMessage result = null;
        try {
            result = event.getSession().sendEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(new Message("client", 1), event.getMessage(), event.getEndpoint(), e);
        }
        return result;
    }

    public UMOMessage receive(String url, long timeout) throws UMOException {
        MuleEndpointURI muleEndpoint = new MuleEndpointURI(url);
        UMOEndpoint endpoint = ImmutableMuleEndpoint.getOrCreateEndpointForUri(muleEndpoint, "sender");
        try {
            UMOMessage message = endpoint.getConnector().getDispatcher(muleEndpoint.getAddress()).receive(muleEndpoint, timeout);
            return message;
        }
        catch (Exception e) {
            throw new ReceiveException(muleEndpoint, timeout, e);
        }
    }

    public UMOMessage receive(String url, String transformers, long timeout) throws UMOException {
        return this.receive(url, MuleObjectHelper.getTransformer(transformers, ","), timeout);
    }

    public UMOMessage receive(String url, UMOTransformer transformer, long timeout) throws UMOException {
        UMOMessage message = this.receive(url, timeout);
        if (message != null && transformer != null) {
            return new MuleMessage(transformer.transform(message.getPayload()), null);
        }
        return message;
    }

    protected UMOEvent getEvent(UMOMessage message, UMOEndpointURI uri, boolean synchronous) throws UMOException {
        UMOEndpoint endpoint = ImmutableMuleEndpoint.getOrCreateEndpointForUri(uri, "sender");
        if (!endpoint.getConnector().isStarted() && this.manager.isStarted()) {
            endpoint.getConnector().start();
        }
        try {
            MuleSession session = new MuleSession();
            if (this.user != null) {
                message.setProperty("MULE_USER", "Plain " + this.user.getToken());
            }
            MuleEvent event = new MuleEvent(message, endpoint, session, synchronous);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(new Message(65, "Client event"), message, endpoint, e);
        }
    }

    protected UMOEndpoint getDefaultClientEndpoint(UMODescriptor descriptor, Object payload) throws UMOException {
        UMOEndpoint endpoint = descriptor.getInboundEndpoint();
        if (endpoint != null) {
            if (endpoint.getTransformer() != null) {
                if (endpoint.getTransformer().isSourceTypeSupported(payload.getClass())) {
                    return endpoint;
                }
                endpoint = new MuleEndpoint(endpoint);
                endpoint.setTransformer(null);
                return endpoint;
            }
            return endpoint;
        }
        UMOConnector connector = null;
        MuleEndpointURI defaultEndpointUri = new MuleEndpointURI("vm://localhost/mule.client");
        connector = ConnectorFactory.createConnector(defaultEndpointUri);
        connector.initialise();
        this.manager.registerConnector(connector);
        connector.start();
        endpoint = new MuleEndpoint("muleClientProvider", defaultEndpointUri, connector, null, "receiver", 0, null);
        if (endpoint != null) {
            this.manager.registerEndpoint(endpoint);
        }
        return endpoint;
    }

    public void sendNoReceive(String url, Object payload, Map messageProperties) throws UMOException {
        MuleEndpointURI muleEndpoint = new MuleEndpointURI(url);
        if (messageProperties == null) {
            messageProperties = new HashMap<String, String>();
        }
        messageProperties.put("MULE_SYNC_RECEIVE", "false");
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOEvent event = this.getEvent(message, muleEndpoint, true);
        try {
            event.getSession().sendEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(new Message("client", 1), event.getMessage(), event.getEndpoint(), e);
        }
    }

    public UMOManager getManager() {
        return MuleManager.getInstance();
    }

    public void registerComponent(Object component, String name, MuleEndpointURI listenerEndpoint) throws UMOException {
        this.builder.registerComponentInstance(component, name, listenerEndpoint, null);
    }

    public void registerComponent(Object component, String name, MuleEndpointURI listenerEndpoint, MuleEndpointURI sendEndpoint) throws UMOException {
        this.builder.registerComponentInstance(component, name, listenerEndpoint, sendEndpoint);
    }

    public void registerComponent(UMODescriptor descriptor) throws UMOException {
        this.builder.registerComponent(descriptor);
    }

    public void unregisterComponent(String name) throws UMOException {
        this.builder.unregisterComponent(name);
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint) throws MalformedEndpointException {
        RemoteDispatcher rd = new RemoteDispatcher(this, serverEndpoint);
        this.dispatchers.add(rd);
        return rd;
    }

    public RemoteDispatcher getRemoteDispatcher(String serverEndpoint, String user, String password) throws MalformedEndpointException {
        RemoteDispatcher rd = new RemoteDispatcher(this, serverEndpoint, user, password);
        this.dispatchers.add(rd);
        return rd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List list = this.dispatchers;
        synchronized (list) {
            Iterator iterator = this.dispatchers.iterator();
            while (iterator.hasNext()) {
                RemoteDispatcher remoteDispatcher = (RemoteDispatcher)iterator.next();
                remoteDispatcher.dispose();
                this.dispatchers.remove(remoteDispatcher);
                Object var3_3 = null;
            }
        }
        if (MuleManager.getConfiguration().isClientMode()) {
            this.manager.dispose();
        }
    }

    public void setProperty(Object key, Object value) {
        this.manager.setProperty(key, value);
    }

    public Object getProperty(Object key) {
        return this.manager.getProperty(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

