/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.extras.client.AbstractEventTransformer;
import org.mule.extras.client.EventObjectTransformer;
import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.UMOTransformer;

public class MuleProxyListener
implements InvocationHandler {
    private Class listenerClass;
    private AbstractEventTransformer eventTransformer;
    private String componentName;
    private Object proxy;
    private MuleClient client;
    static /* synthetic */ Class class$org$mule$umo$UMOMessage;

    public MuleProxyListener(Class listenerClass, String componentName) throws UMOException {
        this.setListenerClass(listenerClass);
        this.setEventTransformer(new EventObjectTransformer());
        this.setComponentName(componentName);
        this.setClient(new MuleClient());
        this.createProxy();
    }

    public MuleProxyListener(Class listenerClass, AbstractEventTransformer eventTransformer, String componentName) throws UMOException {
        this.setListenerClass(listenerClass);
        this.setEventTransformer(eventTransformer);
        this.setComponentName(componentName);
        this.setClient(new MuleClient());
        this.createProxy();
    }

    public MuleProxyListener(Class listenerClass, AbstractEventTransformer eventTransformer, String componentName, MuleClient client) {
        this.setListenerClass(listenerClass);
        this.setEventTransformer(eventTransformer);
        this.setComponentName(componentName);
        this.setClient(client);
        this.createProxy();
    }

    protected void createProxy() {
        this.proxy = Proxy.newProxyInstance(this.listenerClass.getClassLoader(), new Class[]{this.listenerClass}, (InvocationHandler)this);
    }

    public Class getListenerClass() {
        return this.listenerClass;
    }

    public void setListenerClass(Class listenerClass) {
        this.listenerClass = listenerClass;
    }

    public UMOTransformer getEventTransformer() {
        return this.eventTransformer;
    }

    public void setEventTransformer(AbstractEventTransformer eventTransformer) {
        this.eventTransformer = eventTransformer;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public MuleClient getClient() {
        return this.client;
    }

    public void setClient(MuleClient client) {
        this.client = client;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args.length == 0) {
            throw new MuleException(new Message("client", 2));
        }
        UMOMessage message = this.eventTransformer.transform(args[0], method);
        if (!"void".equals(method.getReturnType().getName())) {
            UMOMessage result = this.client.sendDirect(this.componentName, null, message.getPayload(), message.getProperties());
            if ((class$org$mule$umo$UMOMessage == null ? (class$org$mule$umo$UMOMessage = MuleProxyListener.class$("org.mule.umo.UMOMessage")) : class$org$mule$umo$UMOMessage).equals(method.getReturnType())) {
                return result;
            }
            return result == null ? null : result.getPayload();
        }
        this.client.dispatchDirect(this.componentName, message.getPayload(), message.getProperties());
        return null;
    }

    public Object getProxy() {
        return this.proxy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

