/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.client;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.extras.client.MuleClient;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.internal.events.AdminEvent;
import org.mule.providers.service.ConnectorFactory;
import org.mule.umo.FutureMessageResult;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class RemoteDispatcher
implements Disposable {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$extras$client$RemoteDispatcher == null ? (class$org$mule$extras$client$RemoteDispatcher = RemoteDispatcher.class$("org.mule.extras.client.RemoteDispatcher")) : class$org$mule$extras$client$RemoteDispatcher));
    private MuleEndpointURI serverEndpoint;
    private MuleClient client;
    private XStream xstream = null;
    static /* synthetic */ Class class$org$mule$extras$client$RemoteDispatcher;

    RemoteDispatcher(MuleClient client, String endpoint, String user, String password) throws MalformedEndpointException {
        this(client, endpoint);
    }

    RemoteDispatcher(MuleClient client, String endpoint) throws MalformedEndpointException {
        this.serverEndpoint = new MuleEndpointURI(endpoint);
        this.xstream = new XStream((HierarchicalStreamDriver)new XppDriver());
        this.client = client;
    }

    public void dispatchToRemoteComponent(String component, Object payload, Map messageProperties) throws UMOException {
        this.doToRemoteComponent(component, payload, messageProperties, true);
    }

    public UMOMessage sendToRemoteComponent(String component, Object payload, Map messageProperties) throws UMOException {
        return this.doToRemoteComponent(component, payload, messageProperties, true);
    }

    public FutureMessageResult sendAsyncToRemoteComponent(final String component, String transformers, final Object payload, final Map messageProperties) throws UMOException {
        UMOTransformer trans = null;
        FutureMessageResult result = null;
        if (transformers != null) {
            trans = MuleObjectHelper.getTransformer(transformers, ",");
            result = new FutureMessageResult(trans);
        } else {
            result = new FutureMessageResult();
        }
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemoteComponent(component, payload, messageProperties, true);
            }
        };
        result.execute(callable);
        return result;
    }

    public UMOMessage sendRemote(String endpoint, Object payload, Map messageProperties) throws UMOException {
        return this.doToRemote(endpoint, payload, messageProperties, true);
    }

    public void dispatchRemote(String endpoint, Object payload, Map messageProperties) throws UMOException {
        this.doToRemote(endpoint, payload, messageProperties, false);
    }

    public FutureMessageResult sendAsyncRemote(final String endpoint, final Object payload, final Map messageProperties) throws UMOException {
        FutureMessageResult result = null;
        result = new FutureMessageResult();
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.doToRemote(endpoint, payload, messageProperties, true);
            }
        };
        result.execute(callable);
        return result;
    }

    public UMOMessage receiveRemote(String endpoint, int timeout) throws UMOException {
        AdminEvent action = new AdminEvent(501, null, endpoint);
        action.setProperty("MULE_SYNC_RECEIVE", "true");
        UMOMessage result = this.dispatchAction(action, true, timeout);
        return result;
    }

    public FutureMessageResult asyncReceiveRemote(final String endpoint, final int timeout) throws UMOException {
        FutureMessageResult result = null;
        result = new FutureMessageResult();
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return RemoteDispatcher.this.receiveRemote(endpoint, timeout);
            }
        };
        result.execute(callable);
        return result;
    }

    protected UMOMessage doToRemoteComponent(String component, Object payload, Map messageProperties, boolean synchronous) throws UMOException {
        MuleMessage message = new MuleMessage(payload, messageProperties);
        message.setBooleanProperty("MULE_SYNC_RECEIVE", synchronous);
        AdminEvent action = new AdminEvent(504, message, "mule://" + component);
        UMOMessage result = this.dispatchAction(action, synchronous, MuleManager.getConfiguration().getSynchronousEventTimeout());
        return result;
    }

    protected UMOMessage doToRemote(String endpoint, Object payload, Map messageProperties, boolean synchronous) throws UMOException {
        MuleMessage message = new MuleMessage(payload, messageProperties);
        message.setProperty("MULE_SYNC_RECEIVE", String.valueOf(synchronous));
        AdminEvent action = new AdminEvent(synchronous ? 503 : 502, message, endpoint);
        UMOMessage result = this.dispatchAction(action, synchronous, -1);
        return result;
    }

    protected UMOMessage dispatchAction(AdminEvent action, boolean synchronous, int timeout) throws UMOException {
        UMOMessage result;
        block4: {
            String xml = this.xstream.toXML((Object)action);
            MuleMessage message = new MuleMessage(xml, action.getMessage() == null ? null : action.getMessage().getProperties());
            message.addProperties(action.getProperties());
            UMOEndpoint endpoint = ConnectorFactory.createEndpoint(this.serverEndpoint, "sender");
            MuleSession session = new MuleSession();
            MuleEvent event = new MuleEvent((UMOMessage)message, endpoint, session, true);
            event.setTimeout(timeout);
            logger.debug((Object)("MuleClient sending remote call to: " + action.getEndpoint() + ". At " + this.serverEndpoint.toString() + " .Event is: " + event));
            UMOMessageDispatcher dispatcher = endpoint.getConnector().getDispatcher(this.serverEndpoint.getAddress());
            result = null;
            try {
                if (!synchronous) {
                    dispatcher.dispatch(event);
                    return null;
                }
                result = dispatcher.send(event);
                if (result == null) break block4;
                String resultXml = result.getPayloadAsString();
                if (resultXml != null && resultXml.length() > 0) {
                    result = (UMOMessage)this.xstream.fromXML(resultXml);
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
        }
        logger.debug((Object)("Result of MuleClient remote call is: " + (result == null ? "null" : result.getPayload())));
        return result;
    }

    public void dispose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

