/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleTransactionConfig;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.providers.service.ConnectorFactoryException;
import org.mule.umo.UMOException;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOTransactionConfig;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.RecoverableException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOEndpointSecurityFilter;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.MuleObjectHelper;

public class ImmutableMuleEndpoint
implements UMOImmutableEndpoint {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$ImmutableMuleEndpoint == null ? (class$org$mule$impl$ImmutableMuleEndpoint = ImmutableMuleEndpoint.class$("org.mule.impl.ImmutableMuleEndpoint")) : class$org$mule$impl$ImmutableMuleEndpoint));
    protected UMOConnector connector = null;
    protected UMOEndpointURI endpointUri = null;
    protected UMOTransformer transformer = null;
    protected String name = null;
    protected String type = "senderAndReceiver";
    protected Map properties = new HashMap();
    protected UMOTransactionConfig transactionConfig = null;
    protected UMOFilter filter = null;
    protected boolean deleteUnacceptedMessages = false;
    protected SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    protected UMOEndpointSecurityFilter securityFilter = null;
    protected Boolean synchronous = null;
    protected int createConnector = 0;
    static /* synthetic */ Class class$org$mule$impl$ImmutableMuleEndpoint;

    private ImmutableMuleEndpoint() {
    }

    public ImmutableMuleEndpoint(String endpoint, String type) throws UMOException {
        UMOEndpoint p = ImmutableMuleEndpoint.getOrCreateEndpointForUri(new MuleEndpointURI(endpoint), type);
        this.initFromDescriptor(p);
    }

    public ImmutableMuleEndpoint(String name, UMOEndpointURI endpointUri, UMOConnector connector, UMOTransformer transformer, String type, int createConnector, Map properties) {
        this.name = name;
        this.endpointUri = endpointUri;
        this.connector = connector;
        this.transformer = transformer;
        this.createConnector = createConnector;
        if (transformer != null) {
            this.getTransformer().setEndpoint(this);
        }
        this.type = type;
        if (properties != null) {
            this.properties = properties;
        }
        this.transactionConfig = new MuleTransactionConfig();
        if (properties != null && endpointUri != null) {
            properties.putAll(endpointUri.getParams());
        }
    }

    public ImmutableMuleEndpoint(UMOImmutableEndpoint source) {
        this();
        this.initFromDescriptor(source);
    }

    protected void initFromDescriptor(UMOImmutableEndpoint source) {
        if (this.name == null) {
            this.name = source.getName();
        }
        if (this.endpointUri == null) {
            this.endpointUri = source.getEndpointURI();
        }
        if (this.connector == null) {
            this.connector = source.getConnector();
        }
        if (this.transformer == null) {
            this.transformer = source.getTransformer();
        }
        if (this.transformer != null) {
            this.getTransformer().setEndpoint(this);
        }
        this.type = source.getType();
        if (source.getProperties() != null) {
            this.properties = source.getProperties();
        }
        this.transactionConfig = source.getTransactionConfig();
        if (this.properties != null && this.endpointUri != null) {
            this.properties.putAll(this.endpointUri.getParams());
        }
    }

    public UMOEndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getType() {
        return this.type;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public String getName() {
        return this.name;
    }

    public UMOTransformer getTransformer() {
        return this.transformer;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Object clone() {
        MuleEndpoint clone = new MuleEndpoint(this.name, this.endpointUri, this.connector, this.transformer, this.type, this.createConnector, this.properties == null ? null : new HashMap(this.properties));
        clone.setTransactionConfig(this.transactionConfig);
        clone.setFilter(this.filter);
        return clone;
    }

    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "ImmutableMuleEndpoint{connector=" + this.connector + ", endpointUri=" + this.endpointUri + ", transformer=" + this.transformer + ", name='" + this.name + "'" + ", type='" + this.type + "'" + ", properties=" + this.properties + ", transactionConfig=" + this.transactionConfig + ", filter=" + this.filter + ", deleteUnacceptedMessages=" + this.deleteUnacceptedMessages + ", initialised=" + this.initialised + ", securityFilter=" + this.securityFilter + ", synchronous=" + this.synchronous + ", createConnector=" + this.createConnector + "}";
    }

    public String getProtocol() {
        return this.connector.getProtocol();
    }

    public boolean canReceive() {
        return this.getType().equals("receiver") || this.getType().equals("senderAndReceiver");
    }

    public boolean canSend() {
        return this.getType().equals("sender") || this.getType().equals("senderAndReceiver");
    }

    public UMOTransactionConfig getTransactionConfig() {
        return this.transactionConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableMuleEndpoint)) {
            return false;
        }
        ImmutableMuleEndpoint immutableMuleProviderDescriptor = (ImmutableMuleEndpoint)o;
        if (!this.connector.getName().equals(immutableMuleProviderDescriptor.connector.getName())) {
            return false;
        }
        if (this.endpointUri != null && immutableMuleProviderDescriptor.endpointUri != null ? !this.endpointUri.getAddress().equals(immutableMuleProviderDescriptor.endpointUri.getAddress()) : immutableMuleProviderDescriptor.endpointUri != null) {
            return false;
        }
        if (!this.name.equals(immutableMuleProviderDescriptor.name)) {
            return false;
        }
        if (this.transformer != null ? !this.transformer.equals(immutableMuleProviderDescriptor.transformer) : immutableMuleProviderDescriptor.transformer != null) {
            return false;
        }
        return this.type.equals(immutableMuleProviderDescriptor.type);
    }

    public int hashCode() {
        int result = this.connector != null ? this.connector.hashCode() : 0;
        result = 29 * result + (this.endpointUri != null ? this.endpointUri.hashCode() : 0);
        result = 29 * result + (this.transformer != null ? this.transformer.hashCode() : 0);
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public UMOFilter getFilter() {
        return this.filter;
    }

    public static UMOEndpoint createEndpointFromUri(UMOEndpointURI uri, String type) throws UMOException {
        UMOEndpoint endpoint = ConnectorFactory.createEndpoint(uri, type);
        if (uri.getEndpointName() != null) {
            endpoint.setName(uri.getEndpointName());
        }
        return endpoint;
    }

    public static UMOEndpoint getEndpointFromUri(String uri) {
        UMOEndpoint endpoint = null;
        if (uri != null) {
            String endpointString = MuleManager.getInstance().lookupEndpointIdentifier(uri, uri);
            endpoint = MuleManager.getInstance().lookupEndpoint(endpointString);
        }
        return endpoint;
    }

    public static UMOEndpoint getEndpointFromUri(UMOEndpointURI uri) throws UMOException {
        UMOEndpoint endpoint = null;
        if (uri.getEndpointName() != null) {
            String endpointString = MuleManager.getInstance().lookupEndpointIdentifier(uri.getEndpointName(), uri.getEndpointName());
            endpoint = MuleManager.getInstance().lookupEndpoint(endpointString);
            if (endpoint != null && uri.getAddress() != null && uri.getAddress().length() > 0) {
                endpoint.setEndpointURI(uri);
            }
        }
        return endpoint;
    }

    public static UMOEndpoint getOrCreateEndpointForUri(String uriIdentifier, String type) throws UMOException {
        UMOEndpoint endpoint = ImmutableMuleEndpoint.getEndpointFromUri(uriIdentifier);
        if (endpoint == null) {
            endpoint = ImmutableMuleEndpoint.createEndpointFromUri(new MuleEndpointURI(uriIdentifier), type);
        } else if (endpoint.getType().equals("senderAndReceiver")) {
            endpoint.setType(type);
        } else if (!endpoint.getType().equals(type)) {
            throw new IllegalArgumentException("Endpoint matching: " + uriIdentifier + " is not of type: " + type + ". It is of type: " + endpoint.getType());
        }
        return endpoint;
    }

    public static UMOEndpoint getOrCreateEndpointForUri(UMOEndpointURI uri, String type) throws UMOException {
        UMOEndpoint endpoint = ImmutableMuleEndpoint.getEndpointFromUri(uri);
        if (endpoint == null) {
            endpoint = ImmutableMuleEndpoint.createEndpointFromUri(uri, type);
        }
        return endpoint;
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.deleteUnacceptedMessages;
    }

    public void initialise() throws InitialisationException, RecoverableException {
        String sync;
        if (this.initialised.get()) {
            logger.debug((Object)("Already initialised: " + this.toString()));
            return;
        }
        if (this.connector == null) {
            if (this.endpointUri.getConnectorName() != null) {
                this.connector = MuleManager.getInstance().lookupConnector(this.endpointUri.getConnectorName());
                if (this.connector == null) {
                    throw new IllegalArgumentException("Connector not found: " + this.endpointUri.getConnectorName());
                }
            } else {
                try {
                    this.connector = ConnectorFactory.getOrCreateConnectorByProtocol(this);
                    if (this.connector == null) {
                        throw new InitialisationException(new Message(156, this.endpointUri.getScheme()), (Object)this);
                    }
                }
                catch (ConnectorFactoryException e) {
                    throw new InitialisationException(new Message(84, this.endpointUri), e, this);
                }
            }
            if (this.endpointUri.getEndpointName() != null && this.name == null) {
                this.name = this.endpointUri.getEndpointName();
            }
        }
        if (this.name == null) {
            this.name = "_" + this.endpointUri.getScheme() + "Endpoint#" + this.hashCode();
            this.endpointUri.setEndpointName(this.name);
        }
        if ((sync = this.endpointUri.getParams().getProperty("synchronous", null)) != null) {
            this.synchronous = Boolean.valueOf(sync);
        }
        if (this.properties != null && this.endpointUri.getParams() != null) {
            this.properties.putAll(this.endpointUri.getParams());
        }
        if (this.endpointUri.getTransformers() != null) {
            try {
                this.transformer = MuleObjectHelper.getTransformer(this.endpointUri.getTransformers(), ",");
            }
            catch (MuleException e) {
                throw new InitialisationException(e, (Object)this);
            }
        }
        if (this.transformer == null && this.connector instanceof AbstractConnector) {
            this.transformer = "receiver".equals(this.type) ? ((AbstractConnector)this.connector).getDefaultInboundTransformer() : ((AbstractConnector)this.connector).getDefaultOutboundTransformer();
        }
        if (this.transformer != null) {
            this.transformer.setEndpoint(this);
        }
        if (this.securityFilter != null) {
            this.securityFilter.setEndpoint(this);
            this.securityFilter.initialise();
        }
        this.initialised.set(true);
    }

    public UMOEndpointSecurityFilter getSecurityFilter() {
        return this.securityFilter;
    }

    public boolean isSynchronous() {
        if (this.synchronous == null) {
            return MuleManager.getConfiguration().isSynchronous();
        }
        return this.synchronous;
    }

    public boolean isSynchronousExplicitlySet() {
        return this.synchronous != null;
    }

    public int getCreateConnector() {
        return this.createConnector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

