/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.QueueProfile;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.DefaultComponentExceptionStrategy;
import org.mule.impl.FailedToQueueEventException;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleModel;
import org.mule.impl.MuleProxy;
import org.mule.impl.RequestContext;
import org.mule.impl.internal.events.ComponentEvent;
import org.mule.management.stats.ComponentStatistics;
import org.mule.umo.ComponentException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.util.ObjectPool;
import org.mule.util.queue.BoundedPersistentQueue;

public final class MuleComponent
implements UMOComponent,
Work {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$impl$MuleComponent == null ? (class$org$mule$impl$MuleComponent = MuleComponent.class$("org.mule.impl.MuleComponent")) : class$org$mule$impl$MuleComponent));
    private MuleDescriptor descriptor = null;
    private ObjectPool proxyPool = null;
    private BoundedPersistentQueue queue;
    private ComponentStatistics stats = null;
    private UMOWorkManager workManager;
    private SynchronizedBoolean stopped = new SynchronizedBoolean(true);
    private SynchronizedBoolean stopping = new SynchronizedBoolean(false);
    private SynchronizedBoolean paused = new SynchronizedBoolean(false);
    private SynchronizedBoolean poolInitialised = new SynchronizedBoolean(false);
    private QueueProfile qProfile;
    private ExceptionListener exceptionListener = null;
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    private MuleModel model;
    static /* synthetic */ Class class$org$mule$impl$MuleComponent;

    public MuleComponent(MuleDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Descriptor cannot be null");
        }
        this.descriptor = descriptor;
        this.model = (MuleModel)MuleManager.getInstance().getModel();
    }

    public synchronized void initialise() throws InitialisationException {
        if (this.initialised.get()) {
            throw new InitialisationException(new Message(37, "Component '" + this.descriptor.getName() + "'"), (Object)this);
        }
        this.descriptor.initialise();
        this.exceptionListener = this.descriptor.getExceptionListener();
        this.stats = new ComponentStatistics(this.getName(), this.descriptor.getPoolingProfile().getMaxActive(), this.descriptor.getThreadingProfile().getMaxThreadsActive());
        this.stats.setEnabled(((MuleManager)MuleManager.getInstance()).getStatistics().isEnabled());
        ((MuleManager)MuleManager.getInstance()).getStatistics().add(this.stats);
        this.stats.setOutboundRouterStat(this.getDescriptor().getOutboundRouter().getStatistics());
        this.stats.setInboundRouterStat(this.getDescriptor().getInboundRouter().getStatistics());
        ThreadingProfile tp = this.descriptor.getThreadingProfile();
        this.workManager = tp.createWorkManager(this.descriptor.getName());
        try {
            this.workManager.start();
        }
        catch (UMOException e) {
            throw new InitialisationException(e, (Object)this);
        }
        try {
            this.queue = this.descriptor.getQueueProfile().createQueue(this.descriptor.getName());
            this.queue.setDeleteOnTake(false);
            this.qProfile = this.descriptor.getQueueProfile();
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InitialisationException(new Message(40, "Compoennt Queue"), e, this);
        }
        this.initialised.set(true);
        this.model.fireEvent(new ComponentEvent(this.descriptor, 301));
    }

    private void initialisePool() throws InitialisationException {
        try {
            this.proxyPool = this.descriptor.getPoolingProfile().getPoolFactory().createPool(this.descriptor);
            if (this.descriptor.getPoolingProfile().getInitialisationPolicy() == 2) {
                int i;
                ArrayList<Object> components = new ArrayList<Object>();
                int threads = this.descriptor.getPoolingProfile().getMaxActive();
                for (i = 0; i < threads; ++i) {
                    components.add(this.proxyPool.borrowObject());
                }
                for (i = 0; i < threads; ++i) {
                    this.proxyPool.returnObject(components.remove(0));
                }
            } else if (this.descriptor.getPoolingProfile().getInitialisationPolicy() == 1) {
                this.proxyPool.returnObject(this.proxyPool.borrowObject());
            }
            this.poolInitialised.set(true);
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(40, "Proxy Pool"), e, this);
        }
    }

    void finaliseEvent(UMOEvent event) {
        logger.debug((Object)("Finalising event for: " + this.descriptor.getName() + " event endpointUri is: " + event.getEndpoint().getEndpointURI()));
        this.queue.remove(event);
    }

    public void stop() throws UMOException {
        if (!this.stopped.get()) {
            logger.debug((Object)"Stopping UMOComponent");
            this.stopping.set(true);
            this.stopped.set(true);
            this.stopping.set(false);
            this.model.fireEvent(new ComponentEvent(this.descriptor, 303));
        }
    }

    public void start() throws UMOException {
        if (this.stopped.get()) {
            this.stopped.set(false);
            try {
                if (!this.poolInitialised.get()) {
                    this.initialisePool();
                }
                this.proxyPool.start();
                this.workManager.scheduleWork(this, Long.MAX_VALUE, null, null);
            }
            catch (Exception e) {
                throw new LifecycleException(new Message(42, "Component: " + this.descriptor.getName()), e, this);
            }
        }
        this.model.fireEvent(new ComponentEvent(this.descriptor, 302));
    }

    public void pause() {
        this.paused.set(true);
        this.model.fireEvent(new ComponentEvent(this.descriptor, 304));
    }

    public void resume() {
        this.paused.set(false);
        this.model.fireEvent(new ComponentEvent(this.descriptor, 305));
    }

    public void dispose() {
        try {
            if (!this.stopped.get()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            logger.error((Object)("Failed to stop component: " + this.descriptor.getName()), (Throwable)e);
        }
        try {
            if (this.queue != null) {
                this.queue.dispose();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Persistent Queue did not close properly: " + e));
        }
        try {
            if (this.workManager != null) {
                this.workManager.dispose();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Component Thread Pool did not close properly: " + e));
        }
        try {
            if (this.proxyPool != null) {
                this.proxyPool.clearPool();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Proxy Pool did not close properly: " + e));
        }
        this.model.fireEvent(new ComponentEvent(this.descriptor, 306));
        ((MuleManager)MuleManager.getInstance()).getStatistics().remove(this.stats);
    }

    public ComponentStatistics getStatistics() {
        return this.stats;
    }

    public UMODescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(UMOEvent event) throws UMOException {
        if (!event.getEndpoint().canReceive()) {
            UMOMessageDispatcher dispatcher = event.getEndpoint().getConnector().getDispatcher(event.getEndpoint().getEndpointURI().getAddress());
            try {
                dispatcher.dispatch(event);
            }
            catch (Exception e) {
                throw new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e);
            }
            return;
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventASync();
        }
        logger.debug((Object)("Component: " + this.descriptor.getName() + " has received asynchronous event on: " + event.getEndpoint().getEndpointURI()));
        if (this.queue.size() >= this.qProfile.getMaxOutstandingMessages()) {
            logger.trace((Object)("process maxQueueSize reached:" + this.qProfile.getMaxOutstandingMessages()));
            while (this.queue.size() >= this.qProfile.getMaxOutstandingMessages()) {
                BoundedPersistentQueue dispatcher = this.queue;
                synchronized (dispatcher) {
                    try {
                        Thread.yield();
                        this.queue.wait(this.qProfile.getBlockWait());
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                }
            }
        }
        try {
            this.queue.put(event);
            if (this.stats.isEnabled()) {
                this.stats.incQueuedEvent();
            }
        }
        catch (InterruptedException e) {
            FailedToQueueEventException e1 = new FailedToQueueEventException(new Message(106, this.getName()), event.getMessage(), this, e);
            this.handleException(e1);
        }
        logger.trace((Object)("Event added to queue for: " + this.descriptor.getName()));
    }

    public UMOMessage sendEvent(UMOEvent event) throws UMOException {
        while (this.paused.get()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Component: " + this.descriptor.getName() + " is paused. Blocking call until resume is called"));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {}
        }
        if (this.stats.isEnabled()) {
            this.stats.incReceivedEventSync();
        }
        logger.debug((Object)("Component: " + this.descriptor.getName() + " has received synchronous event on: " + event.getEndpoint().getEndpointURI()));
        UMOMessage result = null;
        MuleProxy proxy = null;
        try {
            proxy = (MuleProxy)this.proxyPool.borrowObject();
            this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
            proxy.setStatistics(this.getStatistics());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " : got proxy for " + event.getId() + " = " + proxy));
            }
            result = (UMOMessage)proxy.onCall(event);
            this.proxyPool.returnObject(proxy);
        }
        catch (Exception e) {
            try {
                this.proxyPool.returnObject(proxy);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (e instanceof UMOException) {
                throw (MuleException)e;
            }
            throw new ComponentException(event.getMessage(), this, (Throwable)e);
        }
        return result;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    ObjectPool getProxyPool() {
        return this.proxyPool;
    }

    public String toString() {
        return this.descriptor.getName();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void run() {
        MuleEvent event = null;
        MuleProxy proxy = null;
        while (!this.stopped.get() && !this.stopping.get()) {
            if (this.paused.get()) continue;
            try {
                event = (MuleEvent)this.queue.take();
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.stats.isEnabled()) {
                this.stats.decQueuedEvent();
            }
            if (event == null) continue;
            logger.debug((Object)("Component: " + this.descriptor.getName() + " dequeued event on: " + event.getEndpoint().getEndpointURI()));
            try {
                proxy = (MuleProxy)this.proxyPool.borrowObject();
                this.getStatistics().setComponentPoolSize(this.proxyPool.getSize());
                proxy.setStatistics(this.getStatistics());
            }
            catch (NoSuchElementException e) {
                this.handleException(new ComponentException(new Message(43), event.getMessage(), this, e));
            }
            catch (UMOException e) {
                this.handleException(e);
            }
            catch (Exception e) {
                this.handleException(new ComponentException(new Message(44), event.getMessage(), this, e));
            }
            if (proxy == null) {
                this.handleException(new ComponentException(new Message(44), event.getMessage(), this));
            }
            if (!proxy.isStarted()) {
                try {
                    proxy.start();
                }
                catch (UMOException e) {
                    this.handleException(e);
                }
            }
            proxy.onEvent(event);
            try {
                this.workManager.scheduleWork(proxy, Long.MAX_VALUE, null, null);
            }
            catch (WorkException e) {
                this.handleException(new ComponentException(new Message(127, this.descriptor.getName()), event.getMessage(), this, e));
            }
        }
    }

    public void release() {
    }

    protected void handleException(Exception e) {
        RequestContext.getEvent().getEndpoint().getConnector().getExceptionListener().exceptionThrown(e);
        if (this.exceptionListener instanceof DefaultComponentExceptionStrategy && ((DefaultComponentExceptionStrategy)this.exceptionListener).getComponent() == null) {
            ((DefaultComponentExceptionStrategy)this.exceptionListener).setComponent(this);
        }
        this.exceptionListener.exceptionThrown(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

