/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleSession;
import org.mule.impl.ResponseOutputStream;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.PropertiesHelper;
import org.mule.util.UUID;
import org.mule.util.Utility;

public class MuleEvent
extends EventObject
implements UMOEvent {
    private transient UMOEndpoint endpoint = null;
    private String id = null;
    private UMOMessage message = null;
    protected transient Iterator interceptorIterator;
    private transient UMOSession session;
    private SynchronizedBoolean stopFurtherProcessing = new SynchronizedBoolean(false);
    private SynchronizedBoolean synchronous = new SynchronizedBoolean(false);
    private int timeout = 0;
    private ResponseOutputStream outputStream = null;
    private Object transformedMessage = null;
    private Map properties = new HashMap();

    public MuleEvent(UMOMessage message, UMOEndpoint endpoint, UMOComponent component, UMOEvent previousEvent) {
        super(message.getPayload());
        this.message = message;
        this.id = this.generateEventId();
        this.session = previousEvent.getSession();
        ((MuleSession)this.session).setComponent(component);
        this.endpoint = endpoint;
        this.synchronous.set(previousEvent.isSynchronous());
        this.timeout = previousEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)previousEvent.getOutputStream();
        if (endpoint.getProperties() != null) {
            this.properties.putAll(endpoint.getProperties());
        }
        this.properties.putAll(previousEvent.getProperties());
        this.properties.putAll(message.getProperties());
    }

    public MuleEvent(UMOMessage message, UMOEndpoint endpoint, UMOSession session, boolean synchronous) {
        this(message, endpoint, session, synchronous, null);
    }

    public MuleEvent(UMOMessage message, UMOEndpoint endpoint, UMOSession session, boolean synchronous, ResponseOutputStream outputStream) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = this.generateEventId();
        this.synchronous.set(synchronous);
        this.timeout = MuleManager.getConfiguration().getSynchronousEventTimeout();
        this.outputStream = outputStream;
        if (endpoint.getProperties() != null) {
            this.properties.putAll(endpoint.getProperties());
        }
        this.properties.putAll(message.getProperties());
    }

    public MuleEvent(UMOMessage message, UMOEndpoint endpoint, UMOSession session, String eventId, boolean synchronous) {
        super(message.getPayload());
        this.message = message;
        this.endpoint = endpoint;
        this.session = session;
        this.id = eventId;
        this.synchronous.set(synchronous);
        this.timeout = MuleManager.getConfiguration().getSynchronousEventTimeout();
        if (endpoint.getProperties() != null) {
            this.properties.putAll(endpoint.getProperties());
        }
        this.properties.putAll(message.getProperties());
    }

    public MuleEvent(UMOMessage message, UMOEvent rewriteEvent) {
        super(message.getPayload());
        Map prevProps;
        this.message = message;
        this.id = rewriteEvent.getId();
        this.session = rewriteEvent.getSession();
        ((MuleSession)this.session).setComponent(rewriteEvent.getComponent());
        this.endpoint = rewriteEvent.getEndpoint();
        this.synchronous.set(rewriteEvent.isSynchronous());
        this.timeout = rewriteEvent.getTimeout();
        this.outputStream = (ResponseOutputStream)rewriteEvent.getOutputStream();
        if (rewriteEvent instanceof MuleEvent) {
            this.transformedMessage = ((MuleEvent)rewriteEvent).getCachedMessage();
        }
        if (this.endpoint.getProperties() != null) {
            this.properties.putAll(this.endpoint.getProperties());
        }
        if ((prevProps = rewriteEvent.getProperties()) != null) {
            this.properties.putAll(prevProps);
        }
        this.properties.putAll(message.getProperties());
    }

    Object getCachedMessage() {
        return this.transformedMessage;
    }

    public UMOMessage getMessage() {
        return this.message;
    }

    public byte[] getMessageAsBytes() throws MuleException {
        try {
            return this.message.getPayloadAsBytes();
        }
        catch (Exception e) {
            throw new MuleException(new Message(69, this.message.getPayload().getClass().getName()), (Throwable)e);
        }
    }

    public Object getTransformedMessage() throws TransformerException {
        if (this.transformedMessage == null) {
            UMOTransformer tran = this.endpoint.getTransformer();
            this.transformedMessage = tran != null ? tran.transform(this.message.getPayload()) : this.message.getPayload();
        }
        return this.transformedMessage;
    }

    public byte[] getTransformedMessageAsBytes() throws TransformerException {
        try {
            return Utility.objectToByteArray(this.getTransformedMessage());
        }
        catch (IOException e) {
            throw new TransformerException(new Message(69, this.getTransformedMessage().getClass().getName()), this.endpoint.getTransformer(), e);
        }
    }

    public String getTransformedMessageAsString() throws TransformerException {
        return new String(this.getTransformedMessageAsBytes());
    }

    public String getMessageAsString() throws MuleException {
        try {
            return this.message.getPayloadAsString();
        }
        catch (Exception e) {
            throw new MuleException(new Message(70, this.message.getClass().getName()), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object prop = this.getProperty(name);
        return prop == null ? defaultValue : prop;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Map getProperties() {
        if (this.message.getCorrelationId() != null) {
            this.properties.put("MULE_CORRELATION_ID", this.message.getCorrelationId());
        }
        if (this.message.getCorrelationGroupSize() != -1) {
            this.properties.put("MULE_CORRELATION_GROUP", new Integer(this.message.getCorrelationGroupSize()));
        }
        if (this.message.getCorrelationSequence() != -1) {
            this.properties.put("MULE_CORRELATION_SEQUENCE", new Integer(this.message.getCorrelationSequence()));
        }
        if (this.message.getReplyTo() != null) {
            this.properties.put("MULE_REPLYTO", this.message.getReplyTo());
        }
        return this.properties;
    }

    public UMOEndpoint getEndpoint() {
        return this.endpoint;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Event: ").append(this.getId());
        buf.append(", sync=").append(this.isSynchronous());
        buf.append(", stop processing=").append(this.isStopFurtherProcessing());
        buf.append(", ").append(this.endpoint);
        return buf.toString();
    }

    protected String generateEventId() {
        return new UUID().getUUID();
    }

    public UMOSession getSession() {
        return this.session;
    }

    void setSession(UMOSession session) {
        this.session = session;
    }

    public UMOComponent getComponent() {
        return this.session.getComponent();
    }

    public boolean isStopFurtherProcessing() {
        return this.stopFurtherProcessing.get();
    }

    public void setStopFurtherProcessing(boolean stopFurtherProcessing) {
        this.stopFurtherProcessing.set(stopFurtherProcessing);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MuleEvent)) {
            return false;
        }
        MuleEvent event = (MuleEvent)o;
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        return this.id.equals(event.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 29 * result + (this.message != null ? this.message.hashCode() : 0);
        return result;
    }

    public boolean isSynchronous() {
        return this.synchronous.get();
    }

    public void setSynchronous(boolean value) {
        this.synchronous.set(value);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getIntProperty(String name, int defaultValue) {
        return PropertiesHelper.getIntProperty(this.properties, name, defaultValue);
    }

    public long getLongProperty(String name, long defaultValue) {
        return PropertiesHelper.getLongProperty(this.properties, name, defaultValue);
    }

    public double getDoubleProperty(String name, double defaultValue) {
        return PropertiesHelper.getDoubleProperty(this.properties, name, defaultValue);
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return PropertiesHelper.getBooleanProperty(this.properties, name, defaultValue);
    }

    public void setBooleanProperty(String name, boolean value) {
        this.properties.put(name, new Boolean(value));
    }

    public void setIntProperty(String name, int value) {
        this.properties.put(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) {
        this.properties.put(name, new Long(value));
    }

    public void setDoubleProperty(String name, double value) {
        this.properties.put(name, new Double(value));
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Object removeProperty(Object key) {
        return this.properties.remove(key);
    }
}

