/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.internal.admin;

import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.admin.AbstractEventLoggerAgent;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.provider.UMOMessageDispatcher;

public class EndpointAbstractEventLoggerAgent
extends AbstractEventLoggerAgent {
    private String endpointAddress;
    private UMOEndpoint logEndpoint = null;
    private UMOSession session = null;

    protected void doInitialise() throws InitialisationException {
        try {
            if (this.endpointAddress != null) {
                this.logEndpoint = MuleEndpoint.getOrCreateEndpointForUri(this.endpointAddress, "sender");
                this.session = new MuleSession();
            }
        }
        catch (Exception e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    protected void logEvent(UMOServerEvent e) {
        if (this.logEndpoint != null) {
            try {
                UMOMessageDispatcher dispatcher = this.logEndpoint.getConnector().getDispatcher("ANY");
                MuleEvent event = new MuleEvent((UMOMessage)new MuleMessage(e.toString(), null), this.logEndpoint, this.session, false);
                dispatcher.dispatch(event);
            }
            catch (Exception e1) {
                logger.error((Object)("Failed to dispatch event: " + e.toString() + " over endpoint: " + this.logEndpoint + ". Error is: " + e1.getMessage()), (Throwable)e1);
            }
        }
    }

    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName()).append(": ");
        if (this.endpointAddress != null) {
            buf.append("Forwarding events to: " + this.endpointAddress);
        } else {
            buf.append("No log forwarding endpoint is configured!");
        }
        return buf.toString();
    }
}

