/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.agents;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.i18n.Message;
import org.mule.impl.internal.events.ModelEventListener;
import org.mule.management.agents.JmxManagementException;
import org.mule.management.mbeans.ComponentService;
import org.mule.management.mbeans.ModelService;
import org.mule.management.mbeans.MuleConfigurationService;
import org.mule.management.mbeans.MuleService;
import org.mule.management.mbeans.StatisticsService;
import org.mule.umo.UMOException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOServerEvent;

public class JmxAgent
implements UMOAgent {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$management$agents$JmxAgent == null ? (class$org$mule$management$agents$JmxAgent = JmxAgent.class$("org.mule.management.agents.JmxAgent")) : class$org$mule$management$agents$JmxAgent));
    private String name;
    protected boolean locateServer = true;
    private boolean createServer = true;
    private String connectorServerUrl;
    private MBeanServer mBeanServer;
    private JMXConnectorServer connectorServer;
    private boolean enableStatistics = true;
    private List registeredMBeans = new ArrayList();
    static /* synthetic */ Class class$org$mule$management$agents$JmxAgent;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        if (this.connectorServerUrl != null) {
            return "JMX Agent: " + this.connectorServerUrl;
        }
        return "JMX Agent";
    }

    public void initialise() throws InitialisationException {
        ArrayList<MBeanServer> l;
        if (!this.locateServer && !this.createServer) {
            throw new InitialisationException(new Message(113), (Object)this);
        }
        if (this.mBeanServer == null && this.locateServer && (l = MBeanServerFactory.findMBeanServer(null)) != null && l.size() > 0) {
            this.mBeanServer = (MBeanServer)l.get(0);
        }
        if (this.mBeanServer == null && this.createServer) {
            this.mBeanServer = MBeanServerFactory.createMBeanServer();
        }
        if (this.mBeanServer == null) {
            throw new InitialisationException(new Message(114), (Object)this);
        }
        if (this.connectorServerUrl != null) {
            try {
                JMXServiceURL url = new JMXServiceURL(this.connectorServerUrl);
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mBeanServer);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message(65, "Jmx Connector"), e, this);
            }
        }
        MuleManager.getInstance().registerListener(new ModelEventListener(){

            public void onEvent(UMOServerEvent event) {
                if (event.getAction() == 202) {
                    try {
                        JmxAgent.this.registerStatisticsService();
                        JmxAgent.this.registerMuleService();
                        JmxAgent.this.registerModelService();
                        JmxAgent.this.registerComponentServices();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(new Message(40, "MBeans"), (Throwable)e);
                    }
                }
            }
        });
    }

    public void start() throws UMOException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.start();
            }
            catch (Exception e) {
                throw new JmxManagementException(new Message(42, "Jmx Connector"), (Throwable)e);
            }
        }
    }

    public void stop() throws UMOException {
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (Exception e) {
                throw new JmxManagementException(new Message(41, "Jmx Connector"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.mBeanServer != null) {
            Iterator iterator = this.registeredMBeans.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                try {
                    this.mBeanServer.unregisterMBean(objectName);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to unregister MBean: " + objectName + ". Error is: " + e.getMessage()));
                }
            }
            MBeanServerFactory.releaseMBeanServer(this.mBeanServer);
            this.mBeanServer = null;
        }
    }

    public void registered() {
    }

    public void unregistered() {
    }

    protected void registerStatisticsService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = new ObjectName("Mule:type=statistics");
        StatisticsService mBean = new StatisticsService();
        mBean.setManager(MuleManager.getInstance());
        mBean.setEnabled(this.isEnableStatistics());
        this.mBeanServer.registerMBean(mBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerModelService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = new ObjectName("Mule:type=control,name=ModelService");
        ModelService serviceMBean = new ModelService();
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerMuleService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = new ObjectName("Mule:type=control,name=MuleService");
        MuleService serviceMBean = new MuleService();
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerConfigurationService() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        ObjectName on = new ObjectName("Mule:type=control,name=ConfigurationService");
        MuleConfigurationService serviceMBean = new MuleConfigurationService();
        this.mBeanServer.registerMBean(serviceMBean, on);
        this.registeredMBeans.add(on);
    }

    protected void registerComponentServices() throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, MalformedObjectNameException {
        Iterator iter = MuleManager.getInstance().getModel().getComponentNames();
        while (iter.hasNext()) {
            String name = iter.next().toString();
            ObjectName on = new ObjectName("Mule:type=control,name=" + name + "ComponentService");
            ComponentService serviceMBean = new ComponentService(name);
            this.mBeanServer.registerMBean(serviceMBean, on);
            this.registeredMBeans.add(on);
        }
    }

    public boolean isCreateServer() {
        return this.createServer;
    }

    public void setCreateServer(boolean createServer) {
        this.createServer = createServer;
    }

    public boolean isLocateServer() {
        return this.locateServer;
    }

    public void setLocateServer(boolean locateServer) {
        this.locateServer = locateServer;
    }

    public String getConnectorServerUrl() {
        return this.connectorServerUrl;
    }

    public void setConnectorServerUrl(String connectorServerUrl) {
        this.connectorServerUrl = connectorServerUrl;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

