/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UniqueIdNotSupportedException;

public abstract class AbstractMessageAdapter
implements UMOMessageAdapter {
    protected Map properties = new HashMap();
    protected UMOExceptionPayload exceptionPayload;

    public Object removeProperty(Object key) {
        Object prop = this.properties.get(key);
        if (prop != null) {
            this.properties.remove(key);
        }
        return prop;
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        throw new UniqueIdNotSupportedException(this);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object result = this.properties.get(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getIntProperty(String name, int defaultValue) {
        Object result = this.properties.get(name);
        if (result != null) {
            if (result instanceof Integer) {
                return (Integer)result;
            }
            try {
                return Integer.parseInt(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        Object result = this.properties.get(name);
        if (result != null) {
            if (result instanceof Long) {
                return (Long)result;
            }
            try {
                return Long.parseLong(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Object result = this.properties.get(name);
        if (result != null) {
            if (result instanceof Double) {
                return (Double)result;
            }
            try {
                return Double.parseDouble(result.toString());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Object result = this.properties.get(name);
        if (result != null) {
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return Boolean.valueOf(result.toString());
        }
        return defaultValue;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.properties.put(name, new Boolean(value));
    }

    public void setIntProperty(String name, int value) {
        this.properties.put(name, new Integer(value));
    }

    public void setLongProperty(String name, long value) {
        this.properties.put(name, new Long(value));
    }

    public void setDoubleProperty(String name, double value) {
        this.properties.put(name, new Double(value));
    }

    public Object getReplyTo() {
        return this.getProperty("MULE_REPLYTO");
    }

    public void setReplyTo(Object replyTo) {
        this.setProperty("MULE_REPLYTO", replyTo);
    }

    public String getCorrelationId() {
        return (String)this.getProperty("MULE_CORRELATION_ID");
    }

    public void setCorrelationId(String correlationId) {
        this.setProperty("MULE_CORRELATION_ID", correlationId);
    }

    public int getCorrelationSequence() {
        return this.getIntProperty("MULE_CORRELATION_SEQUENCE", -1);
    }

    public void setCorrelationSequence(int sequence) {
        this.setIntProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    public int getCorrelationGroupSize() {
        return this.getIntProperty("MULE_CORRELATION_GROUP", -1);
    }

    public void setCorrelationGroupSize(int size) {
        this.setIntProperty("MULE_CORRELATION_GROUP", size);
    }

    public UMOExceptionPayload getExceptionPayload() {
        return this.exceptionPayload;
    }

    public void setExceptionPayload(UMOExceptionPayload payload) {
        this.exceptionPayload = payload;
    }
}

