/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import java.beans.ExceptionListener;
import javax.resource.spi.work.Work;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.RequestContext;
import org.mule.providers.AbstractConnector;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageDispatcher;
import org.mule.umo.security.SecurityException;

public abstract class AbstractMessageDispatcher
implements UMOMessageDispatcher,
ExceptionListener {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected UMOWorkManager workManager = null;
    protected boolean disposeOnCompletion = false;
    protected AbstractConnector connector;
    protected boolean disposed = false;
    protected boolean doThreading = true;

    public AbstractMessageDispatcher(AbstractConnector connector) {
        this.init(connector);
        this.disposeOnCompletion = connector.isDisposeDispatcherOnCompletion();
    }

    private void init(AbstractConnector connector) {
        this.connector = connector;
        if (connector instanceof AbstractConnector) {
            ThreadingProfile profile = connector.getDispatcherThreadingProfile();
            this.doThreading = profile.isDoThreading();
            if (this.doThreading) {
                this.workManager = profile.createWorkManager(connector.getName());
                try {
                    this.workManager.start();
                }
                catch (UMOException e) {
                    throw new MuleRuntimeException(new Message(42, "WorkManager"), (Throwable)e);
                }
            }
        }
    }

    public final void dispatch(UMOEvent event) throws Exception {
        try {
            event.setSynchronous(false);
            event.setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
            RequestContext.setEvent(event);
            UMOEndpoint endpoint = event.getEndpoint();
            if (endpoint.getSecurityFilter() != null) {
                try {
                    endpoint.getSecurityFilter().authenticate(event);
                }
                catch (SecurityException e) {
                    this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                    this.connector.handleException(e);
                    if (this.disposeOnCompletion) {
                        this.dispose();
                    }
                    return;
                }
            }
            event = RequestContext.getEvent();
            UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
            if (this.doThreading && !event.isSynchronous() && tx == null) {
                this.workManager.scheduleWork(new Worker(event));
            } else {
                this.doDispatch(event);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)"Exception occurred while executing on this dispatcher. disposing before continuing");
            this.dispose();
            throw e;
        }
        finally {
            if (this.disposeOnCompletion) {
                this.dispose();
            }
        }
    }

    public final UMOMessage send(UMOEvent event) throws Exception {
        try {
            event.setSynchronous(true);
            event.setProperty("MULE_ENDPOINT", event.getEndpoint().getEndpointURI().toString());
            RequestContext.setEvent(event);
            UMOEndpoint endpoint = event.getEndpoint();
            if (endpoint.getSecurityFilter() != null) {
                try {
                    endpoint.getSecurityFilter().authenticate(event);
                }
                catch (SecurityException e) {
                    this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                    this.connector.handleException(e);
                    UMOMessage uMOMessage = event.getMessage();
                    if (this.disposeOnCompletion) {
                        this.dispose();
                    }
                    return uMOMessage;
                }
            }
            event = RequestContext.getEvent();
            try {
                UMOMessage result;
                UMOMessage uMOMessage = result = this.doSend(event);
                return uMOMessage;
            }
            catch (Exception e) {
                this.logger.info((Object)"Exception occurred while executing on this dispatcher. disposing before continuing");
                this.dispose();
                throw e;
            }
        }
        finally {
            if (this.disposeOnCompletion) {
                this.dispose();
            }
        }
    }

    public void exceptionThrown(Exception e) {
        this.getConnector().handleException(e);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        if (!this.disposed) {
            try {
                this.doDispose();
                Object var2_1 = null;
                this.connector.getDispatchers().values().remove(this);
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.connector.getDispatchers().values().remove(this);
                this.disposed = true;
                throw throwable;
            }
            this.disposed = true;
            {
            }
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public abstract void doDispose();

    public abstract void doDispatch(UMOEvent var1) throws Exception;

    public abstract UMOMessage doSend(UMOEvent var1) throws Exception;

    private class Worker
    implements Work {
        private UMOEvent event;

        public Worker(UMOEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RequestContext.setEvent(this.event);
                AbstractMessageDispatcher.this.doDispatch(this.event);
            }
            catch (Exception e) {
                AbstractMessageDispatcher.this.dispose();
                AbstractMessageDispatcher.this.getConnector().handleException(e);
            }
            finally {
                if (AbstractMessageDispatcher.this.disposeOnCompletion) {
                    AbstractMessageDispatcher.this.dispose();
                }
            }
        }

        public void release() {
        }
    }
}

