/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.file.transformers.FileToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.umo.transformer.TransformerException;

public class FileContentsMessageAdapter
extends AbstractMessageAdapter {
    private FileToByteArray transformer = new FileToByteArray();
    private byte[] message = null;
    private File file = null;

    public FileContentsMessageAdapter(Object message) throws MessagingException {
        if (!(message instanceof File)) {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.setMessage((File)message);
    }

    public Object getPayload() {
        return this.message;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.message;
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.getPayloadAsBytes());
    }

    private void setMessage(File message) throws MessagingException {
        try {
            this.file = message;
            this.message = (byte[])this.transformer.transform(message);
            this.properties.put("originalFilename", this.file.getName());
            this.properties.put("directory", this.file.getAbsolutePath());
        }
        catch (TransformerException e) {
            throw new MessagingException(new Message(149, this.file.getAbsolutePath()), (Object)e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        return this.file.getAbsolutePath();
    }
}

