/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.file.transformers.FileToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UniqueIdNotSupportedException;

public class FileMessageAdapter
extends AbstractMessageAdapter {
    private FileToByteArray transformer = new FileToByteArray();
    private File message = null;
    private byte[] contents = null;

    public FileMessageAdapter(Object message) throws MessagingException {
        if (!(message instanceof File)) {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.setMessage((File)message);
    }

    public Object getPayload() {
        return this.message;
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.contents == null) {
            this.contents = (byte[])this.transformer.transform(this.message);
        }
        return this.contents;
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.getPayloadAsBytes());
    }

    private void setMessage(File message) {
        this.message = message;
        this.properties.put("originalFilename", this.message.getName());
        this.properties.put("directory", this.message.getAbsolutePath());
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        return this.message.getAbsolutePath();
    }
}

