/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.file.FileConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.Utility;

public class FileMessageDispatcher
extends AbstractMessageDispatcher {
    private FileConnector connector;

    public FileMessageDispatcher(FileConnector connector) {
        super(connector);
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDispatch(UMOEvent event) throws Exception {
        try {
            String endpoint = event.getEndpoint().getEndpointURI().getAddress();
            Object data = event.getTransformedMessage();
            String filename = (String)event.getProperty("filename");
            if (filename == null) {
                String outPattern = (String)event.getProperty("outputPattern");
                if (outPattern == null) {
                    outPattern = this.connector.getOutputPattern();
                }
                filename = this.generateFilename(event, outPattern);
            }
            if (filename == null) {
                throw new IOException("Filename is null");
            }
            File file = Utility.createFile(endpoint + "/" + filename);
            byte[] buf = data instanceof byte[] ? (byte[])data : data.toString().getBytes();
            this.logger.info((Object)("Writing file to: " + file.getAbsolutePath()));
            FileOutputStream fos = new FileOutputStream(file, this.connector.isOutputAppend());
            try {
                fos.write(buf);
            }
            finally {
                fos.close();
            }
        }
        catch (Exception e) {
            this.getConnector().handleException(e);
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        File file = new File(endpointUri.getAddress());
        File result = null;
        if (file.exists()) {
            if (file.isFile()) {
                result = file;
            } else if (file.isDirectory()) {
                result = this.getNextFile(endpointUri.getAddress());
            }
            if (result != null) {
                File destinationFile;
                MuleMessage message = new MuleMessage(this.connector.getMessageAdapter(result));
                if (this.connector.getMoveToDirectory() != null && !result.renameTo(destinationFile = new File(this.connector.getMoveToDirectory(), result.getName()))) {
                    this.logger.error((Object)("Failed to move file: " + result.getAbsolutePath() + " to " + destinationFile.getAbsolutePath()));
                }
                result.delete();
                return message;
            }
        }
        return null;
    }

    private File getNextFile(String dir) throws UMOException {
        File[] files = new File[]{};
        File file = new File(dir);
        File result = null;
        try {
            if (file.exists()) {
                if (file.isFile()) {
                    result = file;
                } else if (file.isDirectory() && (files = file.listFiles()).length > 0) {
                    result = files[0];
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MuleException(new Message("file", 1), (Throwable)e);
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return event.getMessage();
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    private String generateFilename(UMOEvent event, String pattern) {
        if (pattern == null) {
            pattern = this.connector.getOutputPattern();
        }
        return this.connector.getFilenameParser().getFilename(event, pattern);
    }

    public void doDispose() {
    }
}

