/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import java.io.File;
import java.io.FilenameFilter;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.file.FileConnector;
import org.mule.providers.file.filters.FilenameWildcardFilter;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class FileMessageReceiver
extends PollingMessageReceiver {
    private File readDir = null;
    private File moveDir = null;
    private String moveToPattern = null;
    private FilenameFilter filenameFilter = null;

    public FileMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, File readDir, File moveDir, String moveToPattern, Long frequency) throws InitialisationException {
        super(connector, component, endpoint, frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        this.filenameFilter = endpoint.getFilter() != null ? (FilenameFilter)((Object)endpoint.getFilter()) : new FilenameWildcardFilter("*");
    }

    public void poll() {
        try {
            File[] files = this.listFiles();
            if (files == null) {
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                this.processFile(files[i]);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public synchronized void processFile(File file) throws MuleException {
        File destinationFile = null;
        String orginalFilename = file.getName();
        if (this.moveDir != null) {
            String fileName = file.getName();
            if (this.moveToPattern != null) {
                fileName = ((FileConnector)this.connector).getFilenameParser().getFilename(null, this.moveToPattern);
            }
            destinationFile = new File(this.moveDir, fileName);
        }
        boolean resultOfFileMoveOperation = false;
        try {
            if (!(file.canRead() && file.exists() && file.isFile())) {
                throw new MuleException(new Message(149, file.getName()));
            }
            if (destinationFile != null) {
                resultOfFileMoveOperation = file.renameTo(destinationFile);
                if (!resultOfFileMoveOperation) {
                    throw new MuleException(new Message("file", 4, (Object)file.getAbsolutePath(), (Object)destinationFile.getAbsolutePath()));
                }
                file = destinationFile;
            }
            UMOMessageAdapter msgAdapter = this.connector.getMessageAdapter(file);
            msgAdapter.setProperty("originalFilename", orginalFilename);
            if (((FileConnector)this.connector).isAutoDelete()) {
                msgAdapter.getPayloadAsBytes();
                if (destinationFile == null && !(resultOfFileMoveOperation = file.delete())) {
                    throw new MuleException(new Message("file", 3, (Object)file.getAbsolutePath()));
                }
            }
            MuleMessage message = new MuleMessage(msgAdapter);
            this.routeMessage((UMOMessage)message, this.endpoint.isSynchronous());
        }
        catch (Exception e) {
            boolean resultOfRollbackFileMove = false;
            if (resultOfFileMoveOperation) {
                resultOfRollbackFileMove = this.rollbackFileMove(destinationFile, file.getAbsolutePath());
            }
            MuleException ex = new MuleException(new Message("file", 2, (Object)file.getName(), (Object)(resultOfRollbackFileMove ? "successful" : "unsuccessful")), (Throwable)e);
            this.handleException(ex);
        }
    }

    private boolean rollbackFileMove(File sourceFile, String destinationFilePath) {
        boolean result = false;
        try {
            result = sourceFile.renameTo(new File(destinationFilePath));
        }
        catch (Throwable t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
        }
        return result;
    }

    File[] listFiles() throws MuleException {
        File[] todoFiles = new File[]{};
        try {
            todoFiles = this.readDir.listFiles(this.filenameFilter);
        }
        catch (Exception e) {
            throw new MuleException(new Message("file", 1), (Throwable)e);
        }
        return todoFiles;
    }

    protected boolean allowFilter(UMOFilter filter) throws UnsupportedOperationException {
        return filter instanceof FilenameFilter;
    }
}

