/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.file;

import org.mule.providers.file.FilenameParser;
import org.mule.umo.UMOEvent;
import org.mule.util.UUID;
import org.mule.util.Utility;

public class SimpleFilenameParser
implements FilenameParser {
    public static final String DEFAULT_DATE_FORMAT = "dd-MM-yy_HH-mm-ss.SS";
    private long count = 1L;

    public String getFilename(UMOEvent event, String pattern) {
        String result = null;
        result = pattern != null && pattern.indexOf(123) > -1 ? this.getFilename(event, pattern, '{', '}') : this.getFilename(event, pattern, '[', ']');
        return result;
    }

    protected String getFilename(UMOEvent event, String pattern, char left, char right) {
        String filename = pattern;
        if (pattern == null) {
            filename = System.currentTimeMillis() + ".dat";
        } else {
            String name;
            int index = pattern.indexOf("$" + left + "DATE" + right);
            if (index > -1) {
                filename = filename.replaceAll("\\$\\" + left + "DATE\\" + right, Utility.getTimeStamp(DEFAULT_DATE_FORMAT));
            }
            if ((index = pattern.indexOf("$" + left + "DATE:")) > -1) {
                int curl = pattern.indexOf(right, index);
                if (curl == -1) {
                    filename = filename.replaceAll("\\$\\" + left + "DATE:", Utility.getTimeStamp(DEFAULT_DATE_FORMAT));
                } else {
                    String dateformat = pattern.substring(index + 7, curl);
                    filename = filename.replaceAll("\\$\\" + left + "DATE:" + dateformat + "\\" + right, Utility.getTimeStamp(dateformat));
                }
            }
            if ((index = pattern.indexOf("$" + left + "UUID" + right)) > -1) {
                filename = filename.replaceAll("\\$\\" + left + "UUID\\" + right, new UUID().getUUID());
            }
            if ((index = pattern.indexOf("$" + left + "SYSTIME" + right)) > -1) {
                filename = filename.replaceAll("\\$\\" + left + "SYSTIME\\" + right, String.valueOf(System.currentTimeMillis()));
            }
            if ((index = pattern.indexOf("$" + left + "COUNT" + right)) > -1) {
                filename = filename.replaceAll("\\$\\" + left + "COUNT\\" + right, String.valueOf(this.getCount()));
            }
            if ((index = pattern.indexOf("$" + left + "ORIGINALNAME" + right)) > -1 && event != null && (name = (String)event.getProperty("originalFilename")) != null) {
                filename = filename.replaceAll("\\$\\" + left + "ORIGINALNAME\\" + right, name);
            }
        }
        return filename;
    }

    protected synchronized long getCount() {
        return this.count++;
    }
}

