/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.TransactionException;

public class JmsClientAcknowledgeTransaction
extends AbstractSingleResourceTransaction {
    private Message message;

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        try {
            if (this.message == null) {
                throw new IllegalTransactionStateException(new org.mule.config.i18n.Message("jms", 6));
            }
            this.message.acknowledge();
        }
        catch (JMSException e) {
            throw new IllegalTransactionStateException(new org.mule.config.i18n.Message(97), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        if (this.message != null) {
            throw new UnsupportedOperationException("Jms Client Acknowledge doesn't support rollback");
        }
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (key instanceof Message) {
            this.message = (Message)key;
            return;
        }
        if (!(key instanceof Connection) || !(resource instanceof Session)) {
            throw new IllegalTransactionStateException(new org.mule.config.i18n.Message(120, "javax.jms.Connection/javax.jms.Session"));
        }
        Session session = (Session)resource;
        try {
            if (session.getTransacted()) {
                throw new IllegalTransactionStateException(new org.mule.config.i18n.Message("jms", 5));
            }
        }
        catch (JMSException e) {
            throw new IllegalTransactionStateException(new org.mule.config.i18n.Message(99), (Throwable)e);
        }
        super.bindResource(key, resource);
    }
}

