/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsMessageUtils;
import org.mule.providers.jms.JmsUtils;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.transaction.TransactionCoordination;
import org.mule.transaction.XaTransaction;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private Session session;
    private Session receiveSession;
    private MessageProducer producer;
    private MessageConsumer consumer;

    public JmsMessageDispatcher(JmsConnector connector) {
        super(connector);
        this.connector = connector;
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.dispatchMessage(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UMOMessage dispatchMessage(UMOEvent event) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". Event id is: " + event.getId()));
        }
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        boolean transacted = false;
        transacted = tx == null ? event.getEndpoint().getTransactionConfig() != null : tx instanceof XaTransaction;
        Session session = this.connector.getSession(tx != null);
        boolean syncReceive = event.getBooleanProperty("MULE_SYNC_RECEIVE", MuleManager.getConfiguration().isSynchronousReceive());
        if (tx != null && syncReceive) {
            throw new IllegalTransactionStateException(new Message("jms", 2));
        }
        MessageConsumer replyToConsumer = null;
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        boolean topic = false;
        String resourceInfo = endpointUri.getResourceInfo();
        topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
        Destination dest = this.connector.getJmsSupport().createDestination(session, endpointUri.getAddress(), topic);
        Object message = event.getTransformedMessage();
        if (!(message instanceof javax.jms.Message)) {
            throw new DispatchException(new Message(125, "JMS message", (Object)message.getClass().getName(), (Object)this.connector.getName()), event.getMessage(), event.getEndpoint());
        }
        javax.jms.Message msg = (javax.jms.Message)message;
        if (event.getMessage().getCorrelationId() != null) {
            msg.setJMSCorrelationID(event.getMessage().getCorrelationId());
        }
        Destination replyTo = null;
        Object tempReplyTo = event.removeProperty("JMSReplyTo");
        if (tempReplyTo != null) {
            if (tempReplyTo instanceof Destination) {
                replyTo = (Destination)tempReplyTo;
            } else {
                boolean replyToTopic = false;
                String reply = tempReplyTo.toString();
                int i = reply.indexOf(":");
                if (i > -1) {
                    String qtype = reply.substring(0, i);
                    replyToTopic = "topic".equalsIgnoreCase(qtype);
                    reply = reply.substring(i + 1);
                }
                replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic);
            }
            msg.setJMSReplyTo(replyTo);
        }
        if (syncReceive && replyTo == null) {
            replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
            msg.setJMSReplyTo(replyTo);
        }
        if (replyTo != null) {
            replyToConsumer = this.connector.getJmsSupport().createConsumer(session, replyTo);
        }
        if (this.producer == null) {
            this.producer = this.connector.getJmsSupport().createProducer(session, dest);
        }
        String ttlString = (String)event.removeProperty("TimeToLive");
        String priorityString = (String)event.removeProperty("Priority");
        String persistentDeliveryString = (String)event.removeProperty("PersistentDelivery");
        if (ttlString == null && priorityString == null && persistentDeliveryString == null) {
            this.connector.getJmsSupport().send(this.producer, msg);
        } else {
            long ttl = 0L;
            int priority = 4;
            boolean persistent = true;
            if (ttlString != null) {
                ttl = Long.parseLong(ttlString);
            }
            if (priorityString != null) {
                priority = Integer.parseInt(priorityString);
            }
            if (persistentDeliveryString != null) {
                persistent = Boolean.valueOf(persistentDeliveryString);
            }
            this.connector.getJmsSupport().send(this.producer, msg, persistent, priority, ttl);
        }
        if (replyToConsumer != null && event.isSynchronous()) {
            try {
                int timeout = event.getTimeout();
                this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                javax.jms.Message result = replyToConsumer.receive((long)timeout);
                if (result == null) {
                    this.logger.debug((Object)"No message was returned via replyTo destination");
                    UMOMessage priority = null;
                    return priority;
                }
                Object resultObject = JmsMessageUtils.getObjectForMessage(result);
                MuleMessage muleMessage = new MuleMessage(resultObject, null);
                return muleMessage;
            }
            finally {
                replyToConsumer.close();
            }
        }
        return null;
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage message = this.dispatchMessage(event);
        return message;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Session receiveSession = this.connector.getSession(tx instanceof XaTransaction);
        Destination dest = null;
        boolean topic = false;
        String resourceInfo = endpointUri.getResourceInfo();
        topic = resourceInfo != null && "topic".equalsIgnoreCase(resourceInfo);
        dest = this.connector.getJmsSupport().createDestination(receiveSession, endpointUri.getAddress(), topic);
        this.consumer = this.connector.getJmsSupport().createConsumer(receiveSession, dest);
        javax.jms.Message message = null;
        try {
            message = timeout == -1L ? this.consumer.receiveNoWait() : (timeout == 0L ? this.consumer.receive() : this.consumer.receive(timeout));
            if (message == null) {
                return null;
            }
            return new MuleMessage(this.connector.getMessageAdapter(message));
        }
        catch (Exception e) {
            this.connector.getExceptionListener().exceptionThrown(e);
            return null;
        }
    }

    public Object getDelegateSession() throws UMOException {
        try {
            if (this.session == null) {
                this.session = this.connector.getSession(false);
            }
            return this.session;
        }
        catch (Exception e) {
            throw new MuleException(new Message("jms", 3), (Throwable)e);
        }
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
        JmsUtils.closeQuietly(this.producer);
        JmsUtils.closeQuietly(this.consumer);
        JmsUtils.closeQuietly(this.receiveSession);
        JmsUtils.closeQuietly(this.session);
        this.producer = null;
        this.consumer = null;
        this.receiveSession = null;
        this.session = null;
    }
}

