/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import java.util.List;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.mule.impl.MuleMessage;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.jms.JmsClientAcknowledgeTransaction;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.jms.JmsUtils;
import org.mule.providers.jms.RedeliveryHandler;
import org.mule.providers.jms.filters.JmsSelectorFilter;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class JmsMessageReceiver
extends TransactedPollingMessageReceiver {
    protected JmsConnector connector;
    protected boolean reuseConsumer;
    protected boolean reuseSession;
    protected Session session;
    protected MessageConsumer consumer;
    protected long frequency;
    protected RedeliveryHandler redeliveryHandler;

    public JmsMessageReceiver() {
    }

    public JmsMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint, new Long(10L));
        this.connector = (JmsConnector)connector;
        this.frequency = 10000L;
        this.reuseConsumer = true;
        this.reuseSession = true;
        this.receiveMessagesInTransaction = endpoint.getTransactionConfig() != null;
        try {
            this.redeliveryHandler = this.connector.createRedeliveryHandler();
            this.redeliveryHandler.setConnector(this.connector);
        }
        catch (Exception e) {
            throw new InitialisationException(e, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        try {
            if (this.consumer == null) {
                this.createConsumer();
            }
            super.poll();
        }
        finally {
            this.closeConsumer();
        }
    }

    protected List getMessages() throws Exception {
        Message message;
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null) {
            tx.bindResource(this.connector.getConnection(), this.session);
        }
        if ((message = this.consumer.receive(this.frequency)) == null) {
            if (tx != null) {
                tx.setRollbackOnly();
            }
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message received it is of type: " + message.getClass().getName()));
            this.logger.debug((Object)("Message received on " + message.getJMSDestination() + " (" + message.getJMSDestination().getClass().getName() + ")"));
        }
        String correlationId = message.getJMSCorrelationID();
        this.logger.debug((Object)("Message CorrelationId is: " + correlationId));
        this.logger.info((Object)("Jms Message Id is: " + message.getJMSMessageID()));
        if (message.getJMSRedelivered()) {
            this.logger.info((Object)("Message with correlationId: " + correlationId + " is redelivered. handing off to Exception Handler"));
            this.redeliveryHandler.handleRedelivery(message);
        }
        if (tx instanceof JmsClientAcknowledgeTransaction) {
            tx.bindResource(message, null);
        }
        UMOMessageAdapter adapter = this.connector.getMessageAdapter(message);
        this.routeMessage(new MuleMessage(adapter));
        return null;
    }

    protected void processMessage(Object msg) throws Exception {
    }

    protected void closeConsumer() {
        if (!this.reuseSession || !this.reuseConsumer) {
            JmsUtils.closeQuietly(this.consumer);
            this.consumer = null;
        }
        if (!this.reuseSession) {
            JmsUtils.closeQuietly(this.session);
            this.session = null;
        }
    }

    protected void createConsumer() throws Exception {
        String durableName;
        String resourceInfo;
        JmsSupport jmsSupport = this.connector.getJmsSupport();
        if (this.session == null) {
            this.session = (Session)this.connector.getSession(this.endpoint);
        }
        boolean topic = (resourceInfo = this.endpoint.getEndpointURI().getResourceInfo()) != null && "topic".equalsIgnoreCase(resourceInfo);
        Destination dest = jmsSupport.createDestination(this.session, this.endpoint.getEndpointURI().getAddress(), topic);
        String selector = null;
        if (this.endpoint.getFilter() != null && this.endpoint.getFilter() instanceof JmsSelectorFilter) {
            selector = ((JmsSelectorFilter)this.endpoint.getFilter()).getExpression();
        } else if (this.endpoint.getProperties() != null) {
            selector = (String)this.endpoint.getProperties().get("selector");
        }
        String tempDurable = (String)this.endpoint.getProperties().get("durable");
        boolean durable = this.connector.isDurable();
        if (tempDurable != null) {
            durable = Boolean.valueOf(tempDurable);
        }
        if ((durableName = (String)this.endpoint.getProperties().get("durableName")) == null && durable && dest instanceof Topic) {
            durableName = "mule." + this.connector.getName() + "." + this.endpoint.getEndpointURI().getAddress();
            this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
        }
        this.consumer = jmsSupport.createConsumer(this.session, dest, selector, this.connector.isNoLocal(), durableName);
    }
}

