/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.config.i18n.Message;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.umo.TransactionException;

public class JmsTransaction
extends AbstractSingleResourceTransaction {
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof Connection) || !(resource instanceof Session)) {
            throw new IllegalTransactionStateException(new Message(120, "javax.jms.Connection/javax.jms.Session"));
        }
        Session session = (Session)resource;
        try {
            if (!session.getTransacted()) {
                throw new IllegalTransactionStateException(new Message("jms", 4));
            }
        }
        catch (JMSException e) {
            throw new IllegalTransactionStateException(new Message(99), (Throwable)e);
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
    }

    protected void doCommit() throws TransactionException {
        try {
            ((Session)this.resource).commit();
        }
        catch (JMSException e) {
            throw new TransactionException(new Message(97), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        try {
            ((Session)this.resource).rollback();
        }
        catch (JMSException e) {
            throw new TransactionException(new Message(98), (Throwable)e);
        }
    }
}

