/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.multicast;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.URI;
import javax.resource.spi.work.Work;
import org.mule.providers.AbstractConnector;
import org.mule.providers.udp.UdpMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;

public class MulticastMessageReceiver
extends UdpMessageReceiver {
    public MulticastMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected DatagramSocket createSocket(URI uri, InetAddress inetAddress) throws IOException {
        MulticastSocket socket = new MulticastSocket(uri.getPort());
        socket.joinGroup(inetAddress);
        return socket;
    }

    protected Work createWork(DatagramPacket packet) throws IOException {
        return new UdpMessageReceiver.UdpWorker(this, this.socket, packet);
    }

    public void doDispose() {
        try {
            ((MulticastSocket)this.socket).leaveGroup(this.inetAddress);
        }
        catch (IOException e) {
            this.logger.error((Object)("failed to leave group: " + e.getMessage()), (Throwable)e);
        }
    }
}

