/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.mule.config.i18n.Message;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOExceptionPayload;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UniqueIdNotSupportedException;
import org.mule.util.IteratorAdapter;
import org.mule.util.Utility;

public class HttpRequestMessageAdapter
implements UMOMessageAdapter {
    public static final String PAYLOAD_PARAMETER_NAME = "org.mule.servlet.payload.param";
    public static final String DEFAULT_PAYLOAD_PARAMETER_NAME = "payload";
    private Object message = null;
    protected UMOExceptionPayload exceptionPayload;
    private HttpServletRequest request;

    public HttpRequestMessageAdapter(Object message) throws MessagingException {
        this.setPayload(message);
    }

    public Object getPayload() {
        return this.message;
    }

    public boolean isBinary() {
        return this.message instanceof byte[];
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.isBinary()) {
            return (byte[])this.message;
        }
        return ((String)this.message).getBytes();
    }

    public String getPayloadAsString() throws Exception {
        if (this.isBinary()) {
            return new String((byte[])this.message);
        }
        return (String)this.message;
    }

    private void setPayload(Object message) throws MessagingException {
        if (message instanceof HttpServletRequest) {
            try {
                String payload;
                this.request = (HttpServletRequest)message;
                String payloadParam = (String)this.request.getAttribute(PAYLOAD_PARAMETER_NAME);
                if (payloadParam == null) {
                    payloadParam = DEFAULT_PAYLOAD_PARAMETER_NAME;
                }
                if ((payload = this.request.getParameter(payloadParam)) == null) {
                    if (this.isText(this.request.getContentType())) {
                        this.message = Utility.inputStreamToString((InputStream)this.request.getInputStream(), 4096);
                    }
                    this.message = Utility.inputStreamToByteArray((InputStream)this.request.getInputStream(), 4096);
                }
                this.message = payload;
            }
            catch (IOException e) {
                throw new MessagingException(new Message("servlet", 3, (Object)this.request.getRequestURL().toString()), (Object)e);
            }
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Object getProperty(Object key) {
        if (key == null) {
            return null;
        }
        Object prop = this.getRequest().getHeader(key.toString());
        if (prop == null && (prop = this.getRequest().getParameter(key.toString())) == null) {
            prop = this.getRequest().getAttribute(key.toString());
        }
        return prop;
    }

    public void setProperty(Object key, Object value) {
        if (key == null) {
            return;
        }
        this.getRequest().setAttribute(key.toString(), value);
    }

    public Object removeProperty(Object key) {
        if (key == null) {
            return null;
        }
        Object att = this.getRequest().getAttribute(key.toString());
        if (att != null) {
            this.getRequest().removeAttribute(key.toString());
        }
        return att;
    }

    public Iterator getPropertyNames() {
        return new IteratorAdapter(this.getRequest().getParameterNames());
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        if (this.getRequest().getSession() == null) {
            throw new UniqueIdNotSupportedException((UMOMessageAdapter)this, new Message(45, "Http session"));
        }
        return this.getRequest().getSession().getId();
    }

    protected boolean isText(String contentType) {
        if (contentType == null) {
            return true;
        }
        return contentType.startsWith("text/");
    }

    public Object getProperty(String name, Object defaultValue) {
        Object result = this.getProperty(name);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getIntProperty(String name, int defaultValue) {
        Object result = this.getProperty(name);
        if (result != null && result instanceof Integer) {
            return (Integer)result;
        }
        return defaultValue;
    }

    public long getLongProperty(String name, long defaultValue) {
        Object result = this.getProperty(name);
        if (result != null && result instanceof Long) {
            return (Long)result;
        }
        return defaultValue;
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Object result = this.getProperty(name);
        if (result != null && result instanceof Double) {
            return (Double)result;
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Object result = this.getProperty(name);
        if (result != null && result instanceof Boolean) {
            return (Boolean)result;
        }
        return defaultValue;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.getRequest().setAttribute(name, (Object)new Boolean(value));
    }

    public void setIntProperty(String name, int value) {
        this.getRequest().setAttribute(name, (Object)new Integer(value));
    }

    public void setLongProperty(String name, long value) {
        this.getRequest().setAttribute(name, (Object)new Long(value));
    }

    public void setDoubleProperty(String name, double value) {
        this.getRequest().setAttribute(name, (Object)new Double(value));
    }

    public void setCorrelationId(String id) {
        this.setProperty("MULE_CORRELATION_ID", id);
    }

    public String getCorrelationId() {
        return (String)this.getProperty("MULE_CORRELATION_ID");
    }

    public void setReplyTo(Object replyTo) {
        if (replyTo != null && replyTo.toString().startsWith("http")) {
            this.setProperty("Location", replyTo);
        }
        this.setProperty("MULE_CORRELATION_ID", replyTo);
    }

    public Object getReplyTo() {
        String replyto = (String)this.getProperty("MULE_REPLYTO");
        if (replyto == null) {
            replyto = (String)this.getProperty("Location");
        }
        return replyto;
    }

    public int getCorrelationSequence() {
        return this.getIntProperty("MULE_CORRELATION_SEQUENCE", -1);
    }

    public void setCorrelationSequence(int sequence) {
        this.setIntProperty("MULE_CORRELATION_SEQUENCE", sequence);
    }

    public int getCorrelationGroupSize() {
        return this.getIntProperty("MULE_CORRELATION_GROUP", -1);
    }

    public void setCorrelationGroupSize(int size) {
        this.setIntProperty("MULE_CORRELATION_GROUP", size);
    }

    public UMOExceptionPayload getExceptionPayload() {
        return this.exceptionPayload;
    }

    public void setExceptionPayload(UMOExceptionPayload exceptionPayload) {
        this.exceptionPayload = exceptionPayload;
    }
}

