/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.service.ConnectorFactory;
import org.mule.providers.servlet.ServletConnector;
import org.mule.providers.servlet.ServletMessageReceiver;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.EndpointNotFoundException;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.NoReceiverForEndpointException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.MuleObjectHelper;

public class MuleRESTReceiverServlet
extends HttpServlet {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$servlet$MuleRESTReceiverServlet == null ? (class$org$mule$providers$servlet$MuleRESTReceiverServlet = MuleRESTReceiverServlet.class$("org.mule.providers.servlet.MuleRESTReceiverServlet")) : class$org$mule$providers$servlet$MuleRESTReceiverServlet));
    public static final String REQUEST_TIMEOUT_PROPERTY = "org.mule.servlet.timeout";
    public static final String FEEDBACK_PROPERTY = "org.mule.servlet.feedback";
    public static final String DEFAULT_CONTENT_TYPE_PROPERTY = "org.mule.servlet.default.content.type";
    public static final long DEFAULT_GET_TIMEOUT = 5000L;
    private Map receivers;
    private String payloadParameterName;
    private long timeout = 5000L;
    private boolean feedback = true;
    private String defaultContentType = "text/plain";
    private boolean synchronous = MuleManager.getConfiguration().isSynchronous();
    static /* synthetic */ Class class$org$mule$providers$servlet$MuleRESTReceiverServlet;

    public void init(ServletConfig servletConfig) throws ServletException {
        String timeoutString = servletConfig.getInitParameter(REQUEST_TIMEOUT_PROPERTY);
        if (timeoutString != null) {
            this.timeout = Long.valueOf(timeoutString);
        }
        logger.info((Object)("Default request timeout for GET methods is: " + this.timeout));
        String feedbackString = servletConfig.getInitParameter(FEEDBACK_PROPERTY);
        if (feedbackString != null) {
            this.feedback = Boolean.valueOf(feedbackString);
        }
        logger.info((Object)("feedback is set to: " + this.feedback));
        String ct = servletConfig.getInitParameter(DEFAULT_CONTENT_TYPE_PROPERTY);
        if (ct != null) {
            this.defaultContentType = ct;
        }
        logger.info((Object)("Default content type is: " + this.defaultContentType));
        this.payloadParameterName = servletConfig.getInitParameter("org.mule.servlet.payload.param");
        if (this.payloadParameterName == null) {
            this.payloadParameterName = "payload";
        }
        logger.info((Object)("Using payload param name: " + this.payloadParameterName));
        UMOConnector cnn = null;
        cnn = ConnectorFactory.getConnectorByProtocol("servlet");
        if (cnn == null) {
            throw new ServletException("No servlet connector found using protocol: servlet");
        }
        this.receivers = ((ServletConnector)cnn).getServletReceivers();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        super.service(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            UMOEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            String timeoutString = httpServletRequest.getParameter("timeout");
            long to = this.timeout;
            if (timeoutString != null) {
                to = Long.valueOf(timeoutString);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
            }
            UMOMessage returnMessage = endpoint.getConnector().getDispatcher("ANY").receive(endpoint.getEndpointURI(), to);
            this.writeResponse(httpServletResponse, returnMessage);
        }
        catch (Exception e) {
            this.handleException(e, "Failed to route event through Servlet Receiver", httpServletResponse);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            ServletMessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            MuleMessage message = new MuleMessage(receiver.getConnector().getMessageAdapter(httpServletRequest));
            UMOMessage returnMessage = receiver.routeMessage((UMOMessage)message, true);
            this.writeResponse(httpServletResponse, returnMessage);
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule", httpServletResponse);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            ServletMessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            MuleMessage message = new MuleMessage(receiver.getConnector().getMessageAdapter(httpServletRequest));
            receiver.routeMessage((UMOMessage)message, this.synchronous);
            httpServletResponse.setStatus(201);
            if (this.feedback) {
                httpServletResponse.getWriter().write("Item was created at endpointUri: " + receiver.getEndpointURI());
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule" + e.getMessage(), httpServletResponse);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            UMOMessage returnMessage;
            UMOEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            String timeoutString = httpServletRequest.getParameter("timeout");
            long to = this.timeout;
            if (timeoutString != null) {
                to = Long.valueOf(timeoutString);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
            }
            if ((returnMessage = endpoint.getConnector().getDispatcher("ANY").receive(endpoint.getEndpointURI(), to)) != null) {
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.setStatus(204);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Delete mule event via receive using uri: " + httpServletRequest.getPathInfo(), httpServletResponse);
        }
    }

    protected void writeResponse(HttpServletResponse response, UMOMessage message) throws Exception {
        if (message == null) {
            response.setStatus(204);
            if (this.feedback) {
                response.setStatus(200);
                response.getWriter().write("Action was processed successfully. There was no result");
            }
        } else {
            String contentType = (String)message.getProperty("contentType");
            if (contentType == null) {
                contentType = this.defaultContentType;
            }
            if (!contentType.startsWith("text")) {
                response.setContentType(contentType);
                response.getOutputStream().write(message.getPayloadAsBytes());
            } else {
                response.setContentType(contentType);
                response.getWriter().write(message.getPayloadAsString());
            }
            response.setStatus(200);
        }
    }

    protected UMOEndpoint getEndpointForURI(HttpServletRequest httpServletRequest) throws EndpointException, MalformedEndpointException {
        UMOEndpoint endpoint;
        UMOSession session;
        int i;
        String uri = httpServletRequest.getPathInfo();
        if (uri == null) {
            throw new EndpointException(new Message("servlet", 1, (Object)httpServletRequest.getRequestURI()));
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ((i = uri.indexOf("/")) == -1 && (session = MuleManager.getInstance().getModel().getComponentSession(uri)) == null) {
            throw new EndpointException(new Message("servlet", 2, (Object)uri));
        }
        String endpointName = uri.substring(0, i);
        String endpointAddress = httpServletRequest.getParameter("endpoint");
        if (endpointAddress == null && i < uri.length()) {
            endpointAddress = uri.substring(i + 1);
        }
        if ((endpoint = MuleManager.getInstance().lookupEndpoint(endpointName)) == null && (endpoint = MuleObjectHelper.getEndpointByProtocol(endpointName)) == null) {
            throw new EndpointNotFoundException(endpointName);
        }
        if (endpointAddress != null) {
            endpointAddress = endpoint.getEndpointURI().getScheme() + "://" + endpointAddress;
            endpoint.setEndpointURI(new MuleEndpointURI(endpointAddress));
        }
        return endpoint;
    }

    protected ServletMessageReceiver getReceiverForURI(HttpServletRequest httpServletRequest) throws EndpointException {
        ServletMessageReceiver receiver;
        String uri = httpServletRequest.getPathInfo();
        if (uri == null) {
            throw new EndpointException(new Message("servlet", 1, (Object)httpServletRequest.getRequestURI()));
        }
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ((receiver = (ServletMessageReceiver)this.receivers.get(uri)) == null) {
            throw new NoReceiverForEndpointException("No receiver found for endpointUri: " + uri);
        }
        return receiver;
    }

    protected String getEventPayload(HttpServletRequest request) throws IOException {
        String payload = request.getParameter(this.payloadParameterName);
        if (payload == null) {
            String line;
            BufferedReader reader = request.getReader();
            StringBuffer buffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append("\n");
            }
            payload = buffer.toString();
        }
        return payload;
    }

    protected void handleException(Throwable exception, String message, HttpServletResponse response) {
        logger.error((Object)("message: " + exception.getMessage()), exception);
        response.setStatus(500);
        try {
            response.sendError(500, message + ": " + exception.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)("Failed to sendError on response: " + e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

