/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.ssl;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.Utility;

public class SslConnector
extends TcpConnector {
    public static final String DEFAULT_KEYSTORE = ".keystore";
    public static final String DEFAULT_KEYSTORE_TYPE = KeyStore.getDefaultType();
    public static final String DEFAULT_MANAGER_ALGORITHM = "SunX509";
    public static final String DEFAULT_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    private String keyStore = ".keystore";
    private String keyPassword = null;
    private String storePassword = null;
    private String keystoreType = KeyStore.getDefaultType();
    private String keyManagerAlgorithm = "SunX509";
    private java.security.Provider provider = new Provider();
    private String protocolHandler = "com.sun.net.ssl.internal.www.protocol";
    private String clientKeyStore = null;
    private String clientKeyStorePassword = null;
    private String trustStore = null;
    private String trustStorePassword = null;
    private boolean explicitTrustStoreOnly = false;
    private KeyManagerFactory keyManagerFactory = null;
    private boolean requireClientAuthentication = true;

    public void doInitialise() throws InitialisationException {
        if (this.getProvider() == null) {
            throw new NullPointerException("The security provider cannot be null");
        }
        if (this.getKeyStore() == null) {
            throw new NullPointerException("The KeyStore location cannot be null");
        }
        if (this.getKeyPassword() == null) {
            throw new NullPointerException("The Key password cannot be null");
        }
        if (this.getStorePassword() == null) {
            throw new NullPointerException("The KeyStore password cannot be null");
        }
        if (this.getKeyManagerAlgorithm() == null) {
            throw new NullPointerException("The Key Manager Algorithm cannot be null");
        }
        KeyStore keystore = null;
        try {
            Security.addProvider(this.getProvider());
            keystore = KeyStore.getInstance(this.keystoreType);
            InputStream is = Utility.loadResource(this.getKeyStore(), this.getClass());
            if (is == null) {
                throw new FileNotFoundException("Failed to load keystore from classpath or local file: " + this.getKeyStore());
            }
            keystore.load(is, this.getKeyPassword().toCharArray());
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(58, "KeyStore: " + this.getKeyStore()), e, this);
        }
        try {
            this.keyManagerFactory = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm());
            this.keyManagerFactory.init(keystore, this.getStorePassword().toCharArray());
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(58, "Key Manager (" + this.getKeyManagerAlgorithm() + ")"), e, this);
        }
        super.doInitialise();
        if (this.protocolHandler != null) {
            System.setProperty("java.protocol.handler.pkgs", this.protocolHandler);
        }
        if (this.clientKeyStore != null) {
            try {
                String clientPath = Utility.getResourcePath(this.clientKeyStore, this.getClass());
                System.setProperty("javax.net.ssl.keyStore", clientPath);
                System.setProperty("javax.net.ssl.keyStorePassword", this.clientKeyStorePassword);
                this.logger.info((Object)("Set Client Key store: javax.net.ssl.keyStore=" + clientPath));
            }
            catch (IOException e) {
                throw new InitialisationException(new Message(58, "Client KeyStore: " + this.clientKeyStore), e, this);
            }
        }
        if (this.trustStore != null) {
            System.setProperty("javax.net.ssl.trustStore", this.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
            this.logger.debug((Object)("Set Trust store: javax.net.ssl.trustStore=" + this.getTrustStore()));
        } else if (!this.isExplicitTrustStoreOnly()) {
            this.logger.info((Object)"Defaulting trust store to client Key Store");
            this.trustStore = this.getClientKeyStore();
            this.trustStorePassword = this.getClientKeyStorePassword();
            System.setProperty("javax.net.ssl.trustStore", this.getTrustStore());
            System.setProperty("javax.net.ssl.trustStorePassword", this.getTrustStorePassword());
            this.logger.debug((Object)("Set Trust store: javax.net.ssl.trustStore=" + this.getTrustStore()));
        }
    }

    public String getProtocol() {
        return "SSL";
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(String storePassword) {
        this.storePassword = storePassword;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public boolean isRequireClientAuthentication() {
        return this.requireClientAuthentication;
    }

    public void setRequireClientAuthentication(boolean requireClientAuthentication) {
        this.requireClientAuthentication = requireClientAuthentication;
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public java.security.Provider getProvider() {
        return this.provider;
    }

    public void setProvider(java.security.Provider provider) {
        this.provider = provider;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protocolHandler) {
        this.protocolHandler = protocolHandler;
    }

    public String getClientKeyStore() {
        return this.clientKeyStore;
    }

    public void setClientKeyStore(String clientKeyStore) throws IOException {
        this.clientKeyStore = clientKeyStore;
        if (this.clientKeyStore != null) {
            this.clientKeyStore = Utility.getResourcePath(clientKeyStore, this.getClass());
            this.logger.debug((Object)("Normalised clientKeyStore path to: " + this.getClientKeyStore()));
        }
    }

    public String getClientKeyStorePassword() {
        return this.clientKeyStorePassword;
    }

    public void setClientKeyStorePassword(String clientKeyStorePassword) {
        this.clientKeyStorePassword = clientKeyStorePassword;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) throws IOException {
        this.trustStore = trustStore;
        if (this.trustStore != null) {
            this.trustStore = Utility.getResourcePath(trustStore, this.getClass());
            this.logger.debug((Object)("Normalised trustStore path to: " + this.getTrustStore()));
        }
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public boolean isExplicitTrustStoreOnly() {
        return this.explicitTrustStoreOnly;
    }

    public void setExplicitTrustStoreOnly(boolean explicitTrustStoreOnly) {
        this.explicitTrustStoreOnly = explicitTrustStoreOnly;
    }
}

