/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stream;

import java.io.InputStream;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.stream.StreamConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;

public class StreamMessageReceiver
extends PollingMessageReceiver {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufferSize = 8192;
    private InputStream inputStream;

    public StreamMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, InputStream stream, Long checkFrequency) throws InitialisationException {
        super(connector, component, endpoint, checkFrequency);
        this.inputStream = stream;
    }

    public void poll() {
        try {
            StringBuffer message = new StringBuffer();
            byte[] buf = new byte[this.getBufferSize()];
            int len = this.inputStream.read(buf);
            if (len == -1) {
                return;
            }
            message.append(new String(buf, 0, len));
            MuleMessage umoMessage = new MuleMessage(this.connector.getMessageAdapter(message.toString()));
            this.routeMessage((UMOMessage)umoMessage, this.endpoint.isSynchronous());
            ((StreamConnector)this.endpoint.getConnector()).reinitialise();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

