/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stream;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.mule.providers.stream.StreamConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class SystemStreamConnector
extends StreamConnector {
    private String promptMessage;
    InputStream inputStream;
    PrintStream outputStream;
    private long messageDelayTime = 0L;

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        this.inputStream = System.in;
        this.outputStream = System.out;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public synchronized void startConnector() {
        if (this.receivers.size() > 0) {
            this.reinitialise();
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void reinitialise() {
        DelayedMessageWriter writer = new DelayedMessageWriter(this.getMessageDelayTime());
        writer.start();
    }

    public String getPromptMessage() {
        return this.promptMessage;
    }

    public void setPromptMessage(String promptMessage) {
        this.promptMessage = promptMessage;
    }

    public UMOConnector getConnector() {
        return this;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (this.receivers.size() > 0) {
            throw new UnsupportedOperationException("You can only register one listener per system stream connector");
        }
        UMOMessageReceiver receiver = super.registerListener(component, endpoint);
        this.reinitialise();
        return receiver;
    }

    public long getMessageDelayTime() {
        return this.messageDelayTime;
    }

    public void setMessageDelayTime(long messageDelayTime) {
        this.messageDelayTime = messageDelayTime;
    }

    private class DelayedMessageWriter
    extends Thread {
        private long delay = 0L;

        public DelayedMessageWriter(long delay) {
            this.delay = delay;
        }

        public void run() {
            if (this.delay > 0L) {
                try {
                    DelayedMessageWriter.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SystemStreamConnector.this.outputStream.println("\n" + SystemStreamConnector.this.promptMessage);
        }
    }
}

