/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;

public class UdpMessageAdapter
extends AbstractMessageAdapter {
    public static final String ADDRESS_PROPERTY = "packet.address";
    public static final String PORT_PROPERTY = "packet.port";
    private byte[] message;

    public UdpMessageAdapter(Object message) throws MessagingException {
        DatagramPacket dp;
        if (message instanceof DatagramPacket) {
            dp = (DatagramPacket)message;
            this.message = new byte[dp.getLength()];
            ByteArrayInputStream bais = new ByteArrayInputStream(dp.getData());
            bais.read(this.message, 0, dp.getLength());
            try {
                bais.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        } else {
            throw new MessageTypeNotSupportedException(message, this.getClass());
        }
        this.setProperty(ADDRESS_PROPERTY, dp.getAddress());
        this.setProperty(PORT_PROPERTY, new Integer(dp.getPort()));
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.message);
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.message;
    }

    public Object getPayload() {
        return this.message;
    }
}

