/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.mule.MuleManager;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.udp.UdpConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;

public class UdpMessageDispatcher
extends AbstractMessageDispatcher {
    protected UdpConnector connector;
    protected InetAddress inetAddress;
    protected DatagramSocket socket;
    protected int port;
    protected SynchronizedBoolean initialised = new SynchronizedBoolean(false);

    public UdpMessageDispatcher(UdpConnector connector) {
        super(connector);
        this.connector = connector;
    }

    protected DatagramSocket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(port, inetAddress);
    }

    protected void initialise(String endpoint) throws IOException, URISyntaxException {
        if (!this.initialised.get()) {
            URI uri = new URI(endpoint);
            this.port = uri.getPort();
            this.inetAddress = InetAddress.getByName(uri.getHost());
            this.socket = this.createSocket(this.port, this.inetAddress);
            this.socket.setReceiveBufferSize(this.connector.getBufferSize());
            this.socket.setSendBufferSize(this.connector.getBufferSize());
            this.socket.setSoTimeout(this.connector.getTimeout());
            this.initialised.set(true);
        }
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.initialise(event.getEndpoint().getEndpointURI().getAddress());
        byte[] payload = event.getTransformedMessageAsBytes();
        this.write(this.socket, payload);
    }

    protected void write(DatagramSocket socket, byte[] data) throws IOException {
        DatagramPacket packet = new DatagramPacket(data, data.length);
        if (this.port >= 0) {
            packet.setPort(this.port);
        }
        packet.setAddress(this.inetAddress);
        socket.send(packet);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        if (MuleManager.getConfiguration().isSynchronousReceive()) {
            DatagramPacket result = this.receive(this.socket, this.connector.getTimeout());
            if (result == null) {
                return null;
            }
            MuleMessage message = new MuleMessage(this.connector.getMessageAdapter(result));
            return message;
        }
        return event.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket receive(DatagramSocket socket, int timeout) throws IOException {
        int origTimeout = socket.getSoTimeout();
        try {
            DatagramPacket packet = new DatagramPacket(new byte[this.connector.getBufferSize()], this.connector.getBufferSize());
            socket.setSoTimeout(timeout);
            socket.receive(packet);
            DatagramPacket datagramPacket = packet;
            return datagramPacket;
        }
        finally {
            socket.setSoTimeout(origTimeout);
        }
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        this.initialise(endpointUri.getAddress());
        DatagramPacket result = this.receive(this.socket, Integer.parseInt(String.valueOf(timeout)));
        if (result == null) {
            return null;
        }
        MuleMessage message = new MuleMessage(this.connector.getMessageAdapter(result));
        return message;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
        this.initialised.set(false);
        if (this.socket != null) {
            this.socket.close();
        }
    }
}

